/**
 * <p>This file contains the default devices that will appear when the emulator
 * is first run. A user is able to delete and modify these from the Emulator's
 * UI. If the user deletes all of the emulator's devices then these default
 * devices will appear again.</p>
 *
 * <p>Each device is represented by an object with the following properties:</p>
 *
 * <ul>
 * 
 * <li>title {String} The name of the device.
 * 
 * <li>media {String} Device's media type (for media queries), one of: 'handheld',
 *   'tv' or 'screen'.
 *   
 * <li>screen {Array} An array of two integers representing the widget and height
 *   of the device screen respectively.
 *   
 * <li>rotatable {Boolean} If true then a button will be available to rotate the screen
 *   of the device during runtime (sends appropriate events to the widget).
 *   
 * <li>chrome {Array} Optional, an array of four integers representing how much space on
 *   the device's screen will be occupied by toolbars (or other device chrome).
 *   The integers represent the size taken by the top,right,bottom,left chrome
 *   respectively.
 *   
 * <li>dock {Array} An array of two integers representing the width and height of
 *   the size of docked widgets. If null then docking will not be available.
 *
 * <li>useragent {String} Optional, if this is present then the useragent will
 *   be set to its value
 *
 * <li>plugins {Array} An array of strings indicating which plugins the device
 *    will use, each string must match the name of a plugin that is available to the emulator.
 *
 * <li>selected {Boolean} Optional, if 'true' then this will be the device profile
 *   that is loaded when the emulator is loaded for the first time.
 *   If more than one profile has this set to true then whichever is earlier in
 *   the list prevails.
 *
 */


Control.devicesDefault = [
  {
    title: 'VGA Mobile',
    media: 'screen',
    screen: [480, 640],
    storage: 20480, // 20KB storage
    rotatable: true,
    chrome: [53,0,65,0],
    dock: [64, 64],
    useragent: null,
    plugins: ['Network Security', 'XHR Throttler'],
    selected: true
  },
  {
    title: 'QVGA Mobile',
    media: 'screen',
    screen: [240, 320],
    storage: 20480, // 20KB storage
    rotatable: true,
    chrome: [26,0,33,0],
    dock: [64, 64],
    useragent: null,
    plugins: ['Network Security', 'XHR Throttler']
  },
  {
    title: 'WVGA Mobile',
    media: 'screen',
    screen: [800, 480],
    storage: 20480, // 20KB storage
    rotatable: true,
    chrome: [53,0,65,0],
    dock: [64, 64],
    useragent: null,
    plugins: ['Network Security', 'XHR Throttler']
  },
  {
    title: 'Desktop',
    media: 'screen',
    screen: [800, 600],
    storage: 2097152, // 2MB storage
    rotatable: true,
    chrome: null,
    dock: null,
    useragent: null,
    plugins: ['Network Security']
  },
  {
    title: 'TV',
    media: 'tv',
    screen: [800, 480],
    storage: 204800, // 200KB storage
    rotatable: false,
    chrome: null,
    dock: null,
    useragent: null,
    plugins: ['Network Security']
  }
];
