// Modified version of http://userjs.org/scripts/download/browser/enhancements/linkify-txt.js
// with permission from Arve Bersvendsen

String.prototype.linkify = function() {
  var urlRegex = /\b(((https?|ftp):\/\/|(data|spotify):|www)[^\s\"<>\{\}\'\(\)]+)/ig;
  
  // text to links
  String.prototype.rStrip = function() {
    var endval = "";
    var link = arguments[0];
    // try to deal with ampersands, quotes and similar in a nice fashion
    if (link.substr(-6).indexOf("&quot;") != -1) {
      endval = "&quot;"
      link = link.substring(0,link.length-6);
    } else if (link.substr(-4).indexOf("&gt;") != -1) {
      endval = "&gt;"
      link = link.substring(0,link.length-4);
    } else if (link.substr(-1).match(/[,.!?\)\']$/)) {
      endval = link.substr(-1);
      if (link.substr(-7,6).indexOf("&quot;") != -1) {
        endval = "&quot;"+endval;
        link = link.substring(0,link.length-7);
      } else if (link.substr(-5,4).indexOf("&gt;") != -1) {
        endval = "&gt;"+endval;
        link = link.substring(0,link.length-5);
      } else {
        link = link.substring(0,link.length-1);
      }
    }
    if (link.substring(0, 3) == 'www') link = 'http://' + link;
    return "<a href=\""+link+"\" class='external'>"+link+"</a>"+endval;
  }
  
  var text = this.replace(urlRegex,RegExp.$1.rStrip);
  
  // text to username links
  text = text.replace(/\B@(\w+)/g, "<span class='replytoname'>@<a href='http://twitter.com/$1'>$1</a></span>");
  
  // hash tags
  text = text.replace(/(^|\s)#([\w\-]+)/g, "$1<a class='hashtag' href='http://search.twitter.com/search?q=%23$2'>#$2</a>");
  
  return text;
}
