/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.util;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.circuitbreaker.CircuitBreakerConfiguration;
import com.oracle.bmc.circuitbreaker.NoCircuitBreakerConfiguration;
import java.time.Duration;
import java.util.concurrent.ThreadLocalRandom;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CircuitBreakerUtils {
    private static final Logger LOG = LoggerFactory.getLogger(CircuitBreakerUtils.class);
    private static volatile CircuitBreakerConfiguration defaultCircuitBreakerConfiguration;
    private static final int DEFAULT_FAILURE_RATE_THRESHOLD_FOR_AUTH_CLIENT_CB = 65;
    private static final int DEFAULT_MINIMUM_NUMBER_OF_CALLS_FOR_AUTH_CLIENT_CB = 3;
    private static final int DEFAULT_MINIMUM_WAIT_DURATION_IN_OPEN_STATE_FOR_AUTH_CLIENT_CB = 30;
    private static final int DEFAULT_MAXIMUM_WAIT_DURATION_IN_OPEN_STATE_FOR_AUTH_CLIENT_CB = 49;
    public static final CircuitBreakerConfiguration DEFAULT_CIRCUIT_BREAKER_CONFIGURATION;
    private static final String OCI_SDK_DEFAULT_CIRCUITBREAKER_ENABLED_ENV_VAR = "OCI_SDK_DEFAULT_CIRCUITBREAKER_ENABLED";

    public static CircuitBreakerConfiguration getNoCircuitBreakerConfiguration() {
        return new NoCircuitBreakerConfiguration();
    }

    public static CircuitBreakerConfiguration getDefaultCircuitBreakerConfiguration() {
        return defaultCircuitBreakerConfiguration;
    }

    public static CircuitBreakerConfiguration getUserDefinedCircuitBreakerConfiguration(ClientConfiguration configuration) {
        CircuitBreakerConfiguration circuitBreakerConfiguration = null;
        if (configuration != null) {
            if (configuration.getCircuitBreakerConfiguration() != null) {
                circuitBreakerConfiguration = configuration.getCircuitBreakerConfiguration();
            }
        } else if (defaultCircuitBreakerConfiguration != null) {
            circuitBreakerConfiguration = defaultCircuitBreakerConfiguration;
        } else if (CircuitBreakerUtils.isEnvBasedDefaultCircuitBreakerEnabled()) {
            circuitBreakerConfiguration = DEFAULT_CIRCUIT_BREAKER_CONFIGURATION;
        } else if (!CircuitBreakerUtils.isEnvBasedDefaultCircuitBreakerEnabled()) {
            circuitBreakerConfiguration = CircuitBreakerUtils.getNoCircuitBreakerConfiguration();
        }
        LOG.debug("Circuit breaker configuration in use: {}", (Object)circuitBreakerConfiguration);
        return circuitBreakerConfiguration;
    }

    private static boolean isEnvBasedDefaultCircuitBreakerEnabled() {
        String defaultCircuitBreakerEnvVariable = System.getenv(OCI_SDK_DEFAULT_CIRCUITBREAKER_ENABLED_ENV_VAR);
        return defaultCircuitBreakerEnvVariable == null || !defaultCircuitBreakerEnvVariable.equalsIgnoreCase("false");
    }

    public static void setDefaultCircuitBreakerConfiguration(CircuitBreakerConfiguration defaultCircuitBreakerConfiguration) {
        CircuitBreakerUtils.defaultCircuitBreakerConfiguration = defaultCircuitBreakerConfiguration;
    }

    public static CircuitBreakerConfiguration getDefaultAuthClientCircuitBreakerConfiguration() {
        LOG.debug("Configuring default auth client circuit breaker configuration for federation client");
        return CircuitBreakerConfiguration.builder().minimumNumberOfCalls(3).failureRateThreshold(65).waitDurationInOpenState(Duration.ofSeconds(ThreadLocalRandom.current().nextInt(30, 50))).build();
    }

    static {
        DEFAULT_CIRCUIT_BREAKER_CONFIGURATION = CircuitBreakerConfiguration.builder().build();
    }
}

