/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.wizards;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;
import org.xmind.core.Core;
import org.xmind.ui.internal.wizards.WizardMessages;
import org.xmind.ui.viewers.FileUtils;

public abstract class AbstractExportWizard
extends Wizard
implements IExportWizard {
    protected static final String KEY_PATH_HISTORY = "PATH_HISTORY";
    protected static final String FILTER_ALL_FILES = "*.*";
    private String targetPath;
    private boolean overwriteWithoutPrompt = false;
    private List<String> pathHistory = new ArrayList<String>();
    private List<String> temporaryPaths = null;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.loadDialogSettings();
    }

    protected void loadDialogSettings() {
        if (this.getDialogSettings() != null) {
            this.loadDialogSettings(this.getDialogSettings());
        }
    }

    protected void loadDialogSettings(IDialogSettings settings) {
        String history = settings.get(KEY_PATH_HISTORY);
        if (history != null && !"".equals(history)) {
            String[] paths;
            String[] stringArray = paths = history.split("\\|");
            int n = paths.length;
            int n2 = 0;
            while (n2 < n) {
                String path = stringArray[n2];
                if (!"".equals(path)) {
                    this.pathHistory.add(path);
                }
                ++n2;
            }
        }
        if (!this.pathHistory.isEmpty()) {
            String lastPath = this.pathHistory.get(this.pathHistory.size() - 1);
            this.setTargetPath(this.exchangePath(lastPath, this.getSuggestedFileName()));
        }
    }

    private String exchangePath(String path, String suggestedFileName) {
        StringBuffer sb = new StringBuffer();
        int lastSeparatorIndex = path.lastIndexOf(File.separatorChar);
        if (lastSeparatorIndex >= 0) {
            sb.append(path, 0, lastSeparatorIndex + 1);
        } else {
            sb.append(File.separator);
        }
        sb.append(suggestedFileName);
        return sb.toString();
    }

    protected abstract String getSuggestedFileName();

    public void dispose() {
        this.saveDialogSettings();
        super.dispose();
        this.deleteTemporaryPaths();
    }

    protected void saveDialogSettings() {
        if (this.getDialogSettings() != null) {
            this.saveDialogSettings(this.getDialogSettings());
        }
    }

    protected void saveDialogSettings(IDialogSettings settings) {
        if (this.targetPath != null) {
            if (!this.pathHistory.contains(this.targetPath)) {
                this.pathHistory.add(this.targetPath);
            } else {
                this.pathHistory.remove(this.targetPath);
                this.pathHistory.add(this.targetPath);
            }
            StringBuilder sb = new StringBuilder(this.pathHistory.size() * 20);
            for (String path : this.pathHistory) {
                if (sb.length() > 0) {
                    sb.append('|');
                }
                sb.append(path);
            }
            settings.put(KEY_PATH_HISTORY, sb.toString());
            this.targetPath = null;
        }
    }

    public boolean canFinish() {
        return super.canFinish() && this.hasTargetPath();
    }

    protected void launchTargetFile(boolean fileOrDirectory, final IProgressMonitor monitor, Display display, final Shell parentShell) {
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                new ExportSucceedDialog(parentShell, monitor).open();
            }
        });
    }

    protected String requestTemporaryPath(String applicationName, String fileNameExtension, boolean fileOrDirectory) {
        String tempDir = Core.getWorkspace().getTempDir();
        File mainDir = org.xmind.core.util.FileUtils.ensureDirectory((File)new File(tempDir, "export"));
        StringBuilder sb = new StringBuilder(26 + (applicationName == null ? 0 : applicationName.length() + 1) + (fileNameExtension == null ? 4 : fileNameExtension.length() + 1));
        if (applicationName != null) {
            sb.append(applicationName);
            sb.append('_');
        }
        sb.append(Core.getIdFactory().createId());
        if (fileNameExtension == null) {
            sb.append(".tmp");
        } else {
            if (fileNameExtension.charAt(0) != '.') {
                sb.append('.');
            }
            sb.append(fileNameExtension);
        }
        String name = sb.toString();
        File file = new File(mainDir, name);
        if (!fileOrDirectory) {
            org.xmind.core.util.FileUtils.ensureDirectory((File)file);
        }
        String result = file.getAbsolutePath();
        if (this.temporaryPaths == null) {
            this.temporaryPaths = new ArrayList<String>(3);
        }
        this.temporaryPaths.add(result);
        return result;
    }

    protected void deleteTemporaryPath(String path) {
        if (org.xmind.core.util.FileUtils.delete((File)new File(path)) && this.temporaryPaths != null) {
            this.temporaryPaths.remove(path);
            if (this.temporaryPaths.isEmpty()) {
                this.temporaryPaths = null;
            }
        }
    }

    protected void deleteTemporaryPaths() {
        if (this.temporaryPaths != null) {
            Object[] objectArray = this.temporaryPaths.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                this.deleteTemporaryPath((String)o);
                ++n2;
            }
        }
    }

    protected String cleanFileName(String name) {
        if (name == null) {
            return "";
        }
        return name.replaceAll("\\r\\n|\\r|\\n", " ");
    }

    public void openFile(String path, IProgressMonitor monitor) {
        if (new File(path).exists()) {
            monitor.subTask(WizardMessages.ExportPage_Launching);
            Program.launch((String)path);
        }
    }

    public void showFile(String path, IProgressMonitor monitor) {
        boolean show;
        if (new File(path).exists() && !(show = FileUtils.show((File)new File(path)))) {
            Program.launch((String)new File(path).getParent());
        }
    }

    public void setTargetPath(String path) {
        this.targetPath = path;
    }

    public String getTargetPath() {
        return this.targetPath;
    }

    public boolean hasTargetPath() {
        return this.targetPath != null && !"".equals(this.targetPath);
    }

    public List<String> getPathHistory() {
        return this.pathHistory;
    }

    public void setOverwriteWithoutPrompt(boolean overwriteWithoutPrompt) {
        this.overwriteWithoutPrompt = overwriteWithoutPrompt;
    }

    public boolean isOverwriteWithoutPrompt() {
        return this.overwriteWithoutPrompt;
    }

    protected class ExportSucceedDialog
    extends Dialog {
        private IProgressMonitor monitor;

        protected ExportSucceedDialog(Shell parentShell) {
            super(parentShell);
        }

        public ExportSucceedDialog(Shell parentShell, IProgressMonitor monitor) {
            super(parentShell);
            this.monitor = monitor;
        }

        protected void configureShell(Shell newShell) {
            super.configureShell(newShell);
            newShell.setText(WizardMessages.ExportPage_OpenFileConfirm_title);
        }

        protected Control createDialogArea(Composite parent) {
            Control area = super.createDialogArea(parent);
            Label message = new Label((Composite)area, 0);
            message.setText(WizardMessages.ExportPage_OpenFileConfirm_message);
            return area;
        }

        protected void createButtonsForButtonBar(Composite parent) {
            this.createButton(parent, 11, WizardMessages.ExportPage_OpenFileConfirm_folder, false);
            this.createButton(parent, 0, WizardMessages.ExportPage_OpenFileConfirm_open, true);
            this.createButton(parent, 1, WizardMessages.ExportPage_OpenFileConfirm_close, false);
            this.getButton(0).forceFocus();
        }

        protected void buttonPressed(int buttonId) {
            super.buttonPressed(buttonId);
            if (11 == buttonId) {
                this.openPressed();
            }
        }

        protected void okPressed() {
            AbstractExportWizard.this.openFile(AbstractExportWizard.this.getTargetPath(), this.monitor);
            super.okPressed();
        }

        private void openPressed() {
            AbstractExportWizard.this.showFile(AbstractExportWizard.this.getTargetPath(), this.monitor);
            this.close();
        }
    }
}

