/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.editor;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Iterator;
import org.eclipse.core.runtime.Assert;

public final class URIParser {
    private URIParser() {
        throw new AssertionError();
    }

    public static String quote(String str) {
        try {
            return URLEncoder.encode(str, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    public static String unquote(String str) {
        try {
            return URLDecoder.decode(str, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    public static Iterator<QueryParameter> iterateQueryParameters(URI uri) {
        final String query = uri.getQuery();
        return new Iterator<QueryParameter>(){
            int pos = 0;
            QueryParameter next = this.findNext();

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public QueryParameter next() {
                QueryParameter n = this.next;
                this.next = this.findNext();
                return n;
            }

            @Override
            public void remove() {
            }

            private QueryParameter findNext() {
                String param;
                if (query == null) {
                    return null;
                }
                if (this.pos < 0) {
                    return null;
                }
                int sep = query.indexOf(38, this.pos);
                if (sep < 0) {
                    param = query.substring(this.pos);
                    this.pos = -1;
                } else {
                    param = query.substring(this.pos, sep);
                    this.pos = sep + 1;
                }
                sep = param.indexOf(61);
                if (sep < 0) {
                    return new QueryParameter(URIParser.unquote(param.substring(0)), "");
                }
                return new QueryParameter(URIParser.unquote(param.substring(0, sep)), URIParser.unquote(param.substring(sep + 1)));
            }
        };
    }

    public static String getQueryParameter(URI uri, String name) {
        Assert.isNotNull((Object)uri);
        Assert.isNotNull((Object)name);
        Iterator<QueryParameter> it = URIParser.iterateQueryParameters(uri);
        while (it.hasNext()) {
            QueryParameter param = it.next();
            if (!name.equals(param.name)) continue;
            return param.value;
        }
        return null;
    }

    public static URI appendQueryParameter(URI uri, QueryParameter param) {
        return URIParser.appendQueryParameter(uri, param.name, param.value);
    }

    public static URI appendQueryParameter(URI uri, String name, String value) {
        String query = uri.getQuery();
        if (name != null && name.length() > 0) {
            query = query != null && query.length() > 0 ? String.valueOf(query) + "&" + URIParser.quote(name) : URIParser.quote(name);
            if (value != null && value.length() > 0) {
                query = String.valueOf(query) + "=" + URIParser.quote(value);
            }
        }
        try {
            return new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), uri.getPort(), uri.getPath(), query, uri.getFragment());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static final class QueryParameter {
        public final String name;
        public final String value;

        private QueryParameter(String name, String value) {
            this.name = name;
            this.value = value;
        }
    }
}

