/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.brainstorm;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.GridData;
import org.eclipse.draw2d.GridLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.Layer;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.action.IAction;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.osgi.framework.Bundle;
import org.xmind.gef.IGraphicalViewer;
import org.xmind.gef.draw2d.RotatableWrapLabel;
import org.xmind.gef.draw2d.SizeableImageFigure;
import org.xmind.gef.event.MouseDragEvent;
import org.xmind.gef.event.MouseEvent;
import org.xmind.gef.service.GraphicalViewerService;
import org.xmind.gef.service.IViewerService2;
import org.xmind.gef.ui.actions.IActionRegistry;
import org.xmind.gef.util.Properties;
import org.xmind.ui.brainstorm.Activator;
import org.xmind.ui.brainstorm.actions.TimerAction;
import org.xmind.ui.internal.brainstorm.BrainstormMessages;
import org.xmind.ui.internal.brainstorm.BrainstormViewer;
import org.xmind.ui.internal.brainstorm.FeatureBaseFigure;
import org.xmind.ui.internal.brainstorm.TimerSettingsDialog;
import org.xmind.ui.internal.layers.BaseLayer;
import org.xmind.ui.resources.ColorUtils;
import org.xmind.ui.resources.FontUtils;
import org.xmind.ui.util.Cancelable;

public class TimerService
extends GraphicalViewerService
implements IViewerService2,
PropertyChangeListener {
    private static final String PROPERTY_START = "_start";
    private static final String PROPERTY_STOP = "_stop";
    private static final String PROPERTY_FINISH = "_finish";
    private static final String PROPERTY_TOTAL = "total";
    private static final String PROPERTY_REMAINING = "remaining";
    private static final String SETTING_TOTAL = "timer.total";
    private static final int LED_TWINKLE_INTERVALS = 150;
    private boolean dida = false;
    private Timer timer;
    private FeatureBaseFigure timerFigure;
    private LEDFigure ledFigure;
    private IFigure progressFigure;
    private ControlPaneFigure controlsFigure;
    private SizeableImageFigure startStopFigure;
    private SizeableImageFigure didaSwitchFigure;
    private SizeableImageFigure resetFigure;
    private SizeableImageFigure closeFigure;
    private Map<String, Image> images = null;
    private String hovered = null;
    private long previewTotal = 0L;
    private IFigure mouseTarget = null;
    private long preservingRemainTime = -1L;
    IFigure dragSource = null;
    private Point lastcursorLocation;

    public TimerService(IGraphicalViewer viewer) {
        super(viewer);
    }

    public boolean isDida() {
        return this.dida;
    }

    public void setDida(boolean isDida) {
        this.dida = isDida;
    }

    protected Timer getTimer() {
        if (this.timer == null) {
            this.timer = new Timer();
        }
        return this.timer;
    }

    public Object preserveData() {
        this.preservingRemainTime = this.getTimer().getRemaining();
        return this.preservingRemainTime;
    }

    public void restoreData(Object data) {
        if (data instanceof Long) {
            long restoredTimerNumber;
            this.preservingRemainTime = restoredTimerNumber = ((Long)data).longValue();
            this.getTimer().setRemaining(restoredTimerNumber);
            this.getTimer().start();
        }
        this.preservingRemainTime = -1L;
    }

    protected void activate() {
        Layer layer = this.getViewer().getLayer(BrainstormViewer.LAYER_TIMER);
        if (layer == null) {
            this.getViewer().getLayerManager().insertLayer(BrainstormViewer.LAYER_TIMER, (Layer)new BaseLayer(), null, false);
            layer = this.getViewer().getLayer(BrainstormViewer.LAYER_TIMER);
        }
        if (layer != null) {
            this.timerFigure = new FeatureBaseFigure();
            layer.add((IFigure)this.timerFigure);
            this.timerFigure.setLayoutManager((LayoutManager)new StackLayout());
            this.createTimerContentLayer((IFigure)this.timerFigure);
        }
        this.getTimer().addPropertyChangeListener(this);
        if (this.preservingRemainTime != -1L) {
            if (this.ledFigure != null) {
                this.ledFigure.stopTwinking();
                if (this.previewTotal == 0L) {
                    this.ledFigure.setTime(this.getTimer().getRemaining());
                }
            }
            this.updateIcons();
        }
    }

    private void createTimerContentLayer(IFigure parent) {
        Layer layer = new Layer();
        parent.add((IFigure)layer);
        layer.setLayoutManager((LayoutManager)new StackLayout());
        layer.setBorder((Border)new MarginBorder(5, 10, 0, 0));
        ControlPaneFigure controlPane = new ControlPaneFigure();
        layer.add((IFigure)controlPane);
        controlPane.setAlpha(170);
        controlPane.setBackgroundColor(ColorUtils.getColor((int)176, (int)176, (int)176));
        GridLayout paneLayout = new GridLayout();
        paneLayout.marginWidth = 0;
        paneLayout.marginHeight = 0;
        controlPane.setLayoutManager((LayoutManager)paneLayout);
        Layer contentLayer = new Layer();
        GridLayout contentLayout = new GridLayout();
        contentLayout.marginHeight = 0;
        contentLayout.marginWidth = 0;
        contentLayer.setLayoutManager((LayoutManager)contentLayout);
        controlPane.add((IFigure)contentLayer, new GridData(0x1000000, 0x1000000, true, true));
        this.ledFigure = new LEDFigure();
        GridData ledGridData = new GridData(0x1000000, 0x1000000, true, true);
        contentLayer.add((IFigure)this.ledFigure, (Object)ledGridData);
        this.ledFigure.setText(this.formatTime(this.getTimer().getRemaining()));
        long total = this.getTimer().getTotal();
        Font ledFont = FontUtils.getBold((String)"org.eclipse.jface.defaultfont", (int)30);
        if (total > 360000L) {
            ledFont = FontUtils.getBold((String)"org.eclipse.jface.defaultfont", (int)20);
        } else if (total > 3599L) {
            ledFont = FontUtils.getBold((String)"org.eclipse.jface.defaultfont", (int)25);
        }
        this.ledFigure.setFont(ledFont);
        this.ledFigure.setForegroundColor(Display.getCurrent().getSystemColor(1));
        this.progressFigure = new ProgressFigure();
        this.progressFigure.setSize(160, 5);
        controlPane.add(this.progressFigure, new GridData(4, 1024, true, false));
        this.controlsFigure = new ControlPaneFigure();
        this.controlsFigure.setAlpha(225);
        this.controlsFigure.setBackgroundColor(ColorUtils.getColor((int)140, (int)137, (int)137));
        this.controlsFigure.setVisible(false);
        layer.add((IFigure)this.controlsFigure);
        GridLayout layout = new GridLayout(4, true);
        this.controlsFigure.setLayoutManager((LayoutManager)layout);
        this.didaSwitchFigure = this.createIconButton((IFigure)this.controlsFigure, this.getImage("dida-ring.png"), BrainstormMessages.didaSwitchFigure_toolTip);
        this.startStopFigure = this.createIconButton((IFigure)this.controlsFigure, this.getImage("timer-start.png"), BrainstormMessages.startStopFigure_toolTip);
        this.resetFigure = this.createIconButton((IFigure)this.controlsFigure, this.getImage("timer-reset.png"), BrainstormMessages.resetFigure_toolTip);
        this.closeFigure = this.createIconButton((IFigure)this.controlsFigure, this.getImage("timer-close.png"), BrainstormMessages.closeFigure_toolTip);
    }

    private SizeableImageFigure createIconButton(IFigure parent, Image image, String toolTip) {
        SizeableImageFigure figure = new SizeableImageFigure(image);
        figure.setPreferredSize(figure.getImageSize());
        figure.setToolTip((IFigure)new Label(toolTip));
        parent.add((IFigure)figure, (Object)new GridData(0x1000000, 0x1000000, true, true));
        return figure;
    }

    private Image getImage(String name) {
        Image image;
        if (this.hovered != null && this.hovered.equals(name)) {
            name = Activator.toHover(name);
        }
        if (this.images == null) {
            this.images = new HashMap<String, Image>();
        }
        if ((image = this.images.get(name)) == null && this.isActive()) {
            image = Activator.getImageDescriptor(name).createImage();
            this.images.put(name, image);
        }
        return image;
    }

    public void setActive(boolean active) {
        super.setActive(active);
        IActionRegistry actionRegistry = (IActionRegistry)this.getViewer().getAdapter(IActionRegistry.class);
        IAction action = actionRegistry.getAction("org.xmind.ui.brainstorm.timerAction");
        if (action instanceof TimerAction) {
            ((TimerAction)action).update();
        }
    }

    protected void deactivate() {
        if (this.ledFigure != null) {
            this.ledFigure.stopTwinking();
            this.ledFigure = null;
        }
        if (this.timerFigure != null) {
            if (this.timerFigure.getParent() != null) {
                this.timerFigure.getParent().remove((IFigure)this.timerFigure);
            }
            this.timerFigure = null;
            this.startStopFigure = null;
            this.didaSwitchFigure = null;
            this.resetFigure = null;
            this.closeFigure = null;
            this.progressFigure = null;
        }
        if (this.images != null) {
            for (Image image : this.images.values()) {
                image.dispose();
            }
            this.images = null;
        }
        this.getTimer().removePropertyChangeListener(this);
        this.getTimer().reset();
        this.timer = null;
    }

    public void propertyChange(final PropertyChangeEvent evt) {
        this.getViewer().getControl().getDisplay().asyncExec(new Runnable(){

            public void run() {
                if (TimerService.PROPERTY_REMAINING.equals(evt.getPropertyName())) {
                    if (TimerService.this.ledFigure != null) {
                        TimerService.this.ledFigure.stopTwinking();
                        if (TimerService.this.previewTotal == 0L) {
                            TimerService.this.ledFigure.setTime(TimerService.this.getTimer().getRemaining());
                        }
                    }
                    if (TimerService.this.progressFigure != null) {
                        TimerService.this.progressFigure.repaint();
                    }
                } else if (TimerService.PROPERTY_START.equals(evt.getPropertyName())) {
                    if (TimerService.this.ledFigure != null) {
                        TimerService.this.ledFigure.stopTwinking();
                    }
                    if ("timer-start.png".equals(TimerService.this.hovered)) {
                        TimerService.this.hovered = "timer-stop.png";
                    }
                    TimerService.this.updateIcons();
                } else if (TimerService.PROPERTY_STOP.equals(evt.getPropertyName())) {
                    if (TimerService.this.ledFigure != null) {
                        TimerService.this.ledFigure.stopTwinking();
                    }
                    if ("timer-stop.png".equals(TimerService.this.hovered)) {
                        TimerService.this.hovered = "timer-start.png";
                    }
                    TimerService.this.updateIcons();
                } else if (TimerService.PROPERTY_FINISH.equals(evt.getPropertyName())) {
                    if (TimerService.this.ledFigure != null) {
                        TimerService.this.ledFigure.twinkle();
                    }
                    TimerService.this.getTimer().endlessFlighWork();
                }
            }
        });
    }

    private void updateIcons() {
        if (this.startStopFigure != null) {
            if (this.isCounting()) {
                this.startStopFigure.setImage(this.getImage("timer-stop.png"));
            } else {
                this.startStopFigure.setImage(this.getImage("timer-start.png"));
            }
        }
        if (this.didaSwitchFigure != null) {
            if (this.isDida()) {
                this.didaSwitchFigure.setImage(this.getImage("dida-ring.png"));
            } else {
                this.didaSwitchFigure.setImage(this.getImage("dida-muter.png"));
            }
        }
        if (this.resetFigure != null) {
            this.resetFigure.setImage(this.getImage("timer-reset.png"));
        }
        if (this.closeFigure != null) {
            this.closeFigure.setImage(this.getImage("timer-close.png"));
        }
    }

    private String formatTime(long time) {
        if (this.getTimer().getTotal() > 360000L) {
            return String.format("%03d:%02d:%02d", time / 3600L, time % 3600L / 60L, time % 3600L % 60L);
        }
        if (this.getTimer().getTotal() > 3599L) {
            return String.format("%02d:%02d:%02d", time / 3600L, time % 3600L / 60L, time % 3600L % 60L);
        }
        return String.format("%02d:%02d", time / 60L, time % 60L);
    }

    public boolean isCounting() {
        return this.getTimer().isCounting();
    }

    public void stop() {
        this.getTimer().stop();
    }

    public void start() {
        this.getTimer().start();
    }

    public IFigure getToolTip(Point position) {
        if (this.startStopFigure != null && this.startStopFigure.containsPoint(position)) {
            return this.startStopFigure.getToolTip();
        }
        if (this.didaSwitchFigure != null && this.didaSwitchFigure.containsPoint(position)) {
            return this.didaSwitchFigure.getToolTip();
        }
        if (this.resetFigure != null && this.resetFigure.containsPoint(position)) {
            return this.resetFigure.getToolTip();
        }
        if (this.closeFigure != null && this.closeFigure.containsPoint(position)) {
            return this.closeFigure.getToolTip();
        }
        return null;
    }

    public boolean handleMouseMove(MouseEvent me) {
        Point p = this.getViewer().getZoomManager().getScaled(me.cursorLocation);
        IFigure oldTarget = this.mouseTarget;
        if (this.timerFigure != null && this.timerFigure.containsPoint(p)) {
            boolean inCloseFigure;
            if (this.controlsFigure != null) {
                this.controlsFigure.setVisible(true);
            }
            boolean inStartFigure = this.startStopFigure != null && this.startStopFigure.containsPoint(p);
            boolean inDidaFigure = this.didaSwitchFigure != null && this.didaSwitchFigure.containsPoint(p);
            boolean inResetFigure = this.resetFigure != null && this.resetFigure.containsPoint(p);
            boolean bl = inCloseFigure = this.closeFigure != null && this.closeFigure.containsPoint(p);
            if (inStartFigure || inDidaFigure || inResetFigure || inCloseFigure) {
                if (inStartFigure) {
                    this.mouseTarget = this.startStopFigure;
                    this.hovered = this.isCounting() ? "timer-stop.png" : "timer-start.png";
                } else if (inDidaFigure) {
                    this.mouseTarget = this.didaSwitchFigure;
                    this.hovered = this.isDida() ? "dida-ring.png" : "dida-muter.png";
                } else if (inResetFigure) {
                    this.mouseTarget = this.resetFigure;
                    this.hovered = "timer-reset.png";
                } else if (inCloseFigure) {
                    this.mouseTarget = this.closeFigure;
                    this.hovered = "timer-close.png";
                }
                this.updateIcons();
            } else {
                this.mouseTarget = null;
                this.hovered = null;
                this.updateIcons();
            }
        } else {
            if (this.controlsFigure != null) {
                this.controlsFigure.setVisible(false);
            }
            this.mouseTarget = null;
            this.hovered = null;
            this.updateIcons();
        }
        if (oldTarget != this.mouseTarget) {
            this.getViewer().updateToolTip();
        }
        return false;
    }

    public boolean handleMouseDown(MouseEvent me) {
        Point p = this.getViewer().getZoomManager().getScaled(me.cursorLocation);
        if (this.startStopFigure != null && this.startStopFigure.containsPoint(p)) {
            if (this.getTimer().isCounting()) {
                this.getTimer().stop();
            } else {
                this.getTimer().start();
            }
            return true;
        }
        if (this.didaSwitchFigure != null && this.didaSwitchFigure.containsPoint(p)) {
            this.setDida(!this.isDida());
            if (this.getTimer().isCounting()) {
                this.start();
            }
            return true;
        }
        if (this.resetFigure != null && this.resetFigure.containsPoint(p)) {
            this.getTimer().reset();
            Shell activeShell = Display.getCurrent().getActiveShell();
            if (activeShell != null) {
                TimerSettingsDialog timerSettingsDialog = new TimerSettingsDialog(this.getViewer(), activeShell);
                timerSettingsDialog.open();
            }
        } else if (this.closeFigure != null && this.closeFigure.containsPoint(p) && this.isActive()) {
            this.setActive(false);
            return true;
        }
        if (this.timerFigure != null && this.timerFigure.containsPoint(p)) {
            this.dragSource = this.timerFigure;
            this.lastcursorLocation = p;
            return true;
        }
        return false;
    }

    public boolean handleMouseDoubleClick(MouseEvent me) {
        Point p = this.getViewer().getZoomManager().getScaled(me.cursorLocation);
        return this.timerFigure != null && this.timerFigure.containsPoint(p);
    }

    public boolean handleMouseUp(MouseEvent me) {
        if (this.dragSource == null || this.timerFigure == null) {
            return false;
        }
        if (this.dragSource == this.timerFigure) {
            this.dragSource = null;
            return true;
        }
        return false;
    }

    public boolean handleMouseDrag(MouseDragEvent me) {
        if (this.dragSource == null || this.timerFigure == null || this.lastcursorLocation == null) {
            return false;
        }
        if (this.dragSource == this.timerFigure) {
            Point targetPoint = this.getViewer().getZoomManager().getScaled(me.cursorLocation);
            Rectangle rect = new Rectangle();
            rect.x = this.timerFigure.getBounds().x + targetPoint.x - this.lastcursorLocation.x;
            rect.y = this.timerFigure.getBounds().y + targetPoint.y - this.lastcursorLocation.y;
            rect.width = this.timerFigure.getBounds().width;
            rect.height = this.timerFigure.getBounds().height;
            this.timerFigure.setBounds(rect);
            this.lastcursorLocation = targetPoint;
            return true;
        }
        return false;
    }

    public boolean handleMouseEntered(MouseEvent me) {
        Point p = this.getViewer().getZoomManager().getScaled(me.cursorLocation);
        return this.timerFigure != null && this.timerFigure.isVisible() && this.timerFigure.containsPoint(p);
    }

    private class ControlPaneFigure
    extends Figure {
        private int alpha;

        public void setAlpha(int alpha) {
            this.alpha = alpha;
        }

        protected void paintFigure(Graphics graphics) {
            super.paintFigure(graphics);
            graphics.setAntialias(1);
            Rectangle rect = this.getBounds();
            graphics.setAlpha(this.alpha);
            graphics.fillRectangle(rect);
        }
    }

    private class LEDFigure
    extends RotatableWrapLabel {
        private boolean twinkling = false;

        public LEDFigure() {
            this.setEnabled(true);
            this.setTextAlignment(1);
        }

        public void setTime(long time) {
            this.setText(TimerService.this.formatTime(time));
            this.repaint();
        }

        public void twinkle() {
            boolean oldTwinkling = this.twinkling;
            this.twinkling = true;
            this.setEnabled(true);
            this.repaint();
            if (!oldTwinkling) {
                this.scheduleTwinkle();
            }
        }

        public void stopTwinking() {
            this.twinkling = false;
            this.setEnabled(true);
            this.repaint();
        }

        private void scheduleTwinkle() {
            if (!this.twinkling) {
                return;
            }
            this.setEnabled(!this.isEnabled());
            this.repaint();
            Display.getCurrent().timerExec(150, new Runnable(){

                public void run() {
                    LEDFigure.this.scheduleTwinkle();
                }
            });
        }

        protected void paintFigure(Graphics graphics) {
            if (this.isEnabled()) {
                super.paintFigure(graphics);
            }
        }
    }

    private class ProgressFigure
    extends Figure {
        private ProgressFigure() {
        }

        protected void paintFigure(Graphics graphics) {
            super.paintFigure(graphics);
            graphics.setBackgroundColor(ColorConstants.white);
            Rectangle bounds = this.getBounds();
            graphics.fillRectangle(bounds);
            graphics.setBackgroundColor(ColorUtils.getColor((int)54, (int)161, (int)233));
            float delta = (float)TimerService.this.getTimer().getElapsed() * 1.0f / (float)TimerService.this.getTimer().getTotal();
            int x = bounds.x;
            int y = bounds.y;
            int width = (int)((float)bounds.width * delta);
            int height = bounds.height;
            if ((double)delta > 0.9) {
                graphics.setBackgroundColor(ColorUtils.getColor((int)164, (int)0, (int)0));
            }
            graphics.fillRectangle(new Rectangle(x, y, width, height));
        }
    }

    protected class Timer
    extends Properties {
        private Cancelable worker;
        private Cancelable didaWorker;
        private Cancelable endlessFlighWorker;
        private boolean stopped = false;

        public Timer() {
            long total;
            try {
                total = Activator.getDefault().getDialogSettings().getInt(TimerService.SETTING_TOTAL);
                if (total < 0L) {
                    total = 1500L;
                }
            }
            catch (Exception exception) {
                total = 1500L;
            }
            this.internalSetTotal(total);
            if (TimerService.this.preservingRemainTime != -1L) {
                total = TimerService.this.preservingRemainTime;
            }
            this.setRemaining(total);
        }

        public long getTotal() {
            return (Long)this.get(TimerService.PROPERTY_TOTAL);
        }

        public long getRemaining() {
            return (Long)this.get(TimerService.PROPERTY_REMAINING);
        }

        public long getElapsed() {
            return this.getTotal() - this.getRemaining();
        }

        public void setTotal(long total) {
            this.internalSetTotal(total);
            this.setRemaining(total);
            Activator.getDefault().getDialogSettings().put(TimerService.SETTING_TOTAL, total);
        }

        private void internalSetTotal(long total) {
            this.set(TimerService.PROPERTY_TOTAL, total);
        }

        public void setRemaining(long remaining) {
            this.set(TimerService.PROPERTY_REMAINING, remaining);
        }

        public void start() {
            if (this.getTotal() <= 0L || this.getRemaining() <= 0L) {
                return;
            }
            this.timeWork();
            this.didaWork();
            this.getDelegate().firePropertyChange(TimerService.PROPERTY_START, false, true);
        }

        public void endlessFlighWork() {
            if (this.getRemaining() == 0L && this.endlessFlighWorker == null) {
                this.endlessFlighWorker = new Cancelable(){

                    /*
                     * Loose catch block
                     */
                    protected void doJob() {
                        block27: {
                            URL url = FileLocator.find((Bundle)Platform.getBundle((String)"org.xmind.ui.brainstorm"), (IPath)new Path("$nl$/resource/end.wav"), null);
                            if (url == null) {
                                return;
                            }
                            AudioInputStream ais = null;
                            try {
                                ais = AudioSystem.getAudioInputStream(url);
                                Clip clip = AudioSystem.getClip();
                                clip.open(ais);
                                clip.loop(0);
                                while (!this.isCanceled() && Timer.this.getRemaining() == 0L && TimerService.this.isActive()) {
                                    try {
                                        Thread.sleep(0L);
                                    }
                                    catch (InterruptedException interruptedException) {}
                                }
                                clip.close();
                            }
                            catch (UnsupportedAudioFileException e) {
                                Activator.log(e, NLS.bind((String)"the URL:{0} does not point to valid audio file data recognized by the system ", (Object)url));
                                try {
                                    if (ais != null) {
                                        ais.close();
                                    }
                                    break block27;
                                }
                                catch (IOException e2) {
                                    e2.printStackTrace();
                                }
                                break block27;
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                                break block27;
                            }
                            catch (LineUnavailableException e) {
                                Activator.log(e, "The clip object is not available due to resource restrictions ");
                                {
                                    catch (Throwable throwable) {
                                        throw throwable;
                                    }
                                }
                                try {
                                    if (ais != null) {
                                        ais.close();
                                    }
                                    break block27;
                                }
                                catch (IOException e3) {
                                    e3.printStackTrace();
                                }
                                break block27;
                            }
                            {
                                finally {
                                    try {
                                        if (ais != null) {
                                            ais.close();
                                        }
                                    }
                                    catch (IOException e) {
                                        e.printStackTrace();
                                    }
                                }
                            }
                            try {
                                if (ais != null) {
                                    ais.close();
                                }
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                        Timer.this.endlessFlighWorker = null;
                    }
                };
                Thread didaThread = new Thread((Runnable)this.endlessFlighWorker);
                didaThread.setDaemon(true);
                didaThread.start();
            }
        }

        private void didaWork() {
            if (TimerService.this.isDida() && this.didaWorker == null) {
                this.didaWorker = new Cancelable(){

                    /*
                     * Loose catch block
                     */
                    protected void doJob() {
                        block27: {
                            URL url = FileLocator.find((Bundle)Platform.getBundle((String)"org.xmind.ui.brainstorm"), (IPath)new Path("$nl$/resource/dida.wav"), null);
                            if (url == null) {
                                return;
                            }
                            AudioInputStream ais = null;
                            try {
                                ais = AudioSystem.getAudioInputStream(url);
                                Clip clip = AudioSystem.getClip();
                                clip.open(ais);
                                clip.loop(-1);
                                while (!this.isCanceled() && TimerService.this.isDida() && Timer.this.isCounting()) {
                                    try {
                                        Thread.sleep(0L);
                                    }
                                    catch (InterruptedException interruptedException) {}
                                }
                                clip.close();
                            }
                            catch (UnsupportedAudioFileException e) {
                                Activator.log(e, NLS.bind((String)"the URL:{0} does not point to valid audio file data recognized by the system ", (Object)url));
                                try {
                                    if (ais != null) {
                                        ais.close();
                                    }
                                    break block27;
                                }
                                catch (IOException e2) {
                                    e2.printStackTrace();
                                }
                                break block27;
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                                break block27;
                            }
                            catch (LineUnavailableException e) {
                                Activator.log(e, "The clip object is not available due to resource restrictions ");
                                {
                                    catch (Throwable throwable) {
                                        throw throwable;
                                    }
                                }
                                try {
                                    if (ais != null) {
                                        ais.close();
                                    }
                                    break block27;
                                }
                                catch (IOException e3) {
                                    e3.printStackTrace();
                                }
                                break block27;
                            }
                            {
                                finally {
                                    try {
                                        if (ais != null) {
                                            ais.close();
                                        }
                                    }
                                    catch (IOException e) {
                                        e.printStackTrace();
                                    }
                                }
                            }
                            try {
                                if (ais != null) {
                                    ais.close();
                                }
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                        Timer.this.didaWorker = null;
                    }
                };
                Thread didaThread = new Thread((Runnable)this.didaWorker);
                didaThread.setDaemon(true);
                didaThread.start();
            }
        }

        private void timeWork() {
            this.stopped = false;
            if (this.worker == null) {
                this.worker = new Cancelable(){

                    protected void doJob() {
                        long last = System.currentTimeMillis();
                        long delta = System.currentTimeMillis() - last;
                        while (!this.isCanceled() && Timer.this.getRemaining() > 0L) {
                            if (delta >= 1000L) {
                                last = System.currentTimeMillis();
                                Timer.this.setRemaining(Timer.this.getRemaining() - 1L);
                            }
                            if (Timer.this.stopped) {
                                while (Timer.this.stopped) {
                                    try {
                                        Thread.sleep(0L);
                                    }
                                    catch (InterruptedException interruptedException) {}
                                }
                                last = System.currentTimeMillis() - delta;
                            } else {
                                try {
                                    Thread.sleep(0L);
                                }
                                catch (InterruptedException interruptedException) {}
                            }
                            delta = System.currentTimeMillis() - last;
                        }
                        if (!this.isCanceled() && Timer.this.getRemaining() >= 0L) {
                            Timer.this.getDelegate().firePropertyChange(TimerService.PROPERTY_STOP, false, true);
                            if (Timer.this.getRemaining() == 0L) {
                                Timer.this.getDelegate().firePropertyChange(TimerService.PROPERTY_FINISH, false, true);
                            }
                        }
                        Timer.this.worker = null;
                    }
                };
                Thread th = new Thread((Runnable)this.worker);
                th.start();
            }
        }

        public void stop() {
            if (this.worker == null || this.getTotal() <= 0L || this.stopped) {
                return;
            }
            this.stopped = true;
            this.getDelegate().firePropertyChange(TimerService.PROPERTY_STOP, false, true);
        }

        public void reset() {
            this.stopped = false;
            if (this.worker != null) {
                this.worker.cancel();
                this.worker = null;
                this.getDelegate().firePropertyChange(TimerService.PROPERTY_STOP, false, true);
            }
            this.setRemaining(this.getTotal());
        }

        public boolean isCounting() {
            return this.worker != null && !this.stopped;
        }

        public boolean isSleeping() {
            return this.worker != null && this.stopped;
        }

        public boolean isNotWorking() {
            return this.worker == null;
        }
    }
}

