/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.gantt2.gefext;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.TreeSearch;
import org.xmind.gef.GraphicalViewer;
import org.xmind.gef.IViewer;
import org.xmind.gef.part.IGraphicalPart;
import org.xmind.gef.part.IPart;
import org.xmind.ui.gantt2.gefext.IGraphicalViewer2;

public class GraphicalViewer2
extends GraphicalViewer
implements IGraphicalViewer2 {
    private Map<IFigure, IGraphicalPart> viewToPartMap = new HashMap<IFigure, IGraphicalPart>(33);

    public IPart findPart(int x, int y) {
        IFigure figure = this.getLightweightSystem().getRootFigure().findFigureAt(x, y, (TreeSearch)new ConditionalSearch(this.getPartSearchCondition()));
        return figure == null ? null : this.findPartByView(figure);
    }

    protected IGraphicalPart findPartByView(IFigure figure) {
        IGraphicalPart part = null;
        while (part == null && figure != null) {
            part = this.getPartByView(figure);
            figure = figure.getParent();
        }
        return part;
    }

    public IGraphicalPart getPartByView(IFigure figure) {
        return this.viewToPartMap.get(figure);
    }

    public void registerView(IGraphicalPart part, IFigure figure) {
        this.viewToPartMap.put(figure, part);
    }

    public void unregisterView(IGraphicalPart part, IFigure figure) {
        this.viewToPartMap.remove(figure);
    }

    private class ConditionalSearch
    implements TreeSearch {
        private IViewer.IPartSearchCondition condition;

        public ConditionalSearch(IViewer.IPartSearchCondition condition) {
            this.condition = condition;
        }

        public boolean accept(IFigure figure) {
            if (this.condition == null) {
                return true;
            }
            IGraphicalPart part = GraphicalViewer2.this.findPartByView(figure);
            return part != null && this.condition.evaluate((IPart)part);
        }

        public boolean prune(IFigure figure) {
            if (this.condition != null && this.condition instanceof IGraphicalViewer2.GraphicalPartSearchCondition) {
                return ((IGraphicalViewer2.GraphicalPartSearchCondition)this.condition).prune(figure);
            }
            return false;
        }
    }
}

