/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.biggerplate.dialog;

import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.xmind.ui.biggerplate.BiggerplateMessages;
import org.xmind.ui.biggerplate.BiggerplatePlugin;
import org.xmind.ui.internal.biggerplate.Info;
import org.xmind.ui.internal.biggerplate.dialog.CutPreviewViewer;
import org.xmind.ui.resources.FontUtils;

public class BiggerplateUploaderDialog
extends TitleAreaDialog {
    private static final int PREVIEW_IMAGE_WIDTH = 400;
    private static final int PREVIEW_IMAGE_HEIGHT = 180;
    private static final int DESCRIPTION_TEXT_MIN_HEIGHT = 60;
    private Info info;
    private Text titleText;
    private Text descriptionText;
    private CutPreviewViewer viewer;

    public BiggerplateUploaderDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(65648);
        this.setBlockOnOpen(true);
    }

    public Info getInfo() {
        return this.info;
    }

    public void setInfo(Info info) {
        this.info = info;
    }

    public void create() {
        super.create();
        this.setFocus();
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        if (id == 0) {
            label = BiggerplateMessages.UploaderDialog_UploadButton_text;
        }
        return super.createButton(parent, id, label, defaultButton);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(BiggerplateMessages.UploaderDialog_title);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayoutData((Object)new GridData(1808));
        GridLayout layout2 = new GridLayout();
        layout2.marginHeight = 0;
        layout2.marginWidth = 5;
        composite2.setLayout((Layout)layout2);
        Composite container = new Composite(composite2, 2048);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 15;
        layout.marginWidth = 15;
        layout.horizontalSpacing = 20;
        layout.verticalSpacing = 15;
        container.setLayout((Layout)layout);
        container.setLayoutData((Object)new GridData(1808));
        this.createEditTitleArea(container);
        this.createPreviewArea(container);
        this.createDescriptionArea(container);
        this.setTitle(BiggerplateMessages.UploaderDialog_Upload_title);
        this.setMessage(BiggerplateMessages.UploaderDialog_Upload_description);
        if (this.getInfo().getBoolean("multiSheets")) {
            this.setMessage(BiggerplateMessages.UploaderDialog_uploadOneSheet_message);
        }
        return composite;
    }

    private void createEditTitleArea(Composite parent) {
        this.createLabel(parent, BiggerplateMessages.UploaderDialog_TitleLabel_text);
        this.titleText = this.createText(parent, 18436);
        this.titleText.setText(this.info.getString("Title"));
    }

    private void createPreviewArea(Composite parent) {
        this.createLabel(parent, BiggerplateMessages.UploaderDialog_PreviewLabel_text);
        if (this.viewer == null) {
            this.viewer = new CutPreviewViewer();
            this.viewer.setInfo(this.info);
            this.viewer.setPrefHeight(180);
            this.viewer.setPrefWidth(398);
        }
        this.viewer.createControl(parent);
        this.viewer.setBackgroundColor(parent.getBackground());
        this.viewer.getControl().setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.viewer.getControl().addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 2) {
                    BiggerplateUploaderDialog.this.getShell().traverse(e.detail);
                }
            }
        });
        double widthRatio = 400.0 / (double)this.viewer.getImage().getBounds().width;
        double heightRatio = 180.0 / (double)this.viewer.getImage().getBounds().height;
        double ratio = widthRatio < heightRatio ? widthRatio : heightRatio;
        this.viewer.changeRatio(ratio);
    }

    private void createDescriptionArea(Composite parent) {
        this.createLabel(parent, BiggerplateMessages.UploaderDialog_DescriptionLabel_text);
        this.descriptionText = new Text(parent, 18498);
        this.descriptionText.setText(BiggerplateMessages.UploaderDialog_Description_Initial_text);
        final GridData data = new GridData(16384, 4, false, true);
        data.heightHint = 60;
        this.descriptionText.setLayoutData((Object)data);
        this.descriptionText.setData((Object)DescriptionTextStatus.UNUSED);
        final Font font = this.descriptionText.getFont();
        this.descriptionText.setFont(FontUtils.getItalic((Font)font));
        final Color foreground = this.descriptionText.getForeground();
        this.descriptionText.setForeground(parent.getDisplay().getSystemColor(15));
        this.descriptionText.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                BiggerplateUploaderDialog.this.descriptionText.setSize(400, ((BiggerplateUploaderDialog)BiggerplateUploaderDialog.this).descriptionText.computeSize((int)data.widthHint, (int)data.heightHint, (boolean)true).y);
            }
        });
        this.descriptionText.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                BiggerplateUploaderDialog.this.descriptionText.removeFocusListener((FocusListener)this);
            }

            public void focusGained(FocusEvent e) {
                BiggerplateUploaderDialog.this.descriptionText.setData((Object)DescriptionTextStatus.USED);
                BiggerplateUploaderDialog.this.descriptionText.setText("");
                BiggerplateUploaderDialog.this.descriptionText.setFont(font);
                BiggerplateUploaderDialog.this.descriptionText.setForeground(foreground);
            }
        });
    }

    private Label createLabel(Composite parent, String text) {
        Label label = new Label(parent, 0);
        label.setBackground(parent.getBackground());
        GridData data = new GridData(131072, 128, false, false);
        data.verticalIndent = 3;
        label.setLayoutData((Object)data);
        label.setText(text);
        return label;
    }

    private Text createText(Composite parent, int style) {
        final Text text = new Text(parent, style);
        final GridData data = new GridData(16384, 0x1000000, false, false);
        data.widthHint = 393;
        text.setLayoutData((Object)data);
        text.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                text.setSize(400, text.computeSize((int)data.widthHint, (int)data.heightHint, (boolean)true).y);
            }
        });
        return text;
    }

    private void setFocus() {
        this.getButtonBar().setFocus();
    }

    protected IDialogSettings getDialogBoundsSettings() {
        String sectionId;
        IDialogSettings global = BiggerplatePlugin.getDefault().getDialogSettings();
        IDialogSettings settings = global.getSection(sectionId = ((Object)((Object)this)).getClass().getName());
        if (settings == null) {
            settings = global.addNewSection(sectionId);
        }
        return settings;
    }

    protected void okPressed() {
        String title = this.titleText.getText();
        if (title != null && !title.equals("")) {
            this.info.setProperty("Title", title);
        }
        if (this.info.getProperty("Title") == null || this.info.getProperty("Title").equals("")) {
            this.setMessage(BiggerplateMessages.BiggerplateUploaderDialog_NullTitle_error, 3);
            this.titleText.setFocus();
            return;
        }
        if (this.descriptionText.getData().equals((Object)DescriptionTextStatus.USED)) {
            this.info.setProperty("Description", this.descriptionText.getText());
        }
        super.okPressed();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum DescriptionTextStatus {
        UNUSED,
        USED;

    }
}

