/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.gef.util;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Properties
implements Cloneable {
    private Object source;
    private Map<String, Object> contents = new HashMap<String, Object>();
    private PropertyChangeSupport eventSupport;

    public Properties() {
        this.source = this;
        this.eventSupport = new PropertyChangeSupport(this);
    }

    public Properties(Object source) {
        this.source = source;
        this.eventSupport = new PropertyChangeSupport(source);
    }

    public Properties(Properties another) {
        this();
        this.putAll(another);
    }

    public Properties(Object source, Properties another) {
        this(source);
        this.putAll(another);
    }

    protected PropertyChangeSupport getDelegate() {
        return this.eventSupport;
    }

    public void set(String key, boolean value) {
        this.set(key, (Object)value);
    }

    public void set(String key, int value) {
        this.set(key, (Object)value);
    }

    public void set(String key, Object value) {
        Object oldValue = this.contents.get(key);
        if (value != null && !value.equals(oldValue)) {
            this.contents.put(key, value);
            this.eventSupport.firePropertyChange(key, oldValue, value);
        } else if (value == null && value != oldValue) {
            this.contents.remove(key);
            this.eventSupport.firePropertyChange(key, oldValue, value);
        }
    }

    public void putAll(Properties another) {
        if (another == null) {
            return;
        }
        for (Map.Entry<String, Object> entry : another.contents.entrySet()) {
            this.set(entry.getKey(), entry.getValue());
        }
    }

    public Collection<String> keySet() {
        return this.contents.keySet();
    }

    public void remove(String key) {
        this.set(key, null);
    }

    public Object get(String key) {
        return this.contents.get(key);
    }

    public Object get(String key, Object defaultValue) {
        Object value = this.contents.get(key);
        return value == null ? defaultValue : value;
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        Object value = this.get(key);
        return value instanceof Boolean ? (Boolean)value : defaultValue;
    }

    public int getInteger(String key, int defaultValue) {
        Object value = this.get(key);
        return value instanceof Integer ? (Integer)value : defaultValue;
    }

    public String getString(String key, String defaultValue) {
        Object value = this.get(key);
        return value instanceof String ? (String)value : defaultValue;
    }

    public void clear() {
        Iterator<String> ite = this.contents.keySet().iterator();
        while (ite.hasNext()) {
            String key = ite.next();
            Object oldValue = this.contents.get(key);
            ite.remove();
            if (oldValue == null) continue;
            this.eventSupport.firePropertyChange(key, oldValue, null);
        }
    }

    public boolean isEmpty() {
        return this.contents.isEmpty();
    }

    public boolean hasKey(String key) {
        return this.contents.containsKey(key);
    }

    public boolean hasValue(Object value) {
        return this.contents.containsValue(value);
    }

    public Properties clone() {
        Properties newInstance = this.source == this ? new Properties() : new Properties(this.source);
        newInstance.contents.putAll(this.contents);
        return newInstance;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.eventSupport.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.eventSupport.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.eventSupport.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.eventSupport.removePropertyChangeListener(propertyName, listener);
    }
}

