/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.browser;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.EditorActionBarContributor;
import org.xmind.ui.browser.BrowserSupport;
import org.xmind.ui.browser.IBrowser;
import org.xmind.ui.internal.browser.BrowserImages;
import org.xmind.ui.internal.browser.BrowserMessages;
import org.xmind.ui.internal.browser.BrowserPlugin;
import org.xmind.ui.internal.browser.BrowserViewer;
import org.xmind.ui.internal.browser.InternalBrowserEditor;

public class BrowserEditorActionContributor
extends EditorActionBarContributor {
    private OpenInExternalAction openInExternalAction;

    public void init(IActionBars bars) {
        this.openInExternalAction = new OpenInExternalAction();
        super.init(bars);
    }

    public void contributeToMenu(IMenuManager menuManager) {
        IMenuManager fileMenu = menuManager.findMenuUsingPath("file");
        if (fileMenu != null && fileMenu.find("open.ext") != null) {
            fileMenu.prependToGroup("open.ext", (IAction)this.openInExternalAction);
        }
    }

    public void contributeToToolBar(IToolBarManager toolBarManager) {
    }

    public void setActiveEditor(IEditorPart targetEditor) {
        if (targetEditor instanceof InternalBrowserEditor) {
            InternalBrowserEditor editor = (InternalBrowserEditor)targetEditor;
            this.openInExternalAction.setEditor(editor);
            IActionBars bars = this.getActionBars();
            this.setHandler(bars, ActionFactory.COPY.getId(), editor);
            this.setHandler(bars, ActionFactory.CUT.getId(), editor);
            this.setHandler(bars, ActionFactory.PASTE.getId(), editor);
            this.setHandler(bars, ActionFactory.DELETE.getId(), editor);
        }
    }

    private void setHandler(IActionBars bars, String actionId, InternalBrowserEditor editor) {
        IAction handler = editor.getAction(actionId);
        if (handler != null) {
            bars.setGlobalActionHandler(actionId, handler);
        }
    }

    private static class OpenInExternalAction
    extends Action {
        private InternalBrowserEditor editor;

        public OpenInExternalAction() {
            super(BrowserMessages.BrowserView_OpenInExternalBrowser_text, BrowserImages.getImageDescriptor("icons/browser.gif"));
            this.setToolTipText(BrowserMessages.BrowserView_OpenInExternalBrowser_toolTip);
            this.setEnabled(false);
        }

        public void setEditor(InternalBrowserEditor editor) {
            this.editor = editor;
            this.setEnabled(editor != null);
        }

        public void run() {
            if (this.editor == null) {
                return;
            }
            BrowserViewer viewer = this.editor.getViewer();
            if (viewer == null || viewer.getControl() == null || viewer.getControl().isDisposed()) {
                return;
            }
            IBrowser browser = BrowserSupport.getInstance().createBrowser(1);
            try {
                browser.openURL(viewer.getURL());
            }
            catch (PartInitException e) {
                BrowserPlugin.log(e);
            }
        }
    }
}

