/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.taskinfo;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TableViewerEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.xmind.core.ITopic;
import org.xmind.ui.forms.WidgetFactory;
import org.xmind.ui.internal.taskinfo.Dependency;
import org.xmind.ui.internal.taskinfo.DependencyEditDialog;
import org.xmind.ui.internal.taskinfo.TaskInfo;
import org.xmind.ui.internal.taskinfo.TaskInfoUtils;
import org.xmind.ui.internal.taskinfo.TaskInfoViewerPart;
import org.xmind.ui.internal.taskinfo.TaskMessages;
import org.xmind.ui.mindmap.MindMapUI;

public class DependencyViewer
extends TaskInfoViewerPart {
    private TableViewer viewer = null;
    private IAction addDependencyAction = null;
    private IAction removeDependencyAction = null;
    private Label noneLabel = null;
    private Composite parent = null;

    protected Control doCreateControl(Composite parent, WidgetFactory factory) {
        this.parent = parent;
        Composite composite = factory.createComposite(parent);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 5;
        composite.setLayout((Layout)gridLayout);
        Composite composite2 = factory.createComposite(composite);
        composite2.setLayoutData((Object)new GridData(4, 4, true, false));
        GridLayout gridLayout2 = new GridLayout(4, false);
        gridLayout2.marginWidth = 0;
        gridLayout2.marginHeight = 0;
        gridLayout2.horizontalSpacing = 5;
        gridLayout2.verticalSpacing = 0;
        composite2.setLayout((Layout)gridLayout2);
        Label label = factory.createLabel(composite2, TaskMessages.Dependencies_label);
        label.setLayoutData((Object)new GridData(1, 0x1000000, false, true));
        this.noneLabel = factory.createLabel(composite2, TaskMessages.DependencyViewer_NoPredecessor);
        this.noneLabel.setForeground(parent.getDisplay().getSystemColor(16));
        this.noneLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        ToolBarManager toolbar = new ToolBarManager(factory.createFlatToolBar(composite2));
        toolbar.getControl().setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, true));
        this.addDependencyAction = new AddDependencyAction();
        toolbar.add(this.addDependencyAction);
        this.removeDependencyAction = new RemoveDependencyAction();
        toolbar.add(this.removeDependencyAction);
        toolbar.update(true);
        this.createDependencyViewer(composite);
        return composite;
    }

    private void createDependencyViewer(Composite parent) {
        this.viewer = new TableViewer(parent, 68356);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.minimumHeight = 70;
        gridData.heightHint = 70;
        this.viewer.getControl().setLayoutData((Object)gridData);
        this.viewer.getTable().setHeaderVisible(true);
        this.viewer.getTable().setLinesVisible(false);
        this.viewer.setContentProvider((IContentProvider)new DependencyContentProvider());
        TableViewerEditor.create((TableViewer)this.viewer, (ColumnViewerEditorActivationStrategy)new ColumnViewerEditorActivationStrategy((ColumnViewer)this.viewer), (int)20);
        this.viewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                DependencyViewer.this.openDependency((Dependency)((IStructuredSelection)event.getSelection()).getFirstElement());
            }
        });
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (DependencyViewer.this.removeDependencyAction != null) {
                    DependencyViewer.this.removeDependencyAction.setEnabled(!event.getSelection().isEmpty());
                }
            }
        });
        TableViewerColumn col0 = new TableViewerColumn(this.viewer, 16384);
        col0.getColumn().setText("");
        col0.getColumn().setWidth(22);
        col0.setLabelProvider((CellLabelProvider)new DependencyIconProvider());
        TableViewerColumn col1 = new TableViewerColumn(this.viewer, 16384);
        col1.getColumn().setText(TaskMessages.DependencyViewer_PredecessorColumn_text);
        col1.getColumn().setWidth(200);
        col1.setLabelProvider((CellLabelProvider)new PredecessorLabelProvider());
        TableViewerColumn col2 = new TableViewerColumn(this.viewer, 16384);
        col2.getColumn().setText(TaskMessages.DependencyViewer_TypeColumn_text);
        col2.getColumn().setWidth(100);
        col2.setLabelProvider((CellLabelProvider)new DependencyTypeLabelProvider());
        this.viewer.setInput((Object)this.getTask());
        new DependencyActionHandler();
    }

    public void refresh() {
        int itemCount = 0;
        if (this.viewer != null && !this.viewer.getControl().isDisposed() && this.viewer.getContentProvider() != null) {
            this.viewer.setInput((Object)this.getTask());
            itemCount = this.viewer.getTable().getItemCount();
            this.viewer.getControl().setVisible(itemCount > 0);
            ((GridData)this.viewer.getControl().getLayoutData()).exclude = itemCount == 0;
            this.parent.getParent().layout(true);
        }
        if (this.addDependencyAction != null) {
            this.addDependencyAction.setEnabled(this.getTask() != null);
        }
        if (this.removeDependencyAction != null) {
            this.removeDependencyAction.setEnabled(false);
        }
        if (this.noneLabel != null && !this.noneLabel.isDisposed()) {
            this.noneLabel.setVisible(itemCount == 0);
        }
    }

    private void openDependency(Dependency dependency) {
        if (dependency == null) {
            return;
        }
        this.editDependency(dependency);
    }

    private void editDependency(Dependency dependency) {
        DependencyEditDialog dialog = new DependencyEditDialog(this.getControl().getShell(), this.getTask(), dependency);
        int ret = dialog.open();
        if (ret == 0) {
            ITopic newTask = dialog.getTask();
            String newType = dialog.getType();
            if (dependency != null) {
                TaskInfoUtils.changeDependency(dependency, newTask, newType, this.getCommandStack());
            } else {
                TaskInfoUtils.addDependency(this.getTask(), newTask, newType, this.getCommandStack());
            }
        } else if (ret == 1025) {
            TaskInfoUtils.removeDependency(dependency, this.getCommandStack());
        }
    }

    public void setFocus() {
        if (this.viewer != null && this.viewer.getControl() != null && !this.viewer.getControl().isDisposed()) {
            this.viewer.getControl().setFocus();
        }
    }

    private void jumpTo(Object dependency) {
        ITopic task;
        if (dependency instanceof Dependency && (task = ((Dependency)dependency).getPredecessor()) != null) {
            this.getInputProvider().jumpTo(task);
        }
    }

    private void removeDependency(Object dependency) {
        if (dependency instanceof Dependency) {
            TaskInfoUtils.removeDependency((Dependency)dependency, this.getCommandStack());
        }
    }

    private boolean isValidDependency(Object dependency) {
        return dependency != null && dependency instanceof Dependency && this.isValidPredecessor(((Dependency)dependency).getPredecessor());
    }

    private boolean isValidPredecessor(ITopic topic) {
        return topic != null && !topic.isOrphan();
    }

    private class AddDependencyAction
    extends Action {
        public AddDependencyAction() {
            this.setText(TaskMessages.AddDependency_text);
            this.setToolTipText(TaskMessages.AddDependency_toolTip);
            this.setImageDescriptor(MindMapUI.getImages().get("add.png", true));
            this.setDisabledImageDescriptor(MindMapUI.getImages().get("add.png", false));
            this.setEnabled(false);
        }

        public void run() {
            DependencyViewer.this.editDependency(null);
        }
    }

    private class DependencyActionHandler
    implements Listener {
        private Point point = new Point(0, 0);
        private ViewerCell targetCell = null;
        private boolean invalidTarget = false;
        private boolean active = false;
        private Image activeIcon = null;
        private Image oldIcon = null;

        public DependencyActionHandler() {
            Control control = DependencyViewer.this.viewer.getControl();
            control.addListener(5, (Listener)this);
            control.addListener(6, (Listener)this);
            control.addListener(7, (Listener)this);
            control.addListener(3, (Listener)this);
            control.addListener(4, (Listener)this);
        }

        public void handleEvent(Event event) {
            if (event.type == 5 || event.type == 6) {
                this.handleMouseMove(event);
            } else if (event.type == 7) {
                this.handleMouseExit(event);
            } else if (event.type == 3) {
                this.handleMouseDown(event);
            } else if (event.type == 4) {
                this.handleMouseUp(event);
            } else if (event.type == 12) {
                this.handleDispose(event);
            }
        }

        private void restore() {
            if (this.targetCell != null) {
                this.targetCell.setImage(this.oldIcon);
                this.targetCell = null;
            }
            this.oldIcon = null;
            this.active = false;
        }

        private ViewerCell findTargetCell(int x, int y) {
            this.point.x = x;
            this.point.y = y;
            ViewerCell cell = DependencyViewer.this.viewer.getCell(this.point);
            if (cell != null && cell.getColumnIndex() != 0) {
                cell = null;
            }
            return cell;
        }

        private void handleMouseDown(Event event) {
            this.restore();
            ViewerCell cell = this.findTargetCell(event.x, event.y);
            if (cell == null) {
                return;
            }
            this.targetCell = cell;
            this.invalidTarget = !DependencyViewer.this.isValidDependency(cell.getElement());
            this.oldIcon = cell.getImage();
            this.activateTarget();
        }

        private void handleMouseUp(Event event) {
            if (this.targetCell == null || !this.active) {
                this.restore();
                return;
            }
            final Object element = this.targetCell.getElement();
            final boolean invalid = this.invalidTarget;
            event.display.asyncExec(new Runnable(){

                public void run() {
                    if (invalid) {
                        DependencyActionHandler.this.askForDeletion(element);
                    } else {
                        DependencyViewer.this.jumpTo(element);
                    }
                }
            });
            this.restore();
        }

        private void askForDeletion(Object dependency) {
            boolean confirmed = MessageDialog.openQuestion((Shell)DependencyViewer.this.getControl().getShell(), (String)TaskMessages.DependencyViewer_ConfirmDeleteInvalidDependency_windowTitle, (String)TaskMessages.DependencyViewer_ConfirmDeleteInvalidDependency_message);
            if (confirmed) {
                DependencyViewer.this.removeDependency(dependency);
            }
        }

        private void handleMouseExit(Event event) {
            this.deactivateTarget();
        }

        private void deactivateTarget() {
            if (this.targetCell != null) {
                this.active = false;
                this.targetCell.setImage(this.oldIcon);
            }
        }

        private void activateTarget() {
            if (this.targetCell != null) {
                this.active = true;
                if (!this.invalidTarget) {
                    this.targetCell.setImage(this.getActiveIcon());
                }
            }
        }

        private void handleMouseMove(Event event) {
            ViewerCell cell = this.findTargetCell(event.x, event.y);
            if (cell != null) {
                if (DependencyViewer.this.isValidDependency(cell.getElement())) {
                    DependencyViewer.this.viewer.getControl().setToolTipText(TaskMessages.ViewPredecessor_toolTip);
                } else {
                    DependencyViewer.this.viewer.getControl().setToolTipText(TaskMessages.DependencyViewer_InvalidDependency_toolTip);
                }
            } else {
                DependencyViewer.this.viewer.getControl().setToolTipText(null);
            }
            if (this.targetCell == null) {
                return;
            }
            if (cell != null && cell.equals((Object)this.targetCell)) {
                this.activateTarget();
            } else {
                this.deactivateTarget();
            }
        }

        private Image getActiveIcon() {
            if (this.activeIcon == null) {
                this.activeIcon = MindMapUI.getImages().get("drill_down.png", true).createImage();
            }
            return this.activeIcon;
        }

        private void handleDispose(Event event) {
            if (this.activeIcon != null) {
                this.activeIcon.dispose();
                this.activeIcon = null;
            }
        }
    }

    private class DependencyContentProvider
    implements IStructuredContentProvider {
        private DependencyContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement == null) {
                return new Object[0];
            }
            return TaskInfoUtils.getDependencies((ITopic)inputElement).toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class DependencyIconProvider
    extends ColumnLabelProvider {
        private Image jumpIcon = null;
        private Image invalidIcon = null;

        private DependencyIconProvider() {
        }

        public Image getImage(Object element) {
            if (DependencyViewer.this.isValidDependency(element)) {
                return this.getJumpIcon();
            }
            return this.getInvalidIcon();
        }

        public String getText(Object element) {
            return "";
        }

        private Image getJumpIcon() {
            if (this.jumpIcon == null) {
                this.jumpIcon = MindMapUI.getImages().get("forward_nav.gif", true).createImage();
            }
            return this.jumpIcon;
        }

        private Image getInvalidIcon() {
            if (this.invalidIcon == null) {
                this.invalidIcon = TaskInfo.imageDescriptorFromPlugin((String)"org.xmind.ui.taskinfo", (String)"icons/postponed.gif").createImage();
            }
            return this.invalidIcon;
        }

        public void dispose() {
            super.dispose();
            if (this.jumpIcon != null) {
                this.jumpIcon.dispose();
                this.jumpIcon = null;
            }
        }
    }

    private static class DependencyTypeLabelProvider
    extends ColumnLabelProvider {
        private DependencyTypeLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof Dependency) {
                Dependency dependency = (Dependency)element;
                return dependency.getTypeName();
            }
            if (element instanceof String) {
                return Dependency.typeName((String)element);
            }
            return super.getText(element);
        }
    }

    private class PredecessorLabelProvider
    extends ColumnLabelProvider {
        private Map<Object, Image> map = new HashMap<Object, Image>();

        private PredecessorLabelProvider() {
        }

        public Color getForeground(Object element) {
            if (DependencyViewer.this.isValidDependency(element)) {
                return super.getForeground(element);
            }
            return Display.getCurrent().getSystemColor(15);
        }

        public void disposeImage(Object element) {
            Image img = this.unmapImage(element);
            if (img != null) {
                img.dispose();
            }
        }

        protected Image unmapImage(Object element) {
            return this.map.remove(element);
        }

        public Image getImage(Object element) {
            Image img = this.map.get(element);
            if (img == null && (img = this.createImage(element)) != null) {
                this.map.put(element, img);
            }
            return img;
        }

        public void dispose() {
            Object[] objectArray = this.map.keySet().toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                this.disposeImage(element);
                ++n2;
            }
            this.map.clear();
            super.dispose();
        }

        protected Image createImage(Object element) {
            Dependency dependency = (Dependency)element;
            ITopic task = dependency.getPredecessor();
            if (task == null) {
                return null;
            }
            ImageDescriptor icon = MindMapUI.getImages().getElementIcon((Object)task, true);
            if (icon == null) {
                return null;
            }
            return icon.createImage(false);
        }

        public String getText(Object element) {
            if (DependencyViewer.this.getTask() == null) {
                return "";
            }
            Dependency dependency = (Dependency)element;
            ITopic task = dependency.getPredecessor();
            return task == null ? "(Predecessor not found)" : task.getTitleText();
        }
    }

    private class RemoveDependencyAction
    extends Action {
        public RemoveDependencyAction() {
            this.setText(TaskMessages.RemoveDependency_text);
            this.setToolTipText(TaskMessages.RemoveDependency_toolTip);
            this.setImageDescriptor(MindMapUI.getImages().get("remove.png", true));
            this.setDisabledImageDescriptor(MindMapUI.getImages().get("remove.png", false));
            this.setEnabled(false);
        }

        public void run() {
            ISelection selection = DependencyViewer.this.viewer.getSelection();
            if (selection != null && !selection.isEmpty()) {
                Object dependency = ((IStructuredSelection)selection).getFirstElement();
                DependencyViewer.this.removeDependency(dependency);
            }
        }
    }
}

