/* snpExtFile.c was originally generated by the autoSql program, which also 
 * generated snpExtFile.h and snpExtFile.sql.  This module links the database and
 * the RAM representation of objects. */

#include "common.h"
#include "linefile.h"
#include "dystring.h"
#include "jksql.h"
#include "snpExtFile.h"


void snpExtFileStaticLoad(char **row, struct snpExtFile *ret)
/* Load a row from snpExtFile table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->chrom = row[0];
ret->path = row[1];
ret->size = sqlSigned(row[2]);
}

struct snpExtFile *snpExtFileLoad(char **row)
/* Load a snpExtFile from row fetched with select * from snpExtFile
 * from database.  Dispose of this with snpExtFileFree(). */
{
struct snpExtFile *ret;

AllocVar(ret);
ret->chrom = cloneString(row[0]);
ret->path = cloneString(row[1]);
ret->size = sqlSigned(row[2]);
return ret;
}

struct snpExtFile *snpExtFileLoadAll(char *fileName) 
/* Load all snpExtFile from a whitespace-separated file.
 * Dispose of this with snpExtFileFreeList(). */
{
struct snpExtFile *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[3];

while (lineFileRow(lf, row))
    {
    el = snpExtFileLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct snpExtFile *snpExtFileLoadAllByChar(char *fileName, char chopper) 
/* Load all snpExtFile from a chopper separated file.
 * Dispose of this with snpExtFileFreeList(). */
{
struct snpExtFile *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[3];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = snpExtFileLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct snpExtFile *snpExtFileCommaIn(char **pS, struct snpExtFile *ret)
/* Create a snpExtFile out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new snpExtFile */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->chrom = sqlStringComma(&s);
ret->path = sqlStringComma(&s);
ret->size = sqlSignedComma(&s);
*pS = s;
return ret;
}

void snpExtFileFree(struct snpExtFile **pEl)
/* Free a single dynamically allocated snpExtFile such as created
 * with snpExtFileLoad(). */
{
struct snpExtFile *el;

if ((el = *pEl) == NULL) return;
freeMem(el->chrom);
freeMem(el->path);
freez(pEl);
}

void snpExtFileFreeList(struct snpExtFile **pList)
/* Free a list of dynamically allocated snpExtFile's */
{
struct snpExtFile *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    snpExtFileFree(&el);
    }
*pList = NULL;
}

void snpExtFileOutput(struct snpExtFile *el, FILE *f, char sep, char lastSep) 
/* Print out snpExtFile.  Separate fields with sep. Follow last field with lastSep. */
{
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->chrom);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->path);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%d", el->size);
fputc(lastSep,f);
}

/* -------------------------------- End autoSql Generated Code -------------------------------- */

