/* exonGraph.h was originally generated by the autoSql program, which also 
 * generated exonGraph.c and exonGraph.sql.  This header links the database and
 * the RAM representation of objects. */

#ifndef EXONGRAPH_H
#define EXONGRAPH_H

enum nodeColor {
    enWhite,
    enGray,
    enBlack
};

struct smallPath 
/* low memory version of a path. */
{
    struct smallPath *next; /* Next in list. */
    int maxCount;           /* Amount of memory allocated for array. */
    int currCount;          /* Number of items currently stored in array. */
    int *path;              /* Array of node ids. */
};

struct exonNode
/* A Single exon site node in a splicing graph */
{
    struct exonNode *next;  /* Next in singly linked list. */
    char *tName;	/* name of target sequence, often a chrom. */
    int tStart;	/* start in tName. 3' splice site */
    int tEnd;	/* end in tName. 5' splice site */
    char strand[3];	/* + or - strand. */
    unsigned id;	/* Unique ID. */
    unsigned startClass;	/* Class of start, splice site number */
    unsigned endClass;	/* Class of end, splice site number */
    unsigned startType;	/* Type of starting splice site, ggVertexType. */
    unsigned endType;	/* Type of ending splice site, ggVertexType. */
    unsigned type;	/* Type of exon, see enum ggEdgeType. */
    int class;	/* Number of node in graph, different than ID. */
    unsigned color;	/* Used for algorithm classification. */
    unsigned startCount;	/* If wildcard starts number of starts that can match */
    unsigned *starts;	/* location of starting positions that match. */
    unsigned endCount;	/* If wildcard end, number of starts that can match */
    unsigned *ends;	/* location of ending positions that match. */
    unsigned edgeInCount;	/* Number of edges inputting into this node. */
    unsigned *edgesIn;	/* Ids of nodes that connect to this node. */
    unsigned edgeOutCount;	/* Number of edges leaving from this graph. */
    unsigned *edgesOut;	/* Ids of exonNodes that this node connects to, by convention edgesOut[0] = next node in path */
    unsigned accCount;	/* Number of accessions that support this node. */
    char **accs;	/* Accessions that support this node. */
    boolean accDeepFree;   /* Freee each bit of memory individually for accs. */
    struct exonPath *ep; /* Path that this node is part of. */
/*     struct exonPath *paths; /\* Paths that lead to this node. *\/ */
    struct smallPath *paths;
};

struct exonNode *exonNodeLoad(char **row);
/* Load a exonNode from row fetched with select * from exonNode
 * from database.  Dispose of this with exonNodeFree(). */

struct exonNode *exonNodeLoadAll(char *fileName);
/* Load all exonNode from a tab-separated file.
 * Dispose of this with exonNodeFreeList(). */

struct exonNode *exonNodeCommaIn(char **pS, struct exonNode *ret);
/* Create a exonNode out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new exonNode */

void exonNodeFree(struct exonNode **pEl);
/* Free a single dynamically allocated exonNode such as created
 * with exonNodeLoad(). */

void exonNodeFreeList(struct exonNode **pList);
/* Free a list of dynamically allocated exonNode's */

void exonNodeOutput(struct exonNode *el, FILE *f, char sep, char lastSep);
/* Print out exonNode.  Separate fields with sep. Follow last field with lastSep. */

#define exonNodeTabOut(el,f) exonNodeOutput(el,f,'\t','\n');
/* Print out exonNode as a line in a tab-separated file. */

#define exonNodeCommaOut(el,f) exonNodeOutput(el,f,',',',');
/* Print out exonNode as a comma separated list including final comma. */

struct exonPath
/* Path of one EST/mRNA through exonNodes */
    {
    struct exonPath *next;  /* Next in singly linked list. */
    char *tName;	/* name of target sequence, often a chrom. */
    int tStart;	/* start in tName. */
    int tEnd;	/* end in tName. */
    char *qName;	/* Accession of mRNA or EST. */
    char strand[3];	/* + or - strand. */
    char *path;	/* String representation of path. */
    unsigned nodeCount;	/* Number of nodes in graph. */
    struct exonNode *nodes;	/* Array of dynamically allocated exonNodes whose id corresponds to their index in array. */
    };

struct exonPath *exonPathLoad(char **row);
/* Load a exonPath from row fetched with select * from exonPath
 * from database.  Dispose of this with exonPathFree(). */

struct exonPath *exonPathLoadAll(char *fileName);
/* Load all exonPath from a tab-separated file.
 * Dispose of this with exonPathFreeList(). */

struct exonPath *exonPathCommaIn(char **pS, struct exonPath *ret);
/* Create a exonPath out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new exonPath */

void exonPathFree(struct exonPath **pEl);
/* Free a single dynamically allocated exonPath such as created
 * with exonPathLoad(). */

void exonPathFreeList(struct exonPath **pList);
/* Free a list of dynamically allocated exonPath's */

void exonPathOutput(struct exonPath *el, FILE *f, char sep, char lastSep);
/* Print out exonPath.  Separate fields with sep. Follow last field with lastSep. */

#define exonPathTabOut(el,f) exonPathOutput(el,f,'\t','\n');
/* Print out exonPath as a line in a tab-separated file. */

#define exonPathCommaOut(el,f) exonPathOutput(el,f,',',',');
/* Print out exonPath as a comma separated list including final comma. */

struct exonGraph
/* A collection of exonNodes forming a graph */
{
    struct exonGraph *next;  /* Next in singly linked list. */
    char *tName;	/* name of target sequence, often a chrom. */
    int tStart;	/* start in tName. */
    int tEnd;	/* end in tName. */
    char strand[3];	/* + or - strand. */
    unsigned classCount;	/* Number of different classes of nodes, two nodes are of same class if at same position. */
    unsigned *classStarts;	/* start in tName. */
    unsigned *classEnds;	/* end in tName. */
    unsigned *classTypes;	/* Type of exon site, see enum ggVertexType. */
    unsigned nodeCount;	/* Total number of nodes in graph. */
    unsigned nodeCapacity;	/* Maximum nodes allowed without expanding memory. */
    unsigned pathCount;	/* Number of different paths generating graph. */
    struct exonPath *paths;	/* Array of dynamically allocated exonPaths which make up the graph. */
    struct exonNode **nodes;  /* Array of pointers to each node in graph, ids of nodes index into this array. */
    struct exonPath *rejects; /* List of paths that were rejected (duplicates, etc.) */
};

struct exonGraph *exonGraphLoad(char **row);
/* Load a exonGraph from row fetched with select * from exonGraph
 * from database.  Dispose of this with exonGraphFree(). */

struct exonGraph *exonGraphLoadAll(char *fileName);
/* Load all exonGraph from a tab-separated file.
 * Dispose of this with exonGraphFreeList(). */

struct exonGraph *exonGraphCommaIn(char **pS, struct exonGraph *ret);
/* Create a exonGraph out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new exonGraph */

void exonGraphFree(struct exonGraph **pEl);
/* Free a single dynamically allocated exonGraph such as created
 * with exonGraphLoad(). */

void exonGraphFreeList(struct exonGraph **pList);
/* Free a list of dynamically allocated exonGraph's */

void exonGraphOutput(struct exonGraph *el, FILE *f, char sep, char lastSep);
/* Print out exonGraph.  Separate fields with sep. Follow last field with lastSep. */

#define exonGraphTabOut(el,f) exonGraphOutput(el,f,'\t','\n');
/* Print out exonGraph as a line in a tab-separated file. */

#define exonGraphCommaOut(el,f) exonGraphOutput(el,f,',',',');
/* Print out exonGraph as a comma separated list including final comma. */

/* -------------------------------- End autoSql Generated Code -------------------------------- */

void exonGraphIncreaseCapacity(struct exonGraph *eg, int neededSize);
/* Increase the nodeCapcity of nodes for exonGraph. */

void exonGraphAddNode(struct exonGraph *eg, struct exonNode *en);
/* Add the exonNode en to the array of node pointers maintained by the exonGraph. */

void exonNodeConnect(struct exonNode *en1, struct exonNode *en2);
/* Create a directed edge from en1 to en2. */

void addExonNodeEnd(struct exonNode *en, unsigned int end);
/* Add another exon node end to an exonNode. */

void addExonNodeStart(struct exonNode *en, unsigned int start);
/* Add another exon node start to an exonNode. */

#endif /* EXONGRAPH_H */

