/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.simulation;

import com.sun.electric.database.geometry.PolyBase;
import com.sun.electric.database.geometry.btree.unboxed.LatticeOperation;
import com.sun.electric.database.geometry.btree.unboxed.Unboxed;
import com.sun.electric.tool.simulation.BTreeSignal;
import com.sun.electric.tool.simulation.MutableSignal;
import com.sun.electric.tool.simulation.Sample;
import com.sun.electric.tool.simulation.Signal;
import com.sun.electric.tool.simulation.SignalCollection;
import com.sun.electric.tool.simulation.SimulationTool;
import com.sun.electric.tool.simulation.Stimuli;
import com.sun.electric.tool.user.waveform.Panel;
import com.sun.electric.tool.user.waveform.WaveSignal;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.geom.Rectangle2D;
import java.util.List;

public class DigitalSample
implements Sample {
    public static final DigitalSample LOGIC_0;
    public static final DigitalSample LOGIC_1;
    public static final DigitalSample LOGIC_X;
    public static final DigitalSample LOGIC_Z;
    private static DigitalSample[][] cache;
    private Value value;
    private Strength strength;
    public static final Unboxed<DigitalSample> unboxer;
    private static final LatticeOperation<DigitalSample> latticeOp;

    public static DigitalSample getSample(Value value, Strength strength) {
        if (value == Value.Z ^ strength == Strength.HIGH_IMPEDANCE) {
            throw new RuntimeException("Logic=Z and Strength=HIGH_IMPEDANCE may only be used together");
        }
        return cache[value.v + 1][strength.v];
    }

    private DigitalSample(Value value, Strength strength) {
        if (value == Value.Z ^ strength == Strength.HIGH_IMPEDANCE) {
            throw new RuntimeException("Logic=Z and Strength=HIGH_IMPEDANCE may only be used together");
        }
        this.value = value;
        this.strength = strength;
    }

    public boolean equals(Object o) {
        return this == o;
    }

    public int hashCode() {
        return this.getByteRepresentation() & 0xFF;
    }

    @Override
    public Sample lub(Sample s2) {
        if (!(s2 instanceof DigitalSample)) {
            throw new RuntimeException("tried to call DigitalSample.lub(" + s2.getClass().getName() + ")");
        }
        DigitalSample ds = (DigitalSample)s2;
        if (ds.value.v >= this.value.v && ds.strength.v >= this.strength.v) {
            return ds;
        }
        if (ds.value.v <= this.value.v && ds.strength.v <= this.strength.v) {
            return this;
        }
        return cache[Math.max(ds.value.v, this.value.v) + 1][Math.max(ds.strength.v, this.strength.v) + 1];
    }

    @Override
    public Sample glb(Sample s2) {
        if (!(s2 instanceof DigitalSample)) {
            throw new RuntimeException("tried to call DigitalSample.glb(" + s2.getClass().getName() + ")");
        }
        DigitalSample ds = (DigitalSample)s2;
        if (ds.value.v >= this.value.v && ds.strength.v >= this.strength.v) {
            return this;
        }
        if (ds.value.v <= this.value.v && ds.strength.v <= this.strength.v) {
            return ds;
        }
        return cache[Math.min(ds.value.v, this.value.v) + 1][Math.min(ds.strength.v, this.strength.v) + 1];
    }

    @Override
    public double getMinValue() {
        return 0.0;
    }

    @Override
    public double getMaxValue() {
        return 1.0;
    }

    public boolean isLogic0() {
        return this.value == Value.LOW;
    }

    public boolean isLogic1() {
        return this.value == Value.HIGH;
    }

    @Override
    public boolean isLogicX() {
        return this.value == Value.X;
    }

    @Override
    public boolean isLogicZ() {
        return this.value == Value.Z;
    }

    private byte getByteRepresentation() {
        return (byte)(this.value.v + 1 << 3 | this.strength.v);
    }

    private static DigitalSample fromByteRepresentation(byte b) {
        return cache[b >> 3 & 3][b & 7];
    }

    public static DigitalSample fromOldStyle(int i) {
        Strength strength = null;
        Value value = null;
        switch (i & 3) {
            case 0: {
                value = Value.LOW;
                break;
            }
            case 2: {
                value = Value.HIGH;
                break;
            }
            case 1: {
                value = Value.X;
                break;
            }
            case 3: {
                return DigitalSample.getSample(Value.Z, Strength.HIGH_IMPEDANCE);
            }
            default: {
                throw new RuntimeException("unknown value: " + (i & 3));
            }
        }
        switch (i & 0xC) {
            case 0: {
                strength = Strength.SMALL_CAPACITANCE;
                break;
            }
            case 4: {
                strength = Strength.STRONG_PULL;
                break;
            }
            case 8: {
                strength = Strength.LARGE_CAPACITANCE;
                break;
            }
            case 12: {
                strength = Strength.SUPPLY_DRIVE;
                break;
            }
            default: {
                throw new RuntimeException("unknown strength: " + (i & 0xC));
            }
        }
        return DigitalSample.getSample(value, strength);
    }

    public static int getState(Signal.View<DigitalSample> view, int index) {
        DigitalSample ds = view.getSample(index);
        return DigitalSample.getState(ds);
    }

    public static int getState(DigitalSample ds) {
        if (ds.isLogic0()) {
            return 0;
        }
        if (ds.isLogic1()) {
            return 2;
        }
        if (ds.isLogicX()) {
            return 1;
        }
        if (ds.isLogicZ()) {
            return 3;
        }
        throw new RuntimeException("ack!");
    }

    public static MutableSignal<DigitalSample> createSignal(SignalCollection sc, Stimuli sd, String signalName, String signalContext) {
        return new BTreeSignal<DigitalSample>(sc, sd, signalName, signalContext, true, BTreeSignal.getTree(unboxer, latticeOp, sd)){

            @Override
            public void plot(Panel panel, Graphics g, WaveSignal ws, Color light, List<PolyBase> forPs, Rectangle2D bounds, List<Panel.WaveSelection> selectedObjects, Signal<?> xAxisSignal) {
                Dimension sz = panel.getSize();
                int hei = sz.height;
                int lastx = panel.getVertAxisPos();
                int lastState = 0;
                Signal<?> ds = ws.getSignal();
                Signal.View<DigitalSample> view = ds.getExactView();
                int numEvents = view.getNumEvents();
                int lastLowy = 0;
                int lastHighy = 0;
                for (int i = 0; i < numEvents; ++i) {
                    double xValue = view.getTime(i);
                    int x = panel.convertXDataToScreen(xValue);
                    if (SimulationTool.isWaveformDisplayMultiState() && g != null) {
                        if (panel.getWaveWindow().getPrintingMode() == 2) {
                            g.setColor(Color.BLACK);
                        } else {
                            switch (DigitalSample.getState(view, i) & 0xC) {
                                case 0: {
                                    g.setColor(panel.getWaveWindow().getOffStrengthColor());
                                    break;
                                }
                                case 4: {
                                    g.setColor(panel.getWaveWindow().getNodeStrengthColor());
                                    break;
                                }
                                case 8: {
                                    g.setColor(panel.getWaveWindow().getGateStrengthColor());
                                    break;
                                }
                                case 12: {
                                    g.setColor(panel.getWaveWindow().getPowerStrengthColor());
                                }
                            }
                        }
                    }
                    int state = DigitalSample.getState(view, i) & 3;
                    int lowy = 0;
                    int highy = 0;
                    switch (state) {
                        case 2: {
                            highy = 5;
                            lowy = 5;
                            break;
                        }
                        case 0: {
                            lowy = highy = hei - 5;
                            break;
                        }
                        case 1: {
                            lowy = 5;
                            highy = hei - 5;
                            break;
                        }
                        case 3: {
                            lowy = (hei - 10) / 3 + 5;
                            highy = hei - (hei - 10) / 3 - 5;
                        }
                    }
                    if (g != null && !SimulationTool.isWaveformDisplayMultiState()) {
                        g.setColor(Color.RED);
                    }
                    if (i != 0 && state != lastState && panel.processALine(g, x, Math.min(lowy, lastLowy), x, Math.max(lowy, lastLowy), bounds, forPs, selectedObjects, ws, -1)) {
                        return;
                    }
                    if (g != null && !SimulationTool.isWaveformDisplayMultiState() && lastState == 3) {
                        g.setColor(Color.GREEN);
                    }
                    if (lastLowy == lastHighy ? panel.processALine(g, lastx, lastLowy, x, lastLowy, bounds, forPs, selectedObjects, ws, -1) : panel.processABox(g, lastx, lastLowy, x, lastHighy, bounds, forPs, selectedObjects, ws, false, 0.0)) {
                        return;
                    }
                    if (i >= numEvents - 1) {
                        if (g != null && !SimulationTool.isWaveformDisplayMultiState()) {
                            if (state == 3) {
                                g.setColor(Color.GREEN);
                            } else {
                                g.setColor(Color.RED);
                            }
                        }
                        int wid = sz.width;
                        if (lowy == highy ? panel.processALine(g, x, lowy, wid - 1, lowy, bounds, forPs, selectedObjects, ws, -1) : panel.processABox(g, x, lowy, wid - 1, highy, bounds, forPs, selectedObjects, ws, false, 0.0)) {
                            return;
                        }
                    }
                    lastx = x;
                    lastLowy = lowy;
                    lastHighy = highy;
                    lastState = state;
                }
            }
        };
    }

    static {
        cache = new DigitalSample[4][];
        for (int i = 0; i < 4; ++i) {
            DigitalSample.cache[i] = new DigitalSample[8];
        }
        for (Value value : Value.values()) {
            for (Strength strength : Strength.values()) {
                if (value == Value.Z ^ strength == Strength.HIGH_IMPEDANCE) continue;
                DigitalSample.cache[((Value)value).v + 1][((Strength)strength).v] = new DigitalSample(value, strength);
            }
        }
        LOGIC_0 = DigitalSample.getSample(Value.LOW, Strength.STRONG_PULL);
        LOGIC_1 = DigitalSample.getSample(Value.HIGH, Strength.STRONG_PULL);
        LOGIC_X = DigitalSample.getSample(Value.X, Strength.STRONG_PULL);
        LOGIC_Z = DigitalSample.getSample(Value.Z, Strength.HIGH_IMPEDANCE);
        unboxer = new Unboxed<DigitalSample>(){

            @Override
            public int getSize() {
                return 1;
            }

            @Override
            public DigitalSample deserialize(byte[] buf, int ofs) {
                return DigitalSample.fromByteRepresentation(buf[ofs]);
            }

            @Override
            public void serialize(DigitalSample v, byte[] buf, int ofs) {
                buf[ofs] = v.getByteRepresentation();
            }
        };
        latticeOp = new LatticeOperation<DigitalSample>(unboxer){

            @Override
            public void lub(byte[] buf1, int ofs1, byte[] buf2, int ofs2, byte[] dest, int dest_ofs) {
                if ((buf1[ofs1] & 0xFF) - (buf2[ofs2] & 0xFF) < 0) {
                    System.arraycopy(buf2, ofs2, dest, dest_ofs, unboxer.getSize());
                } else {
                    System.arraycopy(buf1, ofs1, dest, dest_ofs, unboxer.getSize());
                }
            }

            @Override
            public void glb(byte[] buf1, int ofs1, byte[] buf2, int ofs2, byte[] dest, int dest_ofs) {
                if ((buf1[ofs1] & 0xFF) - (buf2[ofs2] & 0xFF) < 0) {
                    System.arraycopy(buf1, ofs1, dest, dest_ofs, unboxer.getSize());
                } else {
                    System.arraycopy(buf2, ofs2, dest, dest_ofs, unboxer.getSize());
                }
            }
        };
    }

    public static enum Strength {
        SUPPLY_DRIVE(7),
        STRONG_PULL(6),
        PULL_DRIVE(5),
        LARGE_CAPACITANCE(4),
        WEAK_DRIVE(3),
        MEDIUM_CAPACITANCE(2),
        SMALL_CAPACITANCE(1),
        HIGH_IMPEDANCE(0);

        private final int v;

        private Strength(int v) {
            this.v = v;
        }
    }

    public static enum Value {
        HIGH(1),
        X(0),
        LOW(-1),
        Z(-1);

        private final int v;

        private Value(int v) {
            this.v = v;
        }
    }
}

