/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.gui.colour;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import tim.prune.I18nManager;
import tim.prune.gui.colour.ColourPatch;

public class ColourChooser {
    private final JDialog _dialog;
    private JSlider[] _rgbSliders = null;
    private JLabel[] _rgbLabels = null;
    private ColourPatch _patch = null;
    private Color _chosenColour = null;

    public ColourChooser(JDialog jDialog) {
        this._dialog = new JDialog(jDialog, I18nManager.getText("dialog.colourchooser.title"), true);
        this._dialog.setLocationRelativeTo(jDialog);
        this._dialog.getContentPane().add(this.makeContents());
        this._dialog.pack();
    }

    private JPanel makeContents() {
        JComponent jComponent;
        Object object;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        this._rgbSliders = new JSlider[3];
        this._rgbLabels = new JLabel[3];
        this._patch = new ColourPatch(Color.WHITE);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add((Component)this._patch, "Center");
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        String[] stringArray = new String[]{"red", "green", "blue"};
        int n = 0;
        while (n < 3) {
            object = I18nManager.getText("dialog.colourchooser." + stringArray[n]);
            jPanel3.add(new JLabel((String)object));
            this._rgbSliders[n] = new JSlider(0, 255);
            this._rgbSliders[n].addChangeListener(changeEvent -> this.updatePatch());
            this._rgbSliders[n].setToolTipText((String)object);
            jComponent = new JPanel();
            jComponent.setLayout(new BorderLayout(5, 0));
            jComponent.add((Component)this._rgbSliders[n], "Center");
            this._rgbLabels[n] = new JLabel("255");
            this._rgbLabels[n].setPreferredSize(new Dimension(40, 1));
            jComponent.add((Component)this._rgbLabels[n], "East");
            jPanel3.add(jComponent);
            ++n;
        }
        jPanel2.add((Component)jPanel3, "South");
        jPanel.add((Component)jPanel2, "Center");
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new FlowLayout(2));
        object = new JButton(I18nManager.getText("button.ok"));
        ((AbstractButton)object).addActionListener(actionEvent -> {
            this._chosenColour = this._patch.getBackground();
            this._dialog.setVisible(false);
        });
        jPanel4.add((Component)object);
        jComponent = new JButton(I18nManager.getText("button.cancel"));
        ((AbstractButton)jComponent).addActionListener(actionEvent -> {
            this._chosenColour = null;
            this._dialog.setVisible(false);
        });
        jPanel4.add(jComponent);
        jPanel.add((Component)jPanel4, "South");
        return jPanel;
    }

    public void showDialog(Color color) {
        this._rgbSliders[0].setValue(color.getRed());
        this._rgbSliders[1].setValue(color.getGreen());
        this._rgbSliders[2].setValue(color.getBlue());
        this.updatePatch();
        this._dialog.setLocationRelativeTo(this._dialog.getParent());
        this._dialog.setVisible(true);
    }

    private void updatePatch() {
        int n = 0;
        while (n < 3) {
            this._rgbLabels[n].setText("" + this._rgbSliders[n].getValue());
            ++n;
        }
        Color color = new Color(this._rgbSliders[0].getValue(), this._rgbSliders[1].getValue(), this._rgbSliders[2].getValue());
        this._patch.setColour(color);
    }

    public Color getChosenColour() {
        return this._chosenColour;
    }
}

