/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.model.entry;

import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jabref.model.ChainNode;
import org.jabref.model.util.OptionalUtil;

public class Keyword
extends ChainNode<Keyword>
implements Comparable<Keyword> {
    public static Character DEFAULT_HIERARCHICAL_DELIMITER = Character.valueOf('>');
    private final String keyword;

    public Keyword(String keyword) {
        super(Keyword.class);
        this.keyword = Objects.requireNonNull(keyword).trim();
    }

    public static Keyword of(String ... keywords) {
        if (keywords.length == 0) {
            return new Keyword("");
        }
        Keyword root = new Keyword(keywords[0]);
        for (int i = 1; i < keywords.length; ++i) {
            root.addAtEnd(keywords[i]);
        }
        return root;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Keyword other = (Keyword)o;
        return Objects.equals(this.keyword, other.keyword) && Objects.equals(this.getChild(), other.getChild());
    }

    public int hashCode() {
        return Objects.hash(this.keyword);
    }

    public String toString() {
        return this.getSubchainAsString(DEFAULT_HIERARCHICAL_DELIMITER);
    }

    @Override
    public int compareTo(Keyword o) {
        return this.keyword.compareTo(o.keyword);
    }

    @Override
    private void addAtEnd(String keyword) {
        this.addAtEnd(new Keyword(keyword));
    }

    private String getSubchainAsString(Character hierarchicalDelimiter) {
        return this.keyword + this.getChild().map(child -> " " + hierarchicalDelimiter + " " + child.getSubchainAsString(hierarchicalDelimiter)).orElse("");
    }

    public String get() {
        return this.keyword;
    }

    public String getPathFromRootAsString(Character hierarchicalDelimiter) {
        return this.getParent().map(parent -> parent.getPathFromRootAsString(hierarchicalDelimiter) + " " + hierarchicalDelimiter + " ").orElse("") + this.keyword;
    }

    public Set<Keyword> flatten() {
        return Stream.concat(Stream.of(this), OptionalUtil.toStream(this.getChild()).flatMap(child -> child.flatten().stream())).collect(Collectors.toSet());
    }

    public Set<String> getAllSubchainsAsString(Character hierarchicalDelimiter) {
        return this.flatten().stream().map(subchain -> subchain.getPathFromRootAsString(hierarchicalDelimiter)).collect(Collectors.toSet());
    }
}

