/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.integrity;

import java.util.Optional;
import org.jabref.logic.bibtexkeypattern.BibtexKeyGenerator;
import org.jabref.logic.integrity.ValueChecker;
import org.jabref.logic.l10n.Localization;

public class ValidBibtexKeyChecker
implements ValueChecker {
    private final boolean enforceLegalKey;

    public ValidBibtexKeyChecker(boolean enforceLegalKey) {
        this.enforceLegalKey = enforceLegalKey;
    }

    @Override
    public Optional<String> checkValue(String value) {
        String cleaned = BibtexKeyGenerator.cleanKey(value, this.enforceLegalKey);
        if (cleaned.equals(value)) {
            return Optional.empty();
        }
        return Optional.of(Localization.lang("Invalid BibTeX key", new String[0]));
    }
}

