/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.externalfiles;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import org.jabref.Globals;
import org.jabref.gui.externalfiles.AutoSetFileLinksUtil;
import org.jabref.gui.externalfiletype.ExternalFileType;
import org.jabref.gui.externalfiletype.ExternalFileTypes;
import org.jabref.gui.undo.NamedCompound;
import org.jabref.gui.undo.UndoableFieldChange;
import org.jabref.gui.util.DefaultTaskExecutor;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.FileFieldWriter;
import org.jabref.model.entry.LinkedFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoSetLinks {
    private static final Logger LOGGER = LoggerFactory.getLogger(AutoSetLinks.class);

    private AutoSetLinks() {
    }

    public static void autoSetLinks(List<BibEntry> entries, BibDatabaseContext databaseContext) {
        AutoSetLinks.autoSetLinks(entries, null, null, databaseContext, null, null);
    }

    public static Runnable autoSetLinks(List<BibEntry> entries, NamedCompound ce, Set<BibEntry> changedEntries, BibDatabaseContext databaseContext, ActionListener callback, JDialog diag) {
        Set<ExternalFileType> types = ExternalFileTypes.getInstance().getExternalFileTypeSelection();
        if (diag != null) {
            JProgressBar prog = new JProgressBar(0, 0, types.size() - 1);
            JLabel label = new JLabel(Localization.lang("Searching for files", new String[0]));
            prog.setIndeterminate(true);
            prog.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            diag.setTitle(Localization.lang("Automatically setting file links", new String[0]));
            diag.getContentPane().add((Component)prog, "Center");
            diag.getContentPane().add((Component)label, "South");
            diag.pack();
            diag.setLocationRelativeTo(diag.getParent());
        }
        Runnable r = () -> {
            boolean foundAny = false;
            AutoSetFileLinksUtil util = new AutoSetFileLinksUtil(databaseContext, Globals.prefs.getFileDirectoryPreferences(), Globals.prefs.getAutoLinkPreferences(), ExternalFileTypes.getInstance());
            for (BibEntry entry : entries) {
                List<Object> linkedFiles = new ArrayList();
                try {
                    linkedFiles = util.findAssociatedNotLinkedFiles(entry);
                }
                catch (IOException e) {
                    LOGGER.error("Problem finding files", e);
                }
                if (ce == null) continue;
                for (LinkedFile linkedFile : linkedFiles) {
                    String newVal = FileFieldWriter.getStringRepresentation(linkedFile);
                    String oldVal = entry.getField("file").orElse(null);
                    UndoableFieldChange fieldChange = new UndoableFieldChange(entry, "file", oldVal, newVal);
                    ce.addEdit(fieldChange);
                    DefaultTaskExecutor.runInJavaFXThread(() -> entry.addFile(linkedFile));
                    foundAny = true;
                }
                if (changedEntries == null) continue;
                changedEntries.add(entry);
            }
            int id = foundAny ? 1 : 0;
            SwingUtilities.invokeLater(() -> {
                if (diag != null) {
                    diag.dispose();
                }
                if (callback != null) {
                    callback.actionPerformed(new ActionEvent(AutoSetLinks.class, id, ""));
                }
            });
        };
        SwingUtilities.invokeLater(() -> {
            if (diag != null) {
                diag.setVisible(true);
            }
        });
        return r;
    }

    public static Runnable autoSetLinks(BibEntry entry, BibDatabaseContext databaseContext, ActionListener callback, JDialog diag) {
        return AutoSetLinks.autoSetLinks(Collections.singletonList(entry), null, null, databaseContext, callback, diag);
    }
}

