/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.telemetry;

import com.microsoft.applicationinsights.core.dependencies.apachecommons.lang3.StringUtils;
import com.microsoft.applicationinsights.internal.schemav2.Data;
import com.microsoft.applicationinsights.internal.schemav2.Domain;
import com.microsoft.applicationinsights.internal.schemav2.Envelope;
import com.microsoft.applicationinsights.internal.util.LocalStringsUtils;
import com.microsoft.applicationinsights.internal.util.Sanitizer;
import com.microsoft.applicationinsights.telemetry.JsonTelemetryDataSerializer;
import com.microsoft.applicationinsights.telemetry.Telemetry;
import com.microsoft.applicationinsights.telemetry.TelemetryContext;
import java.io.IOException;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public abstract class BaseTelemetry<T extends Domain>
implements Telemetry {
    private TelemetryContext context;
    private Date timestamp;
    private String sequence;
    private final String TELEMETRY_NAME_PREFIX = "Microsoft.ApplicationInsights.";

    protected BaseTelemetry() {
    }

    protected void initialize(ConcurrentMap<String, String> properties) {
        this.context = new TelemetryContext(properties, new ConcurrentHashMap<String, String>());
    }

    @Override
    public String getSequence() {
        return this.sequence;
    }

    @Override
    public void setSequence(String sequence) {
        this.sequence = sequence;
    }

    @Override
    public Date getTimestamp() {
        return this.timestamp;
    }

    @Override
    public void setTimestamp(Date date) {
        this.timestamp = date;
    }

    @Override
    public TelemetryContext getContext() {
        return this.context;
    }

    @Override
    public Map<String, String> getProperties() {
        return this.context.getProperties();
    }

    @Override
    @Deprecated
    public void sanitize() {
        Sanitizer.sanitizeProperties(this.getProperties());
        this.additionalSanitize();
    }

    @Override
    public void serialize(JsonTelemetryDataSerializer writer) throws IOException {
        String telemetryName = this.getTelemetryName(this.normalizeInstrumentationKey(this.context.getInstrumentationKey()), this.getEnvelopName());
        Envelope envelope = new Envelope();
        envelope.setName(telemetryName);
        this.setSampleRate(envelope);
        envelope.setIKey(this.context.getInstrumentationKey());
        envelope.setSeq(this.sequence);
        Data<T> tmp = new Data<T>();
        tmp.setBaseData(this.getData());
        tmp.setBaseType(this.getBaseTypeName());
        envelope.setData(tmp);
        envelope.setTime(LocalStringsUtils.getDateFormatter().format(this.getTimestamp()));
        envelope.setTags(this.context.getTags());
        envelope.serialize(writer);
    }

    @Override
    public void reset() {
    }

    @Deprecated
    protected abstract void additionalSanitize();

    protected abstract T getData();

    protected void setSampleRate(Envelope envelope) {
    }

    protected String getEnvelopName() {
        throw new UnsupportedOperationException();
    }

    protected String getBaseTypeName() {
        throw new UnsupportedOperationException();
    }

    private String normalizeInstrumentationKey(String instrumentationKey) {
        if (StringUtils.isEmpty(instrumentationKey) || StringUtils.containsOnly((CharSequence)instrumentationKey, ".- ")) {
            return "";
        }
        return instrumentationKey.replace("-", "").toLowerCase() + ".";
    }

    private String getTelemetryName(String normalizedInstrumentationKey, String envelopType) {
        return String.format("%s%s%s", "Microsoft.ApplicationInsights.", normalizedInstrumentationKey, envelopType);
    }
}

