/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.protocol;

import com.impossibl.postgres.protocol.TypeRef;
import com.impossibl.postgres.types.Type;

public class ResultField {
    private String name;
    private int relationId;
    private int relationAttributeNumber;
    private TypeRef typeRef;
    private short typeLength;
    private int typeModifier;
    private Format format;

    public ResultField(String name, int relationId, short relationAttributeNumber, Type type, short typeLength, int typeModifier, Format format) {
        this.name = name;
        this.relationId = relationId;
        this.relationAttributeNumber = relationAttributeNumber;
        this.typeRef = TypeRef.from(type);
        this.typeLength = typeLength;
        this.typeModifier = typeModifier;
        this.format = format;
    }

    public ResultField(String name, int relationId, short relationAttributeNumber, TypeRef typeRef, short typeLength, int typeModifier, Format format) {
        this.name = name;
        this.relationId = relationId;
        this.relationAttributeNumber = relationAttributeNumber;
        this.typeRef = typeRef;
        this.typeLength = typeLength;
        this.typeModifier = typeModifier;
        this.format = format;
    }

    public String getName() {
        return this.name;
    }

    public int getRelationId() {
        return this.relationId;
    }

    public int getRelationAttributeNumber() {
        return this.relationAttributeNumber;
    }

    public TypeRef getTypeRef() {
        return this.typeRef;
    }

    public short getTypeLength() {
        return this.typeLength;
    }

    public int getTypeModifier() {
        return this.typeModifier;
    }

    public void setFormat(Format v) {
        this.format = v;
    }

    public Format getFormat() {
        return this.format;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.name);
        if (this.relationId != 0) {
            sb.append(String.format(" (%s:%d)", this.relationId, this.relationAttributeNumber));
        }
        sb.append(" : ");
        sb.append(this.typeRef != null ? this.typeRef.toString() : "<unknown>");
        return sb.toString();
    }

    public static enum Format {
        Text,
        Binary;

    }
}

