/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.jdbc;

import com.impossibl.postgres.jdbc.Housekeeper;
import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ThreadedHousekeeper
implements Housekeeper {
    private static final Logger logger = Logger.getLogger(ThreadedHousekeeper.class.getName());
    private static long instanceRefs = 0L;
    private static ThreadedHousekeeper instance;
    private boolean logLeaks = true;
    private ReferenceQueue<Object> cleanupQueue = new ReferenceQueue();
    private Set<HousekeeperReference<?>> cleanupReferences = new HashSet();
    private AtomicBoolean cleanupThreadEnabled = new AtomicBoolean(true);
    private Thread cleanupThread = new Thread(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (ThreadedHousekeeper.this.cleanupThreadEnabled.get()) {
                HousekeeperReference ref;
                try {
                    ref = (HousekeeperReference)ThreadedHousekeeper.this.cleanupQueue.remove();
                }
                catch (InterruptedException e1) {
                    continue;
                }
                ref.clear();
                try {
                    ref.cleanup();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                ThreadedHousekeeper threadedHousekeeper = ThreadedHousekeeper.this;
                synchronized (threadedHousekeeper) {
                    ThreadedHousekeeper.this.cleanupReferences.remove(ref);
                }
            }
        }
    };

    public static synchronized Ref acquire() {
        if (instanceRefs == 0L) {
            instance = new ThreadedHousekeeper();
        }
        ++instanceRefs;
        return instance.new Ref();
    }

    private static synchronized void release() {
        if (--instanceRefs == 0L) {
            instance.close();
            instance = null;
        }
    }

    private ThreadedHousekeeper() {
        this.cleanupThread.setName("PG-JDBC Housekeeper");
        this.cleanupThread.setDaemon(true);
        this.cleanupThread.start();
    }

    @Override
    public void setLogLeakedReferences(boolean value) {
        this.logLeaks = value;
    }

    @Override
    public synchronized void emptyQueue() {
        HousekeeperReference ref;
        while ((ref = (HousekeeperReference)this.cleanupQueue.poll()) != null) {
            try {
                ref.cleanup();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.cleanupReferences.remove(ref);
        }
    }

    @Override
    public synchronized <T> Object add(T referent, Housekeeper.CleanupRunnable cleanup) {
        HousekeeperReference<Object> ref = new HousekeeperReference<Object>(cleanup, referent, this.cleanupQueue);
        this.cleanupReferences.add(ref);
        return cleanup;
    }

    @Override
    public synchronized void remove(Object cleanupKey) {
        Iterator<HousekeeperReference<?>> refIter = this.cleanupReferences.iterator();
        while (refIter.hasNext()) {
            HousekeeperReference<?> ref = refIter.next();
            if (ref.cleanup != cleanupKey) continue;
            ref.clear();
            refIter.remove();
            return;
        }
    }

    private synchronized void close() {
        this.cleanupThreadEnabled.set(false);
        this.cleanupThread.interrupt();
        try {
            this.cleanupThread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public synchronized boolean testCheckCleaned(int referentId) {
        System.gc();
        this.emptyQueue();
        for (HousekeeperReference<?> ref : this.cleanupReferences) {
            if (ref.id != referentId) continue;
            return false;
        }
        return true;
    }

    public synchronized void testClear() {
        this.cleanupReferences.clear();
    }

    private class HousekeeperReference<T>
    extends PhantomReference<T> {
        int id;
        Housekeeper.CleanupRunnable cleanup;

        public HousekeeperReference(Housekeeper.CleanupRunnable cleanup, T referent, ReferenceQueue<? super T> q) {
            super(referent, q);
            if (cleanup == referent) {
                throw new IllegalArgumentException("target cannot be the referent");
            }
            this.id = System.identityHashCode(referent);
            this.cleanup = cleanup;
        }

        void cleanup() {
            if (ThreadedHousekeeper.this.logLeaks) {
                String allocationTrace = this.printStackTrace(this.getSimplifiedAllocationStackTrace());
                logger.log(Level.WARNING, "Cleaning up leaked " + this.cleanup.getKind() + "\nAllocation occurred @\n" + allocationTrace);
            }
            this.cleanup.run();
        }

        StackTraceElement[] getSimplifiedAllocationStackTrace() {
            StackTraceElement[] allocationTrace = this.cleanup.getAllocationStackTrace();
            for (int c = 0; c < allocationTrace.length; ++c) {
                StackTraceElement e = allocationTrace[c];
                String className = e.getClassName();
                String pkgName = className.substring(0, className.lastIndexOf(46));
                String rootPkgName = "com.impossibl.postgres";
                String sqlPkgName = "java.sql";
                if ((pkgName.startsWith(rootPkgName) || pkgName.startsWith(sqlPkgName)) && (!pkgName.startsWith(rootPkgName) || !className.endsWith("Test"))) continue;
                return Arrays.copyOfRange(allocationTrace, c, allocationTrace.length);
            }
            return new StackTraceElement[0];
        }

        String printStackTrace(StackTraceElement[] trace) {
            StringBuilder sb = new StringBuilder();
            for (StackTraceElement traceElement : trace) {
                sb.append("  at ").append(traceElement).append('\n');
            }
            return sb.toString();
        }
    }

    public class Ref
    implements Housekeeper.Ref {
        private boolean released;

        @Override
        public ThreadedHousekeeper get() {
            return ThreadedHousekeeper.this;
        }

        @Override
        public void release() {
            if (!this.released) {
                this.released = true;
                ThreadedHousekeeper.release();
            }
        }

        @Override
        public <T> Object add(T reference, Housekeeper.CleanupRunnable cleanup) {
            return ThreadedHousekeeper.this.add(reference, cleanup);
        }

        @Override
        public void remove(Object cleanupKey) {
            ThreadedHousekeeper.this.remove(cleanupKey);
        }
    }
}

