/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.jdbc;

import com.impossibl.postgres.jdbc.Exceptions;
import com.impossibl.postgres.jdbc.Housekeeper;
import com.impossibl.postgres.jdbc.PGConnectionImpl;
import com.impossibl.postgres.jdbc.PGResultSet;
import com.impossibl.postgres.protocol.BindExecCommand;
import com.impossibl.postgres.protocol.CloseCommand;
import com.impossibl.postgres.protocol.Command;
import com.impossibl.postgres.protocol.DataRow;
import com.impossibl.postgres.protocol.QueryCommand;
import com.impossibl.postgres.protocol.ResultField;
import com.impossibl.postgres.protocol.ServerObjectType;
import com.impossibl.postgres.types.Type;
import java.lang.ref.WeakReference;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;

abstract class PGStatement
implements Statement {
    protected static final String CACHED_STATEMENT_PREFIX = "cached-";
    protected static final String NO_CACHE_STATEMENT_PREFIX = "nocache-";
    PGConnectionImpl connection;
    String cursorName;
    int resultSetType;
    int resultSetConcurrency;
    int resultSetHoldability;
    int fetchDirection;
    String name;
    boolean processEscapes;
    List<ResultField> resultFields;
    Integer maxRows;
    Integer fetchSize;
    Integer maxFieldSize;
    QueryCommand command;
    List<QueryCommand.ResultBatch> resultBatches;
    boolean autoClose;
    List<WeakReference<PGResultSet>> activeResultSets;
    PGResultSet generatedKeysResultSet;
    SQLWarning warningChain;
    int queryTimeout;
    final Housekeeper.Ref housekeeper;
    final Object cleanupKey;

    PGStatement(PGConnectionImpl connection, int resultSetType, int resultSetConcurrency, int resultSetHoldability, String name, List<ResultField> resultFields) {
        this.connection = connection;
        this.resultSetType = resultSetType;
        this.resultSetConcurrency = resultSetConcurrency;
        this.resultSetHoldability = resultSetHoldability;
        this.fetchDirection = 1000;
        this.name = name;
        this.processEscapes = true;
        this.resultFields = resultFields;
        this.activeResultSets = new ArrayList<WeakReference<PGResultSet>>();
        this.generatedKeysResultSet = null;
        this.fetchSize = connection.getDefaultFetchSize() != 0 ? Integer.valueOf(connection.getDefaultFetchSize()) : null;
        this.housekeeper = connection.housekeeper;
        this.cleanupKey = this.housekeeper != null ? this.housekeeper.add(this, new Cleanup(connection, name, this.activeResultSets)) : null;
    }

    void checkClosed() throws SQLException {
        if (this.isClosed()) {
            throw Exceptions.CLOSED_STATEMENT;
        }
    }

    public static void dispose(PGConnectionImpl connection, ServerObjectType objectType, String objectName) throws SQLException {
        if (objectName == null) {
            return;
        }
        CloseCommand close = connection.getProtocol().createClose(objectType, objectName);
        connection.execute(close, false);
    }

    void dispose(Command command) throws SQLException {
        if (command instanceof BindExecCommand) {
            PGStatement.dispose(this.connection, ServerObjectType.Portal, ((BindExecCommand)command).getPortalName());
        }
    }

    static void closeResultSets(List<WeakReference<PGResultSet>> resultSets) {
        for (WeakReference<PGResultSet> resultSetRef : resultSets) {
            PGResultSet resultSet = (PGResultSet)resultSetRef.get();
            if (resultSet == null) continue;
            try {
                resultSet.internalClose();
            }
            catch (SQLException sQLException) {}
        }
        resultSets.clear();
    }

    void closeResultSets() throws SQLException {
        PGStatement.closeResultSets(this.activeResultSets);
        this.generatedKeysResultSet = null;
    }

    void handleResultSetClosure(PGResultSet resultSet) throws SQLException {
        Iterator<WeakReference<PGResultSet>> resultSetRefIter = this.activeResultSets.iterator();
        while (resultSetRefIter.hasNext()) {
            WeakReference<PGResultSet> resultSetRef = resultSetRefIter.next();
            PGResultSet rs = (PGResultSet)resultSetRef.get();
            if (rs == null) {
                resultSetRefIter.remove();
                continue;
            }
            if (rs != resultSet) continue;
            resultSetRefIter.remove();
            break;
        }
        if (this.autoClose && this.activeResultSets.isEmpty()) {
            this.close();
        }
    }

    boolean needsNamedPortal() {
        return this.fetchSize != null;
    }

    void internalClose() throws SQLException {
        this.closeResultSets();
        this.resultBatches = QueryCommand.ResultBatch.releaseResultBatches(this.resultBatches);
        if (this.name != null && !this.name.startsWith(CACHED_STATEMENT_PREFIX)) {
            PGStatement.dispose(this.connection, ServerObjectType.Statement, this.name);
        }
        if (this.housekeeper != null) {
            this.housekeeper.remove(this.cleanupKey);
        }
        this.connection = null;
        this.command = null;
        this.resultFields = null;
        this.generatedKeysResultSet = null;
    }

    boolean hasResults() {
        return !this.resultBatches.isEmpty() && this.resultBatches.get(0).getResults() != null;
    }

    boolean hasUpdateCount() {
        return !this.resultBatches.isEmpty() && this.resultBatches.get(0).getRowsAffected() != null;
    }

    public boolean executeSimple(String sql) throws SQLException {
        this.closeResultSets();
        this.resultBatches = QueryCommand.ResultBatch.releaseResultBatches(this.resultBatches);
        this.command = this.connection.getProtocol().createQuery(sql);
        if (this.maxFieldSize != null) {
            this.command.setMaxFieldLength(this.maxFieldSize);
        }
        this.warningChain = this.connection.execute(this.command, true);
        this.resultBatches = new ArrayList<QueryCommand.ResultBatch>(this.command.getResultBatches());
        return this.hasResults();
    }

    public boolean executeStatement(String statementName, List<Type> parameterTypes, List<Object> parameterValues) throws SQLException {
        this.closeResultSets();
        this.resultBatches = QueryCommand.ResultBatch.releaseResultBatches(this.resultBatches);
        String portalName = null;
        if (this.needsNamedPortal()) {
            portalName = this.connection.getNextPortalName();
        }
        BindExecCommand command = this.connection.getProtocol().createBindExec(portalName, statementName, parameterTypes, parameterValues, this.resultFields);
        long queryTimeoutMS = TimeUnit.SECONDS.toMillis(this.queryTimeout);
        command.setQueryTimeout(queryTimeoutMS);
        if (this.fetchSize != null) {
            command.setMaxRows(this.fetchSize);
        }
        if (this.maxFieldSize != null) {
            command.setMaxFieldLength(this.maxFieldSize);
        }
        this.warningChain = this.connection.execute(command, true);
        this.command = command;
        this.resultBatches = new ArrayList<QueryCommand.ResultBatch>(command.getResultBatches());
        return this.hasResults();
    }

    PGResultSet createResultSet(List<ResultField> resultFields, List<DataRow> results, boolean releaseResults) throws SQLException {
        PGResultSet resultSet = new PGResultSet(this, resultFields, results, releaseResults);
        this.activeResultSets.add(new WeakReference<PGResultSet>(resultSet));
        return resultSet;
    }

    PGResultSet createResultSet(QueryCommand command, List<ResultField> resultFields, List<DataRow> results) throws SQLException {
        PGResultSet resultSet = new PGResultSet(this, command, resultFields, results);
        this.activeResultSets.add(new WeakReference<PGResultSet>(resultSet));
        return resultSet;
    }

    PGResultSet createResultSet(String cursorName, int resultSetType, int resultSetHoldability, List<ResultField> resultFields) throws SQLException {
        PGResultSet resultSet = new PGResultSet(this, cursorName, resultSetType, resultSetHoldability, resultFields);
        this.activeResultSets.add(new WeakReference<PGResultSet>(resultSet));
        return resultSet;
    }

    @Override
    public Connection getConnection() throws SQLException {
        this.checkClosed();
        return this.connection;
    }

    @Override
    public int getResultSetType() throws SQLException {
        this.checkClosed();
        return this.resultSetType;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        this.checkClosed();
        return this.resultSetConcurrency;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        this.checkClosed();
        return this.resultSetHoldability;
    }

    @Override
    public boolean isPoolable() throws SQLException {
        this.checkClosed();
        return false;
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        this.checkClosed();
        throw Exceptions.NOT_IMPLEMENTED;
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        this.checkClosed();
        return this.autoClose;
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        this.checkClosed();
        this.autoClose = true;
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        this.checkClosed();
        return this.maxFieldSize != null ? this.maxFieldSize : 0;
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        this.checkClosed();
        if (max < 0) {
            throw Exceptions.ILLEGAL_ARGUMENT;
        }
        this.maxFieldSize = max;
    }

    @Override
    public int getMaxRows() throws SQLException {
        this.checkClosed();
        return this.maxRows != null ? this.maxRows : 0;
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        this.checkClosed();
        if (max < 0) {
            throw Exceptions.ILLEGAL_ARGUMENT;
        }
        this.maxRows = max;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.checkClosed();
        return this.fetchDirection;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.checkClosed();
        if (direction != 1000 && direction != 1001 && direction != 1002) {
            throw Exceptions.ILLEGAL_ARGUMENT;
        }
        this.fetchDirection = direction;
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.checkClosed();
        return this.fetchSize != null ? this.fetchSize : 0;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.checkClosed();
        if (rows < 0) {
            throw Exceptions.ILLEGAL_ARGUMENT;
        }
        this.fetchSize = rows;
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.checkClosed();
        this.processEscapes = enable;
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        this.checkClosed();
        return this.queryTimeout;
    }

    @Override
    public void setQueryTimeout(int queryTimeout) throws SQLException {
        this.checkClosed();
        if (queryTimeout < 0) {
            throw new SQLException("invalid query timeout");
        }
        this.queryTimeout = queryTimeout;
    }

    String getCursorName() {
        if (this.cursorName == null) {
            return "cursor" + super.hashCode();
        }
        return this.cursorName;
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        this.checkClosed();
        this.cursorName = name;
    }

    @Override
    public PGResultSet getResultSet() throws SQLException {
        this.checkClosed();
        if (this.generatedKeysResultSet != null || this.command == null || !this.hasResults()) {
            return null;
        }
        if (this.cursorName != null) {
            QueryCommand.ResultBatch resultBatch = this.resultBatches.get(0);
            resultBatch.release();
            return this.createResultSet(this.getCursorName(), this.resultSetType, this.resultSetHoldability, resultBatch.getFields());
        }
        if (this.command.getStatus() == QueryCommand.Status.Completed) {
            QueryCommand.ResultBatch resultBatch = this.resultBatches.get(0);
            return this.createResultSet(resultBatch.getFields(), resultBatch.getResults(), false);
        }
        QueryCommand.ResultBatch resultBatch = this.resultBatches.remove(0);
        PGResultSet rs = this.createResultSet(this.command, resultBatch.getFields(), resultBatch.getResults());
        this.command = null;
        return rs;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        this.checkClosed();
        if (this.command == null || !this.hasUpdateCount()) {
            return -1;
        }
        return (int)this.resultBatches.get(0).getRowsAffected().longValue();
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return this.getMoreResults(3);
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        this.checkClosed();
        if (this.resultBatches.isEmpty()) {
            return false;
        }
        QueryCommand.ResultBatch finishedBatch = this.resultBatches.remove(0);
        finishedBatch.release();
        return this.hasResults();
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        this.checkClosed();
        if (this.generatedKeysResultSet == null) {
            return this.createResultSet(Collections.emptyList(), Collections.emptyList(), false);
        }
        return this.generatedKeysResultSet;
    }

    @Override
    public void cancel() throws SQLException {
        this.checkClosed();
        throw Exceptions.NOT_IMPLEMENTED;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.connection == null;
    }

    @Override
    public void close() throws SQLException {
        if (this.isClosed()) {
            return;
        }
        this.connection.handleStatementClosure(this);
        this.internalClose();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkClosed();
        return this.warningChain;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.checkClosed();
        this.warningChain = null;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (!iface.isAssignableFrom(this.getClass())) {
            throw Exceptions.UNWRAP_ERROR;
        }
        return iface.cast(this);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isAssignableFrom(this.getClass());
    }

    @Override
    public long getLargeUpdateCount() throws SQLException {
        throw Exceptions.NOT_IMPLEMENTED;
    }

    @Override
    public void setLargeMaxRows(long max) throws SQLException {
        throw Exceptions.NOT_IMPLEMENTED;
    }

    @Override
    public long getLargeMaxRows() throws SQLException {
        throw Exceptions.NOT_IMPLEMENTED;
    }

    @Override
    public long[] executeLargeBatch() throws SQLException {
        throw Exceptions.NOT_IMPLEMENTED;
    }

    @Override
    public long executeLargeUpdate(String sql) throws SQLException {
        throw Exceptions.NOT_IMPLEMENTED;
    }

    @Override
    public long executeLargeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        throw Exceptions.NOT_IMPLEMENTED;
    }

    @Override
    public long executeLargeUpdate(String sql, int[] columnIndexes) throws SQLException {
        throw Exceptions.NOT_IMPLEMENTED;
    }

    @Override
    public long executeLargeUpdate(String sql, String[] columnNames) throws SQLException {
        throw Exceptions.NOT_IMPLEMENTED;
    }

    static class Cleanup
    implements Housekeeper.CleanupRunnable {
        PGConnectionImpl connection;
        String name;
        List<WeakReference<PGResultSet>> resultSets;
        StackTraceElement[] allocationStackTrace;

        public Cleanup(PGConnectionImpl connection, String name, List<WeakReference<PGResultSet>> resultSets) {
            this.connection = connection;
            this.name = name;
            this.resultSets = resultSets;
            this.allocationStackTrace = new Exception().getStackTrace();
        }

        @Override
        public String getKind() {
            return "statement";
        }

        @Override
        public StackTraceElement[] getAllocationStackTrace() {
            return this.allocationStackTrace;
        }

        @Override
        public void run() {
            PGStatement.closeResultSets(this.resultSets);
            try {
                PGStatement.dispose(this.connection, ServerObjectType.Statement, this.name);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.connection.handleStatementClosure(null);
            this.connection = null;
        }
    }
}

