/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Language;
import org.languagetool.Tag;
import org.languagetool.language.Demo;
import org.languagetool.rules.CleanOverlappingFilter;
import org.languagetool.rules.FakeRule;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;

public class CleanOverlappingFilterTest {
    @Test
    public void testFilter() {
        MyCleanOverlappingFilter filter = new MyCleanOverlappingFilter(new MyDemoLang(), true);
        AnalyzedSentence sentence = new AnalyzedSentence(new AnalyzedTokenReadings[0]);
        List matches1 = new ArrayList();
        matches1 = filter.filter(matches1);
        MatcherAssert.assertThat((Object)matches1.size(), (Matcher)Is.is((Object)0));
        List matches2 = Arrays.asList(new RuleMatch((Rule)new FakeRule(), sentence, 0, 10, "msg"), new RuleMatch((Rule)new FakeRule(), sentence, 11, 20, "msg"));
        matches2 = filter.filter(matches2);
        MatcherAssert.assertThat((Object)matches2.size(), (Matcher)Is.is((Object)2));
        List matches3 = Arrays.asList(new RuleMatch((Rule)new FakeRule(), sentence, 0, 10, "msg"), new RuleMatch((Rule)new FakeRule(), sentence, 10, 20, "msg"));
        matches3 = filter.filter(matches3);
        MatcherAssert.assertThat((Object)matches3.size(), (Matcher)Is.is((Object)2));
        List matches4 = Arrays.asList(new RuleMatch((Rule)new FakeRule("P1_RULE"), sentence, 0, 10, "msg1"), new RuleMatch((Rule)new FakeRule("P1_RULE_B"), sentence, 9, 20, "msg2"));
        matches4 = filter.filter(matches4);
        MatcherAssert.assertThat((Object)matches4.size(), (Matcher)Is.is((Object)1));
        MatcherAssert.assertThat((Object)((RuleMatch)matches4.get(0)).getRule().getId(), (Matcher)Is.is((Object)"P1_RULE_B"));
        List matches5 = Arrays.asList(new RuleMatch((Rule)new FakeRule("P1_RULE_B"), sentence, 0, 10, "msg1"), new RuleMatch((Rule)new FakeRule("P1_RULE"), sentence, 9, 20, "msg2"));
        matches5 = filter.filter(matches5);
        MatcherAssert.assertThat((Object)matches5.size(), (Matcher)Is.is((Object)1));
        MatcherAssert.assertThat((Object)((RuleMatch)matches5.get(0)).getRule().getId(), (Matcher)Is.is((Object)"P1_RULE"));
        List matches6 = Arrays.asList(new RuleMatch((Rule)new FakeRule("P1_RULE"), sentence, 0, 10, "msg1"), new RuleMatch((Rule)new FakeRule("P2_RULE"), sentence, 9, 20, "msg2"));
        matches6 = filter.filter(matches6);
        MatcherAssert.assertThat((Object)matches6.size(), (Matcher)Is.is((Object)1));
        MatcherAssert.assertThat((Object)((RuleMatch)matches6.get(0)).getRule().getId(), (Matcher)Is.is((Object)"P2_RULE"));
        List matches7 = Arrays.asList(new RuleMatch((Rule)new FakeRule("P2_RULE"), sentence, 0, 10, "msg1"), new RuleMatch((Rule)new FakeRule("P1_RULE"), sentence, 9, 20, "msg2"));
        matches7 = filter.filter(matches7);
        MatcherAssert.assertThat((Object)matches7.size(), (Matcher)Is.is((Object)1));
        MatcherAssert.assertThat((Object)((RuleMatch)matches7.get(0)).getRule().getId(), (Matcher)Is.is((Object)"P2_RULE"));
        List matches8 = Arrays.asList(new RuleMatch((Rule)new FakeRule("P2_PREMIUM_RULE"), sentence, 0, 10, "msg1"), new RuleMatch((Rule)new FakeRule("P1_RULE"), sentence, 9, 20, "msg2"));
        matches8 = filter.filter(matches8);
        MatcherAssert.assertThat((Object)matches8.size(), (Matcher)Is.is((Object)1));
        MatcherAssert.assertThat((Object)((RuleMatch)matches8.get(0)).getRule().getId(), (Matcher)Is.is((Object)"P1_RULE"));
        List matches8b = Arrays.asList(new RuleMatch((Rule)new FakeRule("P1_RULE"), sentence, 0, 10, "msg2"), new RuleMatch((Rule)new FakeRule("P2_PREMIUM_RULE"), sentence, 9, 20, "msg1"));
        matches8b = filter.filter(matches8b);
        MatcherAssert.assertThat((Object)matches8b.size(), (Matcher)Is.is((Object)1));
        MatcherAssert.assertThat((Object)((RuleMatch)matches8b.get(0)).getRule().getId(), (Matcher)Is.is((Object)"P1_RULE"));
        List matches9 = Arrays.asList(new RuleMatch((Rule)new FakeRule("P2_PREMIUM_RULE", Tag.picky), sentence, 0, 10, "msg1"), new RuleMatch((Rule)new FakeRule("P1_RULE"), sentence, 9, 20, "msg2"));
        matches9 = filter.filter(matches9);
        MatcherAssert.assertThat((Object)matches9.size(), (Matcher)Is.is((Object)1));
        MatcherAssert.assertThat((Object)((RuleMatch)matches9.get(0)).getRule().getId(), (Matcher)Is.is((Object)"P1_RULE"));
        List matches10 = Arrays.asList(new RuleMatch((Rule)new FakeRule("P1_RULE"), sentence, 0, 10, "msg2"), new RuleMatch((Rule)new FakeRule("P2_PREMIUM_RULE", Tag.picky), sentence, 9, 20, "msg1"));
        matches10 = filter.filter(matches10);
        MatcherAssert.assertThat((Object)matches10.size(), (Matcher)Is.is((Object)1));
        MatcherAssert.assertThat((Object)((RuleMatch)matches10.get(0)).getRule().getId(), (Matcher)Is.is((Object)"P1_RULE"));
        List matches11 = Arrays.asList(new RuleMatch((Rule)new FakeRule("P2_RULE", Tag.picky), sentence, 0, 10, "msg1"), new RuleMatch((Rule)new FakeRule("P1_RULE"), sentence, 9, 20, "msg2"));
        matches11 = filter.filter(matches11);
        MatcherAssert.assertThat((Object)matches11.size(), (Matcher)Is.is((Object)1));
        MatcherAssert.assertThat((Object)((RuleMatch)matches11.get(0)).getRule().getId(), (Matcher)Is.is((Object)"P1_RULE"));
        List matches12 = Arrays.asList(new RuleMatch((Rule)new FakeRule("P1_RULE"), sentence, 0, 10, "msg2"), new RuleMatch((Rule)new FakeRule("P2_RULE", Tag.picky), sentence, 9, 20, "msg1"));
        matches12 = filter.filter(matches12);
        MatcherAssert.assertThat((Object)matches12.size(), (Matcher)Is.is((Object)1));
        MatcherAssert.assertThat((Object)((RuleMatch)matches12.get(0)).getRule().getId(), (Matcher)Is.is((Object)"P1_RULE"));
        RuleMatch ruleMatch1 = new RuleMatch((Rule)new FakeRule("COMMA_LOW_PRIORITY"), sentence, 5, 10, "msg1");
        ruleMatch1.addSuggestedReplacement("right,");
        RuleMatch ruleMatch2 = new RuleMatch((Rule)new FakeRule("COMMA_HIGH_PRIORITY"), sentence, 10, 15, "msg2");
        ruleMatch2.addSuggestedReplacement(", left");
        List matches14 = Arrays.asList(ruleMatch1, ruleMatch2);
        matches14 = filter.filter(matches14);
        MatcherAssert.assertThat((Object)matches14.size(), (Matcher)Is.is((Object)1));
        MatcherAssert.assertThat((Object)((RuleMatch)matches14.get(0)).getRule().getId(), (Matcher)Is.is((Object)"COMMA_HIGH_PRIORITY"));
        RuleMatch ruleMatch3 = new RuleMatch((Rule)new FakeRule("COMMA_HIGH_PRIORITY"), sentence, 5, 10, "msg1");
        ruleMatch3.addSuggestedReplacement("right,");
        RuleMatch ruleMatch4 = new RuleMatch((Rule)new FakeRule("COMMA_LOW_PRIORITY"), sentence, 10, 15, "msg2");
        ruleMatch4.addSuggestedReplacement(", left");
        List matches15 = Arrays.asList(ruleMatch3, ruleMatch4);
        matches15 = filter.filter(matches15);
        MatcherAssert.assertThat((Object)matches15.size(), (Matcher)Is.is((Object)1));
        MatcherAssert.assertThat((Object)((RuleMatch)matches15.get(0)).getRule().getId(), (Matcher)Is.is((Object)"COMMA_HIGH_PRIORITY"));
        RuleMatch ruleMatch5 = new RuleMatch((Rule)new FakeRule("COMMA_LOW_PRIORITY2"), sentence, 5, 10, "msg1");
        ruleMatch5.addSuggestedReplacement("right,");
        RuleMatch ruleMatch6 = new RuleMatch((Rule)new FakeRule("COMMA_LOW_PRIORITY"), sentence, 10, 15, "msg2");
        ruleMatch6.addSuggestedReplacement(", left");
        List matches16 = Arrays.asList(ruleMatch5, ruleMatch6);
        matches16 = filter.filter(matches16);
        MatcherAssert.assertThat((Object)matches16.size(), (Matcher)Is.is((Object)1));
        MatcherAssert.assertThat((Object)((RuleMatch)matches16.get(0)).getRule().getId(), (Matcher)Is.is((Object)"COMMA_LOW_PRIORITY"));
        try {
            List<RuleMatch> unordered = Arrays.asList(new RuleMatch((Rule)new FakeRule("P1_RULE"), sentence, 11, 12, "msg2"), new RuleMatch((Rule)new FakeRule("P2_RULE", Tag.picky), sentence, 9, 10, "msg1"));
            filter.filter(unordered);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    static class MyDemoLang
    extends Demo {
        MyDemoLang() {
        }

        protected int getPriorityForId(String id) {
            switch (id) {
                case "P3_RULE": {
                    return 3;
                }
                case "P2_RULE": 
                case "P2_PREMIUM_RULE": 
                case "COMMA_HIGH_PRIORITY": {
                    return 2;
                }
                case "P1_RULE": 
                case "P1_RULE_B": 
                case "P1_PREMIUM_RULE": 
                case "COMMA_LOW_PRIORITY": 
                case "COMMA_LOW_PRIORITY2": {
                    return 1;
                }
                case "MISC": {
                    return 0;
                }
            }
            throw new RuntimeException("No priority defined for " + id);
        }
    }

    static class MyCleanOverlappingFilter
    extends CleanOverlappingFilter {
        MyCleanOverlappingFilter(Language lang, boolean hidePremiumMatches) {
            super(lang, hidePremiumMatches);
        }

        protected boolean isPremiumRule(RuleMatch ruleMatch) {
            return ruleMatch.getRule().getId().contains("PREMIUM");
        }
    }
}

