/*
 * Decompiled with CFR 0.152.
 */
package com.elovirta.pdf.ant;

import java.io.InputStream;
import java.net.URI;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamSource;

class ClasspathResolver
implements URIResolver {
    private static final String CLASSPATH_SCHEME = "classpath";

    ClasspathResolver() {
    }

    @Override
    public Source resolve(String href, String base) throws TransformerException {
        InputStream resourceAsStream;
        URI abs = URI.create(href);
        if (!abs.isAbsolute()) {
            abs = URI.create(base).resolve(href);
        }
        if (!abs.getScheme().equals(CLASSPATH_SCHEME)) {
            throw new IllegalArgumentException(String.format("Only %s URI scheme supported: %s", CLASSPATH_SCHEME, abs));
        }
        String path = abs.getPath();
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if ((resourceAsStream = this.getClass().getClassLoader().getResourceAsStream(path)) == null) {
            throw new TransformerException(String.format("%s not found", abs));
        }
        return new StreamSource(resourceAsStream, abs.toString());
    }
}

