/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import java.util.Vector;
import javax.microedition.lcdui.CmdInfo;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandList;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.ScmDeviceLabel;
import javax.microedition.lcdui.ScmDisplayable;
import javax.microedition.lcdui.Ticker;
import javax.microedition.midlet.ApplicationManager;
import org.me4se.scm.ScmComponent;

public abstract class Displayable {
    CommandListener commandListener;
    private Vector commands = new Vector();
    Display display;
    ScmDisplayable container;
    ScmDeviceLabel titleComponent = new ScmDeviceLabel("title", null, false);
    ScmDeviceLabel tickerComponent = new ScmDeviceLabel("ticker", null, false);
    String title;
    Ticker ticker;
    Vector commandMenuEntries;
    boolean selectButtonRequired;

    Displayable() {
        Display.check();
    }

    void _showNotify() {
    }

    Item getCurrentItem() {
        return null;
    }

    void insertCommand(Vector v, Command cmd, Item item) {
        int i;
        for (i = 0; i < v.size() && ((CmdInfo)v.elementAt((int)i)).command.getPriority() < cmd.getPriority(); ++i) {
        }
        v.insertElementAt(new CmdInfo(cmd, item), i);
    }

    Vector getCommandInfoList() {
        int i;
        Vector<CmdInfo> v = new Vector<CmdInfo>();
        Item item = this.getCurrentItem();
        if (item != null && item.commands != null) {
            for (i = 0; i < item.commands.size(); ++i) {
                this.insertCommand(v, (Command)item.commands.elementAt(i), item);
            }
        }
        for (i = 0; i < this.commands.size(); ++i) {
            this.insertCommand(v, (Command)this.commands.elementAt(i), null);
        }
        if (this.selectButtonRequired && ApplicationManager.getProperty("command.menu.select", "").toUpperCase().startsWith("SOFT")) {
            v.insertElementAt(new CmdInfo(ScmDisplayable.ITEM_SELECT_COMMAND, null), 0);
        }
        return v;
    }

    public synchronized void addCommand(Command cmd) {
        if (cmd == null) {
            return;
        }
        if (this.commands.indexOf(cmd) != -1) {
            return;
        }
        for (int i = 0; i < this.commands.size(); ++i) {
            Command curCmd = (Command)this.commands.elementAt(i);
            if (cmd.getPriority() >= curCmd.getPriority()) continue;
            this.commands.insertElementAt(cmd, i);
            this.container.updateButtons();
            return;
        }
        this.commands.insertElementAt(cmd, this.commands.size());
        this.container.updateButtons();
    }

    void handleCommand(Command cmd, Item item) {
        try {
            if (cmd == ScmDisplayable.OPTIONS_COMMAND) {
                this.display.setCurrent(new CommandList(this));
            } else if (cmd == ScmDisplayable.ITEM_SELECT_COMMAND) {
                ScmComponent f = this.container.getFocusOwner();
                if (f instanceof ScmDeviceLabel) {
                    ((ScmDeviceLabel)f).action();
                }
            } else if (cmd != null) {
                if (item != null) {
                    if (item.listener != null) {
                        item.listener.commandAction(cmd, item);
                    }
                } else if (this.commandListener != null) {
                    this.commandListener.commandAction(cmd, this);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean isShown() {
        return this.display != null && this.display.getCurrent() == this;
    }

    public void setCommandListener(CommandListener commandListener) {
        this.commandListener = commandListener;
    }

    public void removeCommand(Command cmd) {
        try {
            int idx = this.commands.indexOf(cmd);
            if (idx == -1) {
                return;
            }
            this.commands.removeElementAt(idx);
            this.container.updateButtons();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
        this.titleComponent.setText(title);
        this.container.invalidate();
    }

    public Ticker getTicker() {
        return this.ticker;
    }

    public void setTicker(Ticker ticker) {
        this.ticker = ticker;
    }

    public int getWidth() {
        return this.container.main.getWidth();
    }

    public int getHeight() {
        return this.container.main.getHeight();
    }

    protected void sizeChanged(int w, int h) {
    }
}

