/*
 * Decompiled with CFR 0.152.
 */
package net.yura.domination.engine.p2pclient;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import net.yura.domination.engine.OnlineRisk;
import net.yura.domination.engine.Risk;
import net.yura.domination.engine.core.RiskGame;
import net.yura.domination.engine.p2pclient.ChatDisplayThread;

public class ChatClient
implements OnlineRisk {
    private String myUID;
    private PrintWriter outChat = null;
    private BufferedReader inChat = null;
    private Socket chatSocket = null;
    private ChatDisplayThread myReader = null;

    public ChatClient(Risk risk, String uid, String host, int port) throws Exception {
        this.myUID = uid;
        this.chatSocket = new Socket(host, port);
        this.outChat = new PrintWriter(this.chatSocket.getOutputStream(), true);
        this.inChat = new BufferedReader(new InputStreamReader(this.chatSocket.getInputStream()));
        this.myReader = new ChatDisplayThread(risk, this.inChat);
        this.myReader.start();
        this.outChat.println("12 " + uid + " " + RiskGame.getDefaultMap());
    }

    public void sendUserCommand(String mtemp) {
        this.outChat.println(this.myUID + " " + mtemp);
    }

    public void sendGameCommand(String mtemp) {
        this.outChat.println(mtemp);
    }

    public void closeGame() {
        try {
            this.outChat.close();
            this.inChat.close();
            this.chatSocket.shutdownInput();
            this.chatSocket.shutdownOutput();
            this.chatSocket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.chatSocket = null;
    }

    public void playerRenamed(String oldName, String newName, String newAddress, int newType) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

