/*
 * Decompiled with CFR 0.152.
 */
package net.yura.mobile.gui.components;

import java.util.Vector;
import net.yura.mobile.gui.ActionListener;
import net.yura.mobile.gui.Icon;
import net.yura.mobile.gui.KeyEvent;
import net.yura.mobile.gui.components.Button;
import net.yura.mobile.gui.components.Component;
import net.yura.mobile.gui.components.Frame;
import net.yura.mobile.gui.components.Label;
import net.yura.mobile.gui.components.Panel;
import net.yura.mobile.gui.components.Window;
import net.yura.mobile.gui.layout.BorderLayout;
import net.yura.mobile.gui.layout.GridLayout;
import net.yura.mobile.logging.Logger;

public class FrameTitlePane
extends Panel
implements ActionListener {
    private static String[] icons = new String[]{"#", "+", "_", "[]", "X"};
    private static String[] commands = new String[]{"resize", "move", "min", "max", "close"};
    private Label title;
    private Panel buttonPanel;
    private int oldX;
    private int oldY;
    private boolean move;
    private boolean resize;
    private Component old;

    public FrameTitlePane() {
        super(new BorderLayout());
        this.setName("TitleBar");
        this.buttonPanel = new Panel(new GridLayout(1, 0, 2));
        this.buttonPanel.setName("WindowControlPanel");
        this.title = new Label();
        this.title.setName("TitleBarLabel");
        this.add(this.title);
        this.add((Component)this.buttonPanel, 8);
        this.updateUI();
    }

    public void updateUI() {
        super.updateUI();
        if (this.title != null) {
            String titleAlignment = (String)this.theme.getProperty("titleAlignment", 0);
            if ("center".equals(titleAlignment)) {
                this.setTitleAlignment(1);
            } else if ("trailing".equals(titleAlignment)) {
                this.setTitleAlignment(8);
            } else {
                this.setTitleAlignment(4);
            }
        }
    }

    public void setButtonVisable(String action, boolean vis) {
        Button found = null;
        Vector comps = this.buttonPanel.getComponents();
        for (int c = 0; c < comps.size(); ++c) {
            Button button = (Button)comps.elementAt(c);
            if (!action.equals(button.getActionCommand())) continue;
            found = button;
            break;
        }
        if (vis && found == null) {
            String icon = "";
            int pos = 0;
            for (int c = 0; c < commands.length; ++c) {
                if (!action.equals(commands[c])) continue;
                icon = icons[c];
                pos = c;
                break;
            }
            Button b = new Button(icon);
            b.addActionListener(this);
            b.setActionCommand(action);
            for (int c = 0; c < comps.size(); ++c) {
                Button button = (Button)comps.elementAt(c);
                for (int i = pos + 1; i < commands.length; ++i) {
                    if (!commands[i].equals(button.getActionCommand())) continue;
                    this.buttonPanel.insert(b, c);
                    return;
                }
            }
            this.buttonPanel.add(b);
        } else if (!vis && found != null) {
            this.buttonPanel.remove(found);
        }
    }

    public void setTitle(String title) {
        this.title.setText(title);
    }

    public String getTitle() {
        return this.title.getText();
    }

    public void setIconImage(Icon img) {
        this.title.setIcon(img);
    }

    public void setTitleAlignment(int a) {
        this.title.setHorizontalAlignment(a);
    }

    public void processMouseEvent(int type, int x, int y, KeyEvent keys) {
        Frame owner;
        if (type == 1) {
            this.oldX = x;
            this.oldY = y;
        } else if (type == 0 && !(owner = (Frame)this.getWindow()).isMaximum()) {
            this.move(owner, owner.getX() + (x - this.oldX), owner.getY() + (y - this.oldY));
        }
    }

    private void move(Window owner, int x, int y) {
        owner.getDesktopPane().repaintHole(owner);
        owner.setLocation(x, y);
        owner.repaint();
    }

    private void resize(Window owner, int w, int h) {
        owner.getDesktopPane().repaintHole(owner);
        owner.setSize(w, h);
        owner.repaint();
    }

    public boolean processKeyEvent(KeyEvent keypad) {
        Window owner = this.getWindow();
        if (keypad.isDownAction(2)) {
            if (this.move) {
                this.move(owner, owner.getX() - 2, owner.getY());
            } else if (this.resize) {
                this.resize(owner, owner.getWidth() - 2, owner.getHeight());
            }
            return true;
        }
        if (keypad.isDownAction(5)) {
            if (this.move) {
                this.move(owner, owner.getX() + 2, owner.getY());
            } else if (this.resize) {
                this.resize(owner, owner.getWidth() + 2, owner.getHeight());
            }
            return true;
        }
        if (keypad.isDownAction(1)) {
            if (this.move) {
                this.move(owner, owner.getX(), owner.getY() - 2);
            } else if (this.resize) {
                this.resize(owner, owner.getWidth(), owner.getHeight() - 2);
            }
            return true;
        }
        if (keypad.isDownAction(6)) {
            if (this.move) {
                this.move(owner, owner.getX(), owner.getY() + 2);
            } else if (this.resize) {
                this.resize(owner, owner.getWidth(), owner.getHeight() + 2);
            }
            return true;
        }
        if (keypad.isDownAction(8)) {
            this.move = false;
            this.resize = false;
            this.old.requestFocusInWindow();
            return true;
        }
        return false;
    }

    public void actionPerformed(String actionCommand) {
        if (this.resize || this.move) {
            this.move = false;
            this.resize = false;
        } else if ("move".equals(actionCommand)) {
            this.old = this.getWindow().getFocusOwner();
            this.requestFocusInWindow();
            this.move = true;
        } else if ("resize".equals(actionCommand)) {
            this.old = this.getWindow().getFocusOwner();
            this.requestFocusInWindow();
            this.resize = true;
        } else if ("close".equals(actionCommand)) {
            this.getWindow().doClose();
        } else if ("min".equals(actionCommand)) {
            Vector windows = this.getDesktopPane().getAllFrames();
            if (windows.size() > 1) {
                this.getDesktopPane().setSelectedFrame((Window)windows.elementAt(windows.size() - 2));
            }
        } else if ("max".equals(actionCommand)) {
            Window w = this.getWindow();
            if (w instanceof Frame) {
                Frame f = (Frame)w;
                f.setMaximum(!f.isMaximum);
                f.repaint();
            }
        } else {
            Logger.warn("unknow Window command: " + actionCommand);
        }
    }
}

