/*
 * Decompiled with CFR 0.152.
 */
package net.yura.mobile.gui.border;

import net.yura.mobile.gui.Graphics2D;
import net.yura.mobile.gui.border.Border;
import net.yura.mobile.gui.components.Component;

public class TabBorder
implements Border {
    private int orient;
    private int color1;
    private int color2;
    private int color3;
    private int color4;

    public TabBorder(int a, int white, int darker1, int darker2, int darker3) {
        this.color3 = darker3;
        this.color2 = darker2;
        this.color4 = darker1;
        this.color1 = white;
        this.orient = a;
    }

    public void paintBorder(Component c, Graphics2D g, int width, int height) {
        int x = -2;
        int y = -2;
        int xx = width + 1;
        int yy = height + 1;
        g.setColor(this.color1);
        switch (this.orient) {
            case 16: {
                g.drawLine(x + 3, y, xx - 1, y);
                g.drawLine(x, y + 3, x, yy);
                g.drawLine(x, y + 3, x + 3, y);
                g.setColor(this.color2);
                g.drawLine(xx - 1, y + 1, xx - 1, yy);
                g.setColor(this.color3);
                g.drawLine(xx, y + 2, xx, yy);
                g.setColor(this.color4);
                g.drawLine(-1, height + 1, width - 1, height + 1);
                break;
            }
            case 32: {
                g.drawLine(x, y, x, yy - 3);
                g.setColor(this.color2);
                g.drawLine(xx - 1, y, xx - 1, yy - 1);
                g.drawLine(x + 3, yy - 1, xx - 1, yy - 1);
                g.drawLine(x, yy - 4, x + 4, yy);
                g.setColor(this.color3);
                g.drawLine(xx, y, xx, yy);
                g.drawLine(x + 3, yy, xx - 1, yy);
                g.drawLine(x, yy - 3, x + 3, yy);
                g.setColor(this.color4);
                g.drawLine(-1, -2, width - 1, -2);
                break;
            }
            case 4: {
                g.drawLine(x + 3, y, xx, y);
                g.drawLine(x, y + 3, x, yy - 3);
                g.drawLine(x, y + 3, x + 3, y);
                g.setColor(this.color2);
                g.drawLine(x + 3, yy - 1, xx, yy - 1);
                g.drawLine(x, yy - 4, x + 4, yy);
                g.setColor(this.color3);
                g.drawLine(x + 3, yy, xx, yy);
                g.drawLine(x, yy - 3, x + 3, yy);
                g.setColor(this.color4);
                g.drawLine(width + 1, -1, width + 1, height - 1);
                break;
            }
            case 8: {
                g.drawLine(x, y, xx - 3, y);
                g.setColor(this.color2);
                g.drawLine(xx - 4, y, xx, y + 4);
                g.drawLine(xx - 1, y + 4, xx - 1, yy - 4);
                g.drawLine(xx, yy - 4, xx - 4, yy);
                g.drawLine(x, yy - 1, xx - 4, yy - 1);
                g.setColor(this.color3);
                g.drawLine(xx - 3, y, xx, y + 3);
                g.drawLine(xx, y + 3, xx, yy - 3);
                g.drawLine(xx, yy - 3, xx - 3, yy);
                g.drawLine(x, yy, xx - 3, yy);
                g.setColor(this.color4);
                g.drawLine(-2, -1, -2, height - 1);
            }
        }
    }

    public int getTop() {
        return 2;
    }

    public int getBottom() {
        return 2;
    }

    public int getRight() {
        return 2;
    }

    public int getLeft() {
        return 2;
    }

    public boolean isBorderOpaque() {
        return false;
    }
}

