/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.jvm.inspection;

import java.util.function.BiConsumer;
import javax.annotation.Nonnull;
import org.gradle.internal.jvm.inspection.JvmInstallationMetadata;
import org.gradle.internal.jvm.inspection.JvmMetadataDetector;
import org.gradle.jvm.toolchain.internal.InstallationLocation;

public class ReportingJvmMetadataDetector
implements JvmMetadataDetector {
    @Nonnull
    private final JvmMetadataDetector delegate;
    @Nonnull
    private final BiConsumer<InstallationLocation, JvmInstallationMetadata> reporter;

    public ReportingJvmMetadataDetector(@Nonnull JvmMetadataDetector delegate, @Nonnull BiConsumer<InstallationLocation, JvmInstallationMetadata> reporter) {
        this.delegate = delegate;
        this.reporter = reporter;
    }

    @Override
    public JvmInstallationMetadata getMetadata(InstallationLocation javaInstallationLocation) {
        JvmInstallationMetadata delegateResult = this.delegate.getMetadata(javaInstallationLocation);
        this.reporter.accept(javaInstallationLocation, delegateResult);
        return delegateResult;
    }
}

