/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.nativeplatform.internal.incremental;

import java.io.File;
import java.util.Collection;
import org.gradle.cache.ObjectHolder;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.CallableBuildOperation;
import org.gradle.language.nativeplatform.internal.incremental.CompilationState;
import org.gradle.language.nativeplatform.internal.incremental.IncrementalCompilation;
import org.gradle.language.nativeplatform.internal.incremental.IncrementalCompileFilesFactory;
import org.gradle.language.nativeplatform.internal.incremental.IncrementalCompileSourceProcessor;

public class IncrementalCompileProcessor {
    private final ObjectHolder<CompilationState> previousCompileStateCache;
    private final IncrementalCompileFilesFactory incrementalCompileFilesFactory;
    private final BuildOperationExecutor buildOperationExecutor;

    public IncrementalCompileProcessor(ObjectHolder<CompilationState> previousCompileStateCache, IncrementalCompileFilesFactory incrementalCompileFilesFactory, BuildOperationExecutor buildOperationExecutor) {
        this.previousCompileStateCache = previousCompileStateCache;
        this.incrementalCompileFilesFactory = incrementalCompileFilesFactory;
        this.buildOperationExecutor = buildOperationExecutor;
    }

    public IncrementalCompilation processSourceFiles(final Collection<File> sourceFiles) {
        return (IncrementalCompilation)this.buildOperationExecutor.call((CallableBuildOperation)new CallableBuildOperation<IncrementalCompilation>(){

            public IncrementalCompilation call(BuildOperationContext context) {
                CompilationState previousCompileState = (CompilationState)IncrementalCompileProcessor.this.previousCompileStateCache.get();
                IncrementalCompileSourceProcessor processor = IncrementalCompileProcessor.this.incrementalCompileFilesFactory.files(previousCompileState);
                for (File sourceFile : sourceFiles) {
                    processor.processSource(sourceFile);
                }
                return processor.getResult();
            }

            public BuildOperationDescriptor.Builder description() {
                ProcessSourceFilesDetails operationDetails = new ProcessSourceFilesDetails(sourceFiles.size());
                return BuildOperationDescriptor.displayName((String)"Processing source files").details((Object)operationDetails);
            }

            class ProcessSourceFilesDetails {
                private final int sourceFileCount;

                ProcessSourceFilesDetails(int sourceFileCount) {
                    this.sourceFileCount = sourceFileCount;
                }

                public int getSourceFileCount() {
                    return this.sourceFileCount;
                }
            }
        });
    }
}

