/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.util;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.deprecation.DeprecationMessageBuilder;
import org.gradle.util.internal.GUtil;

@Deprecated
public class NameMatcher {
    private final SortedSet<String> matches = new TreeSet<String>();
    private final Set<String> candidates = new TreeSet<String>();
    private String pattern;

    public <T> T find(String pattern, Map<String, ? extends T> items) {
        String name = this.find(pattern, items.keySet());
        if (name != null) {
            return items.get(name);
        }
        return null;
    }

    public String find(String pattern, Collection<String> items) {
        this.pattern = pattern;
        this.matches.clear();
        this.candidates.clear();
        if (items.contains(pattern)) {
            this.matches.add(pattern);
            return pattern;
        }
        if (pattern.length() == 0) {
            return null;
        }
        Pattern camelCasePattern = NameMatcher.getPatternForName(pattern);
        Pattern normalisedCamelCasePattern = Pattern.compile(camelCasePattern.pattern(), 2);
        String normalisedPattern = pattern.toUpperCase();
        Pattern kebabCasePattern = NameMatcher.getKebabCasePatternForName(pattern);
        Pattern kebabCasePrefixPattern = Pattern.compile(kebabCasePattern.pattern() + "[\\p{javaLowerCase}\\p{Digit}-]*");
        TreeSet<String> caseInsensitiveMatches = new TreeSet<String>();
        TreeSet<String> caseSensitiveCamelCaseMatches = new TreeSet<String>();
        TreeSet<String> caseInsensitiveCamelCaseMatches = new TreeSet<String>();
        TreeSet<String> kebabCaseMatches = new TreeSet<String>();
        TreeSet<String> kebabCasePrefixMatches = new TreeSet<String>();
        for (String candidate : items) {
            boolean found = false;
            if (candidate.equalsIgnoreCase(pattern)) {
                caseInsensitiveMatches.add(candidate);
                found = true;
            }
            if (camelCasePattern.matcher(candidate).matches()) {
                caseSensitiveCamelCaseMatches.add(candidate);
                found = true;
            }
            if (normalisedCamelCasePattern.matcher(candidate).lookingAt()) {
                caseInsensitiveCamelCaseMatches.add(candidate);
                found = true;
            }
            if (kebabCasePattern.matcher(candidate).matches()) {
                kebabCaseMatches.add(candidate);
                found = true;
            }
            if (kebabCasePrefixPattern.matcher(candidate).matches()) {
                kebabCasePrefixMatches.add(candidate);
                found = true;
            }
            if (found || StringUtils.getLevenshteinDistance((String)normalisedPattern, (String)candidate.toUpperCase()) > Math.min(3, pattern.length() / 2)) continue;
            this.candidates.add(candidate);
        }
        if (!caseInsensitiveMatches.isEmpty()) {
            this.matches.addAll(caseInsensitiveMatches);
        } else if (!caseSensitiveCamelCaseMatches.isEmpty()) {
            this.matches.addAll(caseSensitiveCamelCaseMatches);
        } else if (kebabCaseMatches.isEmpty() && kebabCasePrefixMatches.isEmpty()) {
            this.matches.addAll(caseInsensitiveCamelCaseMatches);
        }
        if (!kebabCaseMatches.isEmpty()) {
            this.matches.addAll(kebabCaseMatches);
        } else if (!kebabCasePrefixMatches.isEmpty()) {
            this.matches.addAll(kebabCasePrefixMatches);
        }
        if (this.matches.size() == 1) {
            return this.matches.first();
        }
        return null;
    }

    private static Pattern getPatternForName(String name) {
        Pattern boundaryPattern = Pattern.compile("((^|\\p{Punct})\\p{javaLowerCase}+)|(\\p{javaUpperCase}\\p{javaLowerCase}*)");
        Matcher matcher = boundaryPattern.matcher(name);
        int pos = 0;
        StringBuilder builder = new StringBuilder();
        while (matcher.find()) {
            String prefix = name.substring(pos, matcher.start());
            if (prefix.length() > 0) {
                builder.append(Pattern.quote(prefix));
            }
            builder.append(Pattern.quote(matcher.group()));
            builder.append("[\\p{javaLowerCase}\\p{Digit}]*");
            pos = matcher.end();
        }
        builder.append(Pattern.quote(name.substring(pos)));
        return Pattern.compile(builder.toString());
    }

    private static Pattern getKebabCasePatternForName(String name) {
        Pattern boundaryPattern = Pattern.compile("((^|\\p{Punct})\\p{javaLowerCase}+)|(\\p{javaUpperCase}\\p{javaLowerCase}*)");
        Matcher matcher = boundaryPattern.matcher(name);
        int pos = 0;
        StringBuilder builder = new StringBuilder();
        while (matcher.find()) {
            String prefix = name.substring(pos, matcher.start());
            if (prefix.length() > 0) {
                builder.append(Pattern.quote(prefix));
            }
            if (pos > 0) {
                builder.append('-');
            }
            builder.append(Pattern.quote(matcher.group().toLowerCase()));
            builder.append("[\\p{javaLowerCase}\\p{Digit}]*");
            pos = matcher.end();
        }
        builder.append(Pattern.quote(name.substring(pos)));
        return Pattern.compile(builder.toString());
    }

    public Set<String> getMatches() {
        return this.matches;
    }

    public Set<String> getCandidates() {
        return this.candidates;
    }

    public String formatErrorMessage(String singularItemDescription, Object container) {
        String capItem = StringUtils.capitalize((String)singularItemDescription);
        if (!this.matches.isEmpty()) {
            return String.format("%s '%s' is ambiguous in %s. Candidates are: %s.", capItem, this.pattern, container, GUtil.toString(this.matches));
        }
        if (!this.candidates.isEmpty()) {
            return String.format("%s '%s' not found in %s. Some candidates are: %s.", capItem, this.pattern, container, GUtil.toString(this.candidates));
        }
        return String.format("%s '%s' not found in %s.", capItem, this.pattern, container);
    }

    static {
        ((DeprecationMessageBuilder.WithDocumentation)DeprecationLogger.deprecateType(NameMatcher.class).willBeRemovedInGradle9().withUpgradeGuideSection(7, "org_gradle_util_reports_deprecations")).nagUser();
    }
}

