/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.classpath.types;

import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.cache.PersistentCache;
import org.gradle.internal.Either;
import org.gradle.internal.classpath.ClasspathEntryVisitor;
import org.gradle.internal.classpath.ClasspathFileHasher;
import org.gradle.internal.classpath.ClasspathWalker;
import org.gradle.internal.classpath.DefaultCachedClasspathTransformer;
import org.gradle.internal.classpath.transforms.MrJarUtils;
import org.gradle.internal.classpath.types.InstrumentingDirectSuperTypesCollector;
import org.gradle.internal.file.FileException;
import org.gradle.internal.file.FileType;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.snapshot.FileSystemLocationSnapshot;
import org.gradle.internal.vfs.FileSystemAccess;
import org.objectweb.asm.ClassReader;

class DefaultInstrumentingDirectSuperTypesCollector
implements InstrumentingDirectSuperTypesCollector {
    private static final Logger LOGGER = Logging.getLogger(DefaultInstrumentingDirectSuperTypesCollector.class);
    private final PersistentCache cache;
    private final DefaultCachedClasspathTransformer.ParallelTransformExecutor parallelExecutor;
    private final ClasspathWalker classpathWalker;
    private final FileSystemAccess fileSystemAccess;

    public DefaultInstrumentingDirectSuperTypesCollector(PersistentCache cache, DefaultCachedClasspathTransformer.ParallelTransformExecutor parallelExecutor, ClasspathWalker classpathWalker, FileSystemAccess fileSystemAccess) {
        this.cache = cache;
        this.parallelExecutor = parallelExecutor;
        this.classpathWalker = classpathWalker;
        this.fileSystemAccess = fileSystemAccess;
    }

    @Override
    public Map<String, Set<String>> visit(List<File> files, ClasspathFileHasher fileHasher) {
        List directSuperTypes = this.parallelExecutor.transformAll(files, (source, seen) -> this.visitClassHierarchyForFile((File)source, seen, fileHasher));
        return directSuperTypes.stream().flatMap(map -> map.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, DefaultInstrumentingDirectSuperTypesCollector::concat));
    }

    private static <T> Set<T> concat(Set<T> first, Set<T> second) {
        return ImmutableSet.builder().addAll(first).addAll(second).build();
    }

    private Optional<Either<Map<String, Set<String>>, Callable<Map<String, Set<String>>>>> visitClassHierarchyForFile(File source, Set<HashCode> seen, ClasspathFileHasher fileHasher) {
        FileSystemLocationSnapshot snapshot = this.fileSystemAccess.read(source.getAbsoluteFile().getAbsolutePath());
        if (snapshot.getType() == FileType.Missing || !seen.add(snapshot.getHash())) {
            return Optional.empty();
        }
        return Optional.of(Either.right(() -> this.visitClassHierarchyForFile(source, snapshot, fileHasher)));
    }

    private Map<String, Set<String>> visitClassHierarchyForFile(File source, FileSystemLocationSnapshot sourceSnapshot, ClasspathFileHasher fileHasher) throws IOException {
        String destFileName;
        File hierachyFile;
        HashMap<String, Set<String>> directSuperTypes = new HashMap<String, Set<String>>();
        String destDirName = source.toPath().startsWith(this.cache.getBaseDir().toPath()) ? source.getParentFile().getName() : fileHasher.hashOf(sourceSnapshot).toString();
        File destDir = new File(this.cache.getBaseDir(), destDirName);
        if (!destDir.exists()) {
            destDir.mkdirs();
        }
        if ((hierachyFile = new File(destDir, (destFileName = sourceSnapshot.getType() == FileType.Directory ? source.getName() + ".jar" : source.getName()) + ".hierarchy")).isFile()) {
            return DefaultInstrumentingDirectSuperTypesCollector.readFromFile(hierachyFile);
        }
        try {
            this.classpathWalker.visit(source, (ClasspathEntryVisitor.Entry entry) -> {
                if (entry.getName().endsWith(".class") && !MrJarUtils.isInUnsupportedMrJarVersionedDirectory(entry)) {
                    ClassReader classReader = new ClassReader(entry.getContent());
                    String className = classReader.getClassName();
                    DefaultInstrumentingDirectSuperTypesCollector.registerSuperType(className, classReader.getSuperName(), directSuperTypes);
                    DefaultInstrumentingDirectSuperTypesCollector.registerInterfaces(className, classReader.getInterfaces(), directSuperTypes);
                }
            });
        }
        catch (FileException e) {
            LOGGER.debug("Malformed archive '{}'. No type hierarchy to discover.", (Object)source.getName(), (Object)e);
        }
        DefaultInstrumentingDirectSuperTypesCollector.writeToFile(directSuperTypes, hierachyFile);
        return directSuperTypes;
    }

    private static void registerSuperType(String className, @Nullable String superType, Map<String, Set<String>> directSuperTypes) {
        if (superType != null) {
            directSuperTypes.computeIfAbsent(className, k -> new HashSet()).add(superType);
        }
    }

    private static void registerInterfaces(String className, String[] interfaces, Map<String, Set<String>> directSuperTypes) {
        for (String superType : interfaces) {
            directSuperTypes.computeIfAbsent(className, k -> new HashSet()).add(superType);
        }
    }

    public static Map<String, Set<String>> readFromFile(File file) {
        HashMap<String, Set<String>> hashMap;
        block8: {
            InputStream inputStream = Files.newInputStream(file.toPath(), new OpenOption[0]);
            try {
                HashMap<String, Set<String>> directSuperTypes = new HashMap<String, Set<String>>();
                Properties properties = new Properties();
                properties.load(inputStream);
                properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> {
                    String[] values = ((String)v).split(",");
                    directSuperTypes.put((String)k, new HashSet<String>(Arrays.asList(values)));
                }));
                hashMap = directSuperTypes;
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            inputStream.close();
        }
        return hashMap;
    }

    public static void writeToFile(Map<String, Set<String>> directSuperTypes, File file) {
        try (OutputStream outputStream = Files.newOutputStream(file.toPath(), StandardOpenOption.CREATE);){
            Properties properties = new Properties();
            directSuperTypes.forEach((k, v) -> properties.setProperty((String)k, String.join((CharSequence)",", v)));
            properties.store(outputStream, null);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

