/*
 * Decompiled with CFR 0.152.
 */
package drawgram;

import drawgram.DrawgramInterface;
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.UIManager;
import util.DrawPreview;

public class DrawgramUserInterface {
    private String filedir;
    private Color phylipBG;
    private String ancNodesCBdefault = new String("Weighted");
    private JFrame frmDrawgramControls;
    private JTextField labelAngleTxt;
    private JLabel lblAngleLabels;
    private JTextField branchLenTxt;
    private JTextField depthBreadthTxt;
    private JTextField stemLenTreeDpthTxt;
    private JTextField charHgtTipSpTxt;
    private JRadioButton treeHRB;
    private JRadioButton treeVRB;
    private JRadioButton useLenY;
    private JRadioButton useLenN;
    private JRadioButton branchScaleAutoRB;
    private JLabel branchScaleTxt;
    private JLabel lblCm;
    private JComboBox cmbxTreeStyle;
    private JComboBox cmbxAncNodes;
    private JButton InputTreeBtn;
    private JTextField IntreeTxt;
    private JTextField PlotTxt;
    private JButton plotBtn;
    private JComboBox cmbxPlotFont;
    private JLabel lblFinalPlotType;
    private JComboBox cmbxFinalPlotType;
    private JButton btnPreview;
    private JButton btnQuit;
    private JButton btnPlotFile;
    private JLabel lblMarginRatios;
    private JLabel lblXMarginRatio;
    private JTextField txtXMarginRatio;
    private JLabel lblYMarginRatio;
    private JTextField txtYMarginRatio;

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    DrawgramUserInterface window = new DrawgramUserInterface();
                    window.frmDrawgramControls.setVisible(true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public DrawgramUserInterface() {
        this.initialize();
    }

    protected void TreeGrowToggle(boolean ishoriz) {
        if (ishoriz) {
            this.treeHRB.setSelected(true);
            this.treeVRB.setSelected(false);
        } else {
            this.treeHRB.setSelected(false);
            this.treeVRB.setSelected(true);
        }
    }

    protected void BranchLengthToggle(boolean uselength) {
        if (uselength) {
            this.useLenY.setSelected(true);
            this.useLenN.setSelected(false);
            this.cmbxAncNodes.setEnabled(true);
            int i = 0;
            while (i < this.cmbxAncNodes.getItemCount()) {
                if (this.cmbxAncNodes.getItemAt(i).toString().contains(this.ancNodesCBdefault)) {
                    this.cmbxAncNodes.setSelectedIndex(i);
                }
                ++i;
            }
            this.cmbxAncNodes.setForeground(Color.BLACK);
        } else {
            this.useLenY.setSelected(false);
            this.useLenN.setSelected(true);
            this.cmbxAncNodes.setEnabled(false);
            this.ancNodesCBdefault = this.cmbxAncNodes.getSelectedItem().toString();
            int i = 0;
            while (i < this.cmbxAncNodes.getItemCount()) {
                if (this.cmbxAncNodes.getItemAt(i).toString().contains("Centered")) {
                    this.cmbxAncNodes.setSelectedIndex(i);
                }
                ++i;
            }
            this.cmbxAncNodes.setForeground(Color.GRAY);
        }
    }

    protected void ScaleAutoToggle(boolean isauto) {
        if (isauto) {
            this.branchScaleAutoRB.setSelected(true);
            this.branchScaleTxt.setEnabled(false);
            this.branchLenTxt.setEnabled(false);
            this.lblCm.setEnabled(false);
        } else {
            this.branchScaleAutoRB.setSelected(false);
            this.branchScaleTxt.setEnabled(true);
            this.branchLenTxt.setEnabled(true);
            this.lblCm.setEnabled(true);
        }
    }

    protected void ChooseFile(JTextField file) {
        JFileChooser fileChooser = new JFileChooser(this.filedir);
        int option = fileChooser.showOpenDialog(this.frmDrawgramControls.getRootPane());
        if (option == 0) {
            File selectedFile = fileChooser.getSelectedFile();
            this.filedir = fileChooser.getCurrentDirectory().getAbsolutePath();
            file.setText(selectedFile.getPath());
        }
    }

    protected void LabelAngleToggle() {
        if (this.cmbxTreeStyle.getSelectedItem().toString().contains("Circular")) {
            this.lblAngleLabels.setEnabled(false);
            this.labelAngleTxt.setEnabled(false);
        } else {
            this.lblAngleLabels.setEnabled(true);
            this.labelAngleTxt.setEnabled(true);
        }
    }

    protected void SetBackgroundColor() {
        this.cmbxPlotFont.setBackground(this.phylipBG);
    }

    protected boolean LaunchDrawgramInterface(DrawgramData inputdata) {
        inputdata.intree = this.IntreeTxt.getText();
        inputdata.usefont = this.cmbxPlotFont.getSelectedItem().toString();
        inputdata.plotfile = this.PlotTxt.getText();
        inputdata.plotfileopt = "wb";
        inputdata.treegrows = this.treeHRB.isSelected() ? "horizontal" : "vertical";
        switch (this.cmbxTreeStyle.getSelectedIndex()) {
            case 0: {
                inputdata.treestyle = "phenogram";
                break;
            }
            case 1: {
                inputdata.treestyle = "cladogram";
                break;
            }
            case 2: {
                inputdata.treestyle = "curvogram";
                break;
            }
            case 3: {
                inputdata.treestyle = "eurogram";
                break;
            }
            case 4: {
                inputdata.treestyle = "swoopogram";
                break;
            }
            case 5: {
                inputdata.treestyle = "circular";
                break;
            }
            default: {
                inputdata.treestyle = "phenogram";
            }
        }
        inputdata.usebranchlengths = this.useLenY.isSelected();
        inputdata.labelangle = new Double(this.labelAngleTxt.getText());
        inputdata.scalebranchlength = this.branchScaleAutoRB.isSelected();
        inputdata.branchlength = new Double(this.branchLenTxt.getText());
        inputdata.breadthdepthratio = new Double(this.depthBreadthTxt.getText());
        inputdata.stemltreedratio = new Double(this.stemLenTreeDpthTxt.getText());
        inputdata.chhttipspratio = new Double(this.charHgtTipSpTxt.getText());
        inputdata.xmarginratio = new Double(this.txtXMarginRatio.getText());
        inputdata.ymarginratio = new Double(this.txtYMarginRatio.getText());
        switch (this.cmbxAncNodes.getSelectedIndex()) {
            case 0: {
                inputdata.ancnodes = "weighted";
                break;
            }
            case 1: {
                inputdata.ancnodes = "intermediate";
                break;
            }
            case 2: {
                inputdata.ancnodes = "centered";
                break;
            }
            case 3: {
                inputdata.ancnodes = "inner";
                break;
            }
            case 4: {
                inputdata.ancnodes = "vshaped";
                break;
            }
            default: {
                inputdata.ancnodes = "weighted";
            }
        }
        switch (this.cmbxFinalPlotType.getSelectedIndex()) {
            case 0: {
                inputdata.finalplottype = "lw";
                break;
            }
            case 1: {
                inputdata.finalplottype = "pict";
                break;
            }
            case 2: {
                inputdata.finalplottype = "pcl";
                break;
            }
            case 3: {
                inputdata.finalplottype = "bmp";
                break;
            }
            case 4: {
                inputdata.finalplottype = "fig";
                break;
            }
            case 5: {
                inputdata.finalplottype = "idraw";
                break;
            }
            case 6: {
                inputdata.finalplottype = "vrml";
                break;
            }
            case 7: {
                inputdata.finalplottype = "pcx";
                break;
            }
            case 8: {
                inputdata.finalplottype = "tek";
                break;
            }
            case 9: {
                inputdata.finalplottype = "xbm";
                break;
            }
            case 10: {
                inputdata.finalplottype = "pov";
                break;
            }
            case 11: {
                inputdata.finalplottype = "ray";
                break;
            }
            case 12: {
                inputdata.finalplottype = "hp";
                break;
            }
            case 13: {
                inputdata.finalplottype = "decregis";
                break;
            }
            case 14: {
                inputdata.finalplottype = "epson";
                break;
            }
            case 15: {
                inputdata.finalplottype = "citoh";
                break;
            }
            case 16: {
                inputdata.finalplottype = "oki";
                break;
            }
            case 17: {
                inputdata.finalplottype = "houston";
                break;
            }
            case 18: {
                inputdata.finalplottype = "other";
                break;
            }
            default: {
                inputdata.finalplottype = "lw";
            }
        }
        inputdata.librarypath = System.getProperty("user.dir");
        DrawgramInterface dg = new DrawgramInterface();
        return dg.DrawgramRun(inputdata);
    }

    private void initialize() {
        this.filedir = System.getProperty("user.dir");
        this.phylipBG = new Color(204, 255, 255);
        UIManager.put("ComboBox.disabledBackground", this.phylipBG);
        this.frmDrawgramControls = new JFrame();
        this.frmDrawgramControls.getContentPane().setBackground(this.phylipBG);
        this.frmDrawgramControls.setBackground(this.phylipBG);
        this.frmDrawgramControls.setTitle("Drawgram");
        this.frmDrawgramControls.setFont(new Font("Arial", 1, 13));
        this.frmDrawgramControls.setBounds(100, 100, 490, 500);
        this.frmDrawgramControls.setDefaultCloseOperation(3);
        this.frmDrawgramControls.getContentPane().setLayout(null);
        this.InputTreeBtn = new JButton("Input Tree");
        this.InputTreeBtn.setFont(new Font("Arial", 1, 13));
        this.InputTreeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DrawgramUserInterface.this.ChooseFile(DrawgramUserInterface.this.IntreeTxt);
            }
        });
        this.InputTreeBtn.setBounds(10, 10, 117, 28);
        this.frmDrawgramControls.getContentPane().add(this.InputTreeBtn);
        this.IntreeTxt = new JTextField();
        this.IntreeTxt.setFont(new Font("Arial", 0, 13));
        this.IntreeTxt.setText("intree");
        this.IntreeTxt.setBounds(131, 10, 333, 28);
        this.frmDrawgramControls.getContentPane().add(this.IntreeTxt);
        this.IntreeTxt.setColumns(10);
        JSeparator separator = new JSeparator();
        separator.setBounds(-10, 70, 530, 12);
        this.frmDrawgramControls.getContentPane().add(separator);
        JLabel lblTreeGrows = new JLabel("Tree grows:");
        lblTreeGrows.setFont(new Font("Arial", 1, 13));
        lblTreeGrows.setHorizontalAlignment(11);
        lblTreeGrows.setBounds(13, 116, 211, 16);
        this.frmDrawgramControls.getContentPane().add(lblTreeGrows);
        this.treeHRB = new JRadioButton("Horizontally");
        this.treeHRB.setFont(new Font("Arial", 1, 13));
        this.treeHRB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DrawgramUserInterface.this.TreeGrowToggle(true);
            }
        });
        this.treeHRB.setSelected(true);
        this.treeHRB.setBounds(228, 113, 117, 23);
        this.treeHRB.setBackground(this.phylipBG);
        this.frmDrawgramControls.getContentPane().add(this.treeHRB);
        this.treeVRB = new JRadioButton("Vertically");
        this.treeVRB.setFont(new Font("Arial", 1, 13));
        this.treeVRB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DrawgramUserInterface.this.TreeGrowToggle(false);
            }
        });
        this.treeVRB.setBounds(341, 113, 117, 23);
        this.treeVRB.setBackground(this.phylipBG);
        this.frmDrawgramControls.getContentPane().add(this.treeVRB);
        JLabel lblTreeStyle = new JLabel("Tree style:");
        lblTreeStyle.setFont(new Font("Arial", 1, 13));
        lblTreeStyle.setHorizontalAlignment(11);
        lblTreeStyle.setBounds(13, 145, 211, 16);
        this.frmDrawgramControls.getContentPane().add(lblTreeStyle);
        JLabel lblUseBranchLengths = new JLabel("Use branch lengths:");
        lblUseBranchLengths.setFont(new Font("Arial", 1, 13));
        lblUseBranchLengths.setHorizontalAlignment(11);
        lblUseBranchLengths.setBounds(13, 174, 211, 16);
        this.frmDrawgramControls.getContentPane().add(lblUseBranchLengths);
        this.useLenY = new JRadioButton("Yes");
        this.useLenY.setFont(new Font("Arial", 1, 13));
        this.useLenY.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DrawgramUserInterface.this.BranchLengthToggle(true);
            }
        });
        this.useLenY.setSelected(true);
        this.useLenY.setBounds(228, 171, 61, 23);
        this.useLenY.setBackground(this.phylipBG);
        this.frmDrawgramControls.getContentPane().add(this.useLenY);
        this.useLenN = new JRadioButton("No");
        this.useLenN.setFont(new Font("Arial", 1, 13));
        this.useLenN.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DrawgramUserInterface.this.BranchLengthToggle(false);
            }
        });
        this.useLenN.setBounds(285, 171, 54, 23);
        this.useLenN.setBackground(this.phylipBG);
        this.frmDrawgramControls.getContentPane().add(this.useLenN);
        this.lblAngleLabels = new JLabel("Angle of labels:");
        this.lblAngleLabels.setFont(new Font("Arial", 1, 13));
        this.lblAngleLabels.setHorizontalAlignment(11);
        this.lblAngleLabels.setBounds(13, 203, 211, 16);
        this.frmDrawgramControls.getContentPane().add(this.lblAngleLabels);
        this.labelAngleTxt = new JTextField();
        this.labelAngleTxt.setFont(new Font("Arial", 0, 13));
        this.labelAngleTxt.setText("90.0");
        this.labelAngleTxt.setBounds(228, 198, 47, 27);
        this.frmDrawgramControls.getContentPane().add(this.labelAngleTxt);
        this.labelAngleTxt.setColumns(10);
        JLabel lblBranchLenScaling = new JLabel("Branch length scaling:");
        lblBranchLenScaling.setFont(new Font("Arial", 1, 13));
        lblBranchLenScaling.setHorizontalAlignment(11);
        lblBranchLenScaling.setBounds(13, 232, 211, 16);
        this.frmDrawgramControls.getContentPane().add(lblBranchLenScaling);
        this.branchScaleAutoRB = new JRadioButton("Automatic");
        this.branchScaleAutoRB.setFont(new Font("Arial", 1, 13));
        this.branchScaleAutoRB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DrawgramUserInterface.this.ScaleAutoToggle(DrawgramUserInterface.this.branchScaleAutoRB.isSelected());
            }
        });
        this.branchScaleAutoRB.setSelected(true);
        this.branchScaleAutoRB.setBounds(228, 229, 109, 23);
        this.branchScaleAutoRB.setBackground(this.phylipBG);
        this.frmDrawgramControls.getContentPane().add(this.branchScaleAutoRB);
        this.branchScaleTxt = new JLabel("Scale");
        this.branchScaleTxt.setFont(new Font("Arial", 1, 13));
        this.branchScaleTxt.setEnabled(false);
        this.branchScaleTxt.setBounds(341, 232, 47, 16);
        this.frmDrawgramControls.getContentPane().add(this.branchScaleTxt);
        this.branchLenTxt = new JTextField();
        this.branchLenTxt.setEnabled(false);
        this.branchLenTxt.setText("1.0");
        this.branchLenTxt.setFont(new Font("Arial", 0, 13));
        this.branchLenTxt.setBounds(387, 226, 54, 28);
        this.frmDrawgramControls.getContentPane().add(this.branchLenTxt);
        this.branchLenTxt.setColumns(10);
        this.lblCm = new JLabel("cm");
        this.lblCm.setFont(new Font("Arial", 1, 13));
        this.lblCm.setEnabled(false);
        this.lblCm.setBounds(441, 232, 26, 16);
        this.frmDrawgramControls.getContentPane().add(this.lblCm);
        JLabel lblDepthBreadthOfTree = new JLabel("Depth/breadth of tree:");
        lblDepthBreadthOfTree.setFont(new Font("Arial", 1, 13));
        lblDepthBreadthOfTree.setHorizontalAlignment(11);
        lblDepthBreadthOfTree.setBounds(13, 261, 211, 16);
        this.frmDrawgramControls.getContentPane().add(lblDepthBreadthOfTree);
        this.depthBreadthTxt = new JTextField();
        this.depthBreadthTxt.setFont(new Font("Arial", 0, 13));
        this.depthBreadthTxt.setText("0.53");
        this.depthBreadthTxt.setBounds(228, 256, 54, 27);
        this.frmDrawgramControls.getContentPane().add(this.depthBreadthTxt);
        this.depthBreadthTxt.setColumns(10);
        JLabel lblStemLengthTreeDepth = new JLabel("Stem length/tree depth:");
        lblStemLengthTreeDepth.setFont(new Font("Arial", 1, 13));
        lblStemLengthTreeDepth.setHorizontalAlignment(11);
        lblStemLengthTreeDepth.setBounds(13, 290, 211, 16);
        this.frmDrawgramControls.getContentPane().add(lblStemLengthTreeDepth);
        this.stemLenTreeDpthTxt = new JTextField();
        this.stemLenTreeDpthTxt.setFont(new Font("Arial", 0, 13));
        this.stemLenTreeDpthTxt.setText("0.05");
        this.stemLenTreeDpthTxt.setBounds(228, 285, 54, 27);
        this.frmDrawgramControls.getContentPane().add(this.stemLenTreeDpthTxt);
        this.stemLenTreeDpthTxt.setColumns(10);
        JLabel lblCharHgtTipSpace = new JLabel("Character height/tip space:");
        lblCharHgtTipSpace.setFont(new Font("Arial", 1, 13));
        lblCharHgtTipSpace.setHorizontalAlignment(11);
        lblCharHgtTipSpace.setBounds(13, 319, 211, 16);
        this.frmDrawgramControls.getContentPane().add(lblCharHgtTipSpace);
        this.charHgtTipSpTxt = new JTextField();
        this.charHgtTipSpTxt.setFont(new Font("Arial", 0, 13));
        this.charHgtTipSpTxt.setText("0.333");
        this.charHgtTipSpTxt.setBounds(228, 314, 69, 27);
        this.frmDrawgramControls.getContentPane().add(this.charHgtTipSpTxt);
        this.charHgtTipSpTxt.setColumns(10);
        JLabel lblAncestralNodes = new JLabel("Ancestral nodes:");
        lblAncestralNodes.setFont(new Font("Arial", 1, 13));
        lblAncestralNodes.setHorizontalAlignment(11);
        lblAncestralNodes.setBounds(13, 348, 211, 16);
        this.frmDrawgramControls.getContentPane().add(lblAncestralNodes);
        this.cmbxTreeStyle = new JComboBox();
        this.cmbxTreeStyle.setFont(new Font("Arial", 0, 13));
        this.cmbxTreeStyle.setModel(new DefaultComboBoxModel<String>(new String[]{"Phenogram", "Cladogram", "Curvogram", "Eurogram", "Swoopogram", "Circular tree"}));
        this.cmbxTreeStyle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DrawgramUserInterface.this.LabelAngleToggle();
            }
        });
        this.cmbxTreeStyle.setRenderer(new DefaultListCellRenderer(){

            @Override
            public void paint(Graphics g) {
                this.setBackground(Color.WHITE);
                this.setForeground(Color.BLACK);
                super.paint(g);
            }
        });
        this.cmbxTreeStyle.setBounds(228, 139, 193, 28);
        this.frmDrawgramControls.getContentPane().add(this.cmbxTreeStyle);
        this.cmbxAncNodes = new JComboBox();
        this.cmbxAncNodes.setFont(new Font("Arial", 0, 13));
        this.cmbxAncNodes.setModel(new DefaultComboBoxModel<String>(new String[]{"Weighted", "Intermediate", "Centered", "Innermost", "V-shaped"}));
        this.cmbxAncNodes.setRenderer(new DefaultListCellRenderer(){

            @Override
            public void paint(Graphics g) {
                this.setBackground(Color.WHITE);
                this.setForeground(Color.BLACK);
                super.paint(g);
            }
        });
        this.cmbxAncNodes.setBounds(228, 342, 193, 28);
        this.frmDrawgramControls.getContentPane().add(this.cmbxAncNodes);
        this.branchScaleAutoRB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DrawgramUserInterface.this.ScaleAutoToggle(DrawgramUserInterface.this.branchScaleAutoRB.isSelected());
            }
        });
        this.btnPreview = new JButton("Preview");
        this.btnPreview.setFont(new Font("Arial", 1, 13));
        this.btnPreview.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DrawgramData inputdata = new DrawgramData();
                inputdata.doplot = false;
                boolean retval = DrawgramUserInterface.this.LaunchDrawgramInterface(inputdata);
                if (retval) {
                    String title = "Preview: " + DrawgramUserInterface.this.PlotTxt.getText();
                    String curDir = System.getProperty("user.dir");
                    curDir = String.valueOf(curDir) + "/JavaPreview.ps";
                    new DrawPreview(title, curDir);
                }
            }
        });
        this.btnPreview.setBounds(25, 435, 117, 29);
        this.frmDrawgramControls.getContentPane().add(this.btnPreview);
        this.btnQuit = new JButton("Quit");
        this.btnQuit.setFont(new Font("Arial", 1, 13));
        this.btnQuit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.exit(0);
            }
        });
        this.btnQuit.setBounds(342, 435, 117, 29);
        this.frmDrawgramControls.getContentPane().add(this.btnQuit);
        JLabel lblBranchLen = new JLabel(" (if present)");
        lblBranchLen.setFont(new Font("Arial", 1, 13));
        lblBranchLen.setBounds(345, 174, 89, 16);
        this.frmDrawgramControls.getContentPane().add(lblBranchLen);
        this.plotBtn = new JButton("Plot File");
        this.plotBtn.setFont(new Font("Arial", 1, 13));
        this.plotBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                DrawgramUserInterface.this.ChooseFile(DrawgramUserInterface.this.PlotTxt);
            }
        });
        this.plotBtn.setBounds(10, 39, 117, 28);
        this.frmDrawgramControls.getContentPane().add(this.plotBtn);
        this.PlotTxt = new JTextField();
        this.PlotTxt.setFont(new Font("Arial", 0, 13));
        this.PlotTxt.setText("plotfile.ps");
        this.PlotTxt.setBounds(131, 39, 333, 28);
        this.frmDrawgramControls.getContentPane().add(this.PlotTxt);
        this.PlotTxt.setColumns(10);
        this.btnPlotFile = new JButton("Create Plot File");
        this.btnPlotFile.setFont(new Font("Arial", 1, 13));
        this.btnPlotFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DrawgramData inputdata = new DrawgramData();
                inputdata.doplot = true;
                boolean retval = DrawgramUserInterface.this.LaunchDrawgramInterface(inputdata);
            }
        });
        this.btnPlotFile.setBounds(164, 435, 156, 29);
        this.frmDrawgramControls.getContentPane().add(this.btnPlotFile);
        JLabel lblPSFont = new JLabel("PostScript Font:");
        lblPSFont.setFont(new Font("Arial", 1, 13));
        lblPSFont.setHorizontalAlignment(4);
        lblPSFont.setBounds(13, 87, 211, 16);
        this.frmDrawgramControls.getContentPane().add(lblPSFont);
        this.cmbxPlotFont = new JComboBox();
        this.cmbxPlotFont.setFont(new Font("Arial", 0, 13));
        this.cmbxPlotFont.setModel(new DefaultComboBoxModel<String>(new String[]{"Times-Roman", "Times-Bold", "Helvetica", "Helvetica-Bold", "Courier", "Courier-Bold", "AvantGarde-Book", "AvantGarde-BookOblique", "AvantGarde-Demi", "AvantGarde-DemiOblique", "Bookman-Light", "Bookman-LightItalic", "Bookman-Demi", "Bookman-DemiItalic", "Courier-Oblique", "Courier-BoldOblique", "Helvetica-Oblique", "Helvetica-BoldOblique", "Helvetica-Narrow", "Helvetica-Narrow-Oblique", "Helvetica-Narrow-Bold", "Helvetica-Narrow-BoldOblique", "NewCenturySchlbk-Roman", "NewCenturySchlbk-Italic", "NewCenturySchlbk-Bold", "NewCenturySchlbk-BoldItalic", "Palatino-Roman", "Palatino-Italic", "Palatino-Bold", "Palatino-BoldItalic", "Times-BoldItalic", "Times-Italic", "ZapfChancery-MediumItalic"}));
        this.cmbxPlotFont.setBounds(228, 81, 228, 28);
        this.cmbxPlotFont.setRenderer(new DefaultListCellRenderer(){

            @Override
            public void paint(Graphics g) {
                this.setBackground(Color.WHITE);
                this.setForeground(Color.BLACK);
                super.paint(g);
            }
        });
        this.frmDrawgramControls.getContentPane().add(this.cmbxPlotFont);
        this.lblFinalPlotType = new JLabel("Final plot file type:");
        this.lblFinalPlotType.setHorizontalAlignment(11);
        this.lblFinalPlotType.setFont(new Font("Arial", 1, 13));
        this.lblFinalPlotType.setBounds(13, 377, 211, 16);
        this.frmDrawgramControls.getContentPane().add(this.lblFinalPlotType);
        this.cmbxFinalPlotType = new JComboBox();
        this.cmbxFinalPlotType.setModel(new DefaultComboBoxModel<String>(new String[]{"Postscript", "PICT", "PCL", "Windows BMP", "FIG 2.0", "Idraw", "VRML", "PCX", "Tek4010", "X Bitmap", "POVRAY 3D", "Rayshade 3D", "HPGL", "DEC ReGIS", "Epson MX-80", "Prowriter/Imagewriter", "Okidata dot-matrix", "Houston Instruments plotter", "other"}));
        this.cmbxFinalPlotType.setSelectedIndex(0);
        this.cmbxFinalPlotType.setFont(new Font("Arial", 0, 13));
        this.cmbxFinalPlotType.setBounds(228, 371, 193, 28);
        this.cmbxFinalPlotType.setRenderer(new DefaultListCellRenderer(){

            @Override
            public void paint(Graphics g) {
                this.setBackground(Color.WHITE);
                this.setForeground(Color.BLACK);
                super.paint(g);
            }
        });
        this.frmDrawgramControls.getContentPane().add(this.cmbxFinalPlotType);
        this.lblMarginRatios = new JLabel("Page margin ratios:");
        this.lblMarginRatios.setHorizontalAlignment(4);
        this.lblMarginRatios.setFont(new Font("Arial", 1, 13));
        this.lblMarginRatios.setBounds(78, 409, 146, 16);
        this.frmDrawgramControls.getContentPane().add(this.lblMarginRatios);
        this.lblXMarginRatio = new JLabel("X:");
        this.lblXMarginRatio.setHorizontalAlignment(4);
        this.lblXMarginRatio.setFont(new Font("Arial", 1, 13));
        this.lblXMarginRatio.setBounds(228, 408, 26, 16);
        this.frmDrawgramControls.getContentPane().add(this.lblXMarginRatio);
        this.txtXMarginRatio = new JTextField();
        this.txtXMarginRatio.setText("0.08");
        this.txtXMarginRatio.setBounds(254, 402, 69, 28);
        this.frmDrawgramControls.getContentPane().add(this.txtXMarginRatio);
        this.txtXMarginRatio.setColumns(10);
        this.lblYMarginRatio = new JLabel("Y:");
        this.lblYMarginRatio.setHorizontalAlignment(4);
        this.lblYMarginRatio.setFont(new Font("Arial", 1, 13));
        this.lblYMarginRatio.setBounds(326, 408, 26, 16);
        this.frmDrawgramControls.getContentPane().add(this.lblYMarginRatio);
        this.txtYMarginRatio = new JTextField();
        this.txtYMarginRatio.setText("0.08");
        this.txtYMarginRatio.setColumns(10);
        this.txtYMarginRatio.setBounds(352, 402, 69, 28);
        this.frmDrawgramControls.getContentPane().add(this.txtYMarginRatio);
    }

    public class DrawgramData {
        String intree;
        String usefont;
        String plotfile;
        String plotfileopt;
        String treegrows;
        String treestyle;
        boolean usebranchlengths;
        Double labelangle;
        boolean scalebranchlength;
        Double branchlength;
        Double breadthdepthratio;
        Double stemltreedratio;
        Double chhttipspratio;
        Double xmarginratio;
        Double ymarginratio;
        String ancnodes;
        String librarypath;
        boolean doplot;
        String finalplottype;
    }

    public static enum LastPage {
        COUNT,
        SIZE,
        OVERLAP;

    }
}

