/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.classworlds;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.plexus.classworlds.ClassWorldListener;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.classworlds.realm.DuplicateRealmException;
import org.codehaus.plexus.classworlds.realm.NoSuchRealmException;

public class ClassWorld {
    private Map<String, ClassRealm> realms;
    private final List<ClassWorldListener> listeners = new ArrayList<ClassWorldListener>();

    public ClassWorld(String realmId, ClassLoader classLoader) {
        this();
        try {
            this.newRealm(realmId, classLoader);
        }
        catch (DuplicateRealmException duplicateRealmException) {
            // empty catch block
        }
    }

    public ClassWorld() {
        this.realms = new LinkedHashMap<String, ClassRealm>();
    }

    public ClassRealm newRealm(String id) throws DuplicateRealmException {
        return this.newRealm(id, this.getClass().getClassLoader());
    }

    public synchronized ClassRealm newRealm(String id, ClassLoader classLoader) throws DuplicateRealmException {
        if (this.realms.containsKey(id)) {
            throw new DuplicateRealmException(this, id);
        }
        ClassRealm realm2 = new ClassRealm(this, id, classLoader);
        this.realms.put(id, realm2);
        for (ClassWorldListener listener : this.listeners) {
            listener.realmCreated(realm2);
        }
        return realm2;
    }

    public synchronized void disposeRealm(String id) throws NoSuchRealmException {
        ClassRealm realm2 = this.realms.remove(id);
        if (realm2 != null) {
            this.closeIfJava7(realm2);
            for (ClassWorldListener listener : this.listeners) {
                listener.realmDisposed(realm2);
            }
        }
    }

    private void closeIfJava7(ClassRealm realm2) {
        try {
            if (realm2 instanceof Closeable) {
                realm2.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public synchronized ClassRealm getRealm(String id) throws NoSuchRealmException {
        if (this.realms.containsKey(id)) {
            return this.realms.get(id);
        }
        throw new NoSuchRealmException(this, id);
    }

    public synchronized Collection<ClassRealm> getRealms() {
        return Collections.unmodifiableList(new ArrayList<ClassRealm>(this.realms.values()));
    }

    public synchronized ClassRealm getClassRealm(String id) {
        if (this.realms.containsKey(id)) {
            return this.realms.get(id);
        }
        return null;
    }

    public synchronized void addListener(ClassWorldListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public synchronized void removeListener(ClassWorldListener listener) {
        this.listeners.remove(listener);
    }
}

