/*
 * Decompiled with CFR 0.152.
 */
package mill.testrunner;

import geny.Generator;
import geny.Generator$;
import geny.Writable;
import geny.Writable$;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import mill.api.AggWrapper;
import mill.api.Ctx;
import mill.api.Loose$;
import mill.api.TestReporter;
import mill.testrunner.TestResult;
import os.Path;
import os.PathChunk;
import os.PathChunk$;
import os.Source$;
import os.exists$;
import os.isDir$;
import os.list$;
import os.move$;
import os.walk$stream$;
import os.write$append$;
import os.write$over$;
import sbt.testing.AnnotatedFingerprint;
import sbt.testing.Event;
import sbt.testing.EventHandler;
import sbt.testing.Fingerprint;
import sbt.testing.Framework;
import sbt.testing.Logger;
import sbt.testing.NestedSuiteSelector;
import sbt.testing.NestedTestSelector;
import sbt.testing.Runner;
import sbt.testing.Selector;
import sbt.testing.Status;
import sbt.testing.SubclassFingerprint;
import sbt.testing.SuiteSelector;
import sbt.testing.Task;
import sbt.testing.TaskDef;
import sbt.testing.TestSelector;
import sbt.testing.TestWildcardSelector;
import scala.$less$colon$less$;
import scala.Array;
import scala.Array$;
import scala.Array$UnapplySeqWrapper$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$mcJJ$sp;
import scala.Tuple2$mcZZ$sp;
import scala.collection.ArrayOps$;
import scala.collection.IterableFactory$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArraySeq;
import scala.collection.mutable.Queue;
import scala.collection.mutable.Queue$;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering$;
import scala.math.Ordering$String$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0$mcV$sp;
import scala.util.Try$;
import upickle.default$;

public final class TestRunnerUtils$ {
    public static final TestRunnerUtils$ MODULE$ = new TestRunnerUtils$();

    public Generator<String> listClassFiles(Path base) {
        if (isDir$.MODULE$.apply(base)) {
            return walk$stream$.MODULE$.apply(base, walk$stream$.MODULE$.apply$default$2(), walk$stream$.MODULE$.apply$default$3(), walk$stream$.MODULE$.apply$default$4(), walk$stream$.MODULE$.apply$default$5(), walk$stream$.MODULE$.apply$default$6()).filter((Function1<Path, Object> & Serializable)x$1 -> BoxesRunTime.boxToBoolean(TestRunnerUtils$.$anonfun$listClassFiles$1(x$1))).map((Function1<Path, String> & Serializable)x$2 -> x$2.relativeTo(base).toString());
        }
        ZipInputStream zip2 = new ZipInputStream(Files.newInputStream(base.toNIO(), new OpenOption[0]));
        return Generator$.MODULE$.selfClosing((Function0<Tuple2> & Serializable)() -> new Tuple2(package$.MODULE$.Iterator().continually((Function0<ZipEntry> & Serializable)() -> zip2.getNextEntry()).takeWhile((Function1<ZipEntry, Object> & Serializable)x$3 -> BoxesRunTime.boxToBoolean(TestRunnerUtils$.$anonfun$listClassFiles$5(x$3))).map((Function1<ZipEntry, String> & Serializable)x$4 -> x$4.getName()).filter((Function1<String, Object> & Serializable)x$5 -> BoxesRunTime.boxToBoolean(x$5.endsWith(".class"))), () -> zip2.close()));
    }

    public AggWrapper.Agg<Tuple2<Class<?>, Fingerprint>> discoverTests(ClassLoader cl, Framework framework, AggWrapper.Agg<Path> classpath2) {
        Fingerprint[] fingerprints = framework.fingerprints();
        AggWrapper.Agg testClasses = (AggWrapper.Agg)((IterableOps)((IterableOps)classpath2.filter((Function1<Path, Object> & Serializable)x$6 -> BoxesRunTime.boxToBoolean(exists$.MODULE$.apply(x$6)))).flatMap((Function1<Path, AggWrapper.Agg> & Serializable)base -> Loose$.MODULE$.Agg().from((IterableOnce)MODULE$.listClassFiles((Path)base).map((Function1<String, Option> & Serializable)path -> {
            Class<?> cls = cl.loadClass(StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString((String)path), ".class").replace('/', '.'));
            int publicConstructorCount = ArrayOps$.MODULE$.count$extension(Predef$.MODULE$.refArrayOps(cls.getConstructors()), (Function1<Constructor, Object> & Serializable)c -> BoxesRunTime.boxToBoolean(TestRunnerUtils$.$anonfun$discoverTests$4(c)));
            String string = framework.name();
            String string2 = "Jupiter";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                return new Some(new Tuple2(cls, ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps(fingerprints))));
            }
            if (Modifier.isAbstract(cls.getModifiers()) || cls.isInterface() || publicConstructorCount > 1) {
                return None$.MODULE$;
            }
            Tuple2$mcZZ$sp tuple2$mcZZ$sp = new Tuple2$mcZZ$sp(cls.getName().endsWith("$"), publicConstructorCount == 0);
            if (tuple2$mcZZ$sp != null) {
                boolean bl = ((Tuple2)tuple2$mcZZ$sp)._1$mcZ$sp();
                boolean bl2 = ((Tuple2)tuple2$mcZZ$sp)._2$mcZ$sp();
                if (bl && bl2) {
                    return MODULE$.matchFingerprints(cl, cls, fingerprints, true);
                }
            }
            if (tuple2$mcZZ$sp != null) {
                boolean bl = ((Tuple2)tuple2$mcZZ$sp)._1$mcZ$sp();
                boolean bl3 = ((Tuple2)tuple2$mcZZ$sp)._2$mcZ$sp();
                if (!bl && !bl3) {
                    return MODULE$.matchFingerprints(cl, cls, fingerprints, false);
                }
            }
            return None$.MODULE$;
        }).toSeq().flatten(Predef$.MODULE$.$conforms())))).filter((Function1<Tuple2, Object> & Serializable)x0$1 -> BoxesRunTime.boxToBoolean(TestRunnerUtils$.$anonfun$discoverTests$5(x0$1)));
        return testClasses;
    }

    public Option<Tuple2<Class<?>, Fingerprint>> matchFingerprints(ClassLoader cl, Class<?> cls, Fingerprint[] fingerprints, boolean isModule) {
        return ArrayOps$.MODULE$.find$extension(Predef$.MODULE$.refArrayOps(fingerprints), (Function1<Fingerprint, Object> & Serializable)x0$1 -> BoxesRunTime.boxToBoolean(TestRunnerUtils$.$anonfun$matchFingerprints$1(isModule, cl, cls, x0$1))).map((Function1<Fingerprint, Tuple2> & Serializable)f -> new Tuple2<Class, Fingerprint>(cls, (Fingerprint)f));
    }

    public Tuple2<Runner, Task[][]> getTestTasks(Framework framework, Seq<String> args, Function1<Class<?>, Object> classFilter, ClassLoader cl, AggWrapper.Agg<Path> testClassfilePath) {
        Runner runner = framework.runner((String[])args.toArray(ClassTag$.MODULE$.apply(String.class)), (String[])Array$.MODULE$.apply(Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class)), cl);
        AggWrapper.Agg<Tuple2<Class<?>, Fingerprint>> testClasses = this.discoverTests(cl, framework, testClassfilePath);
        Task[] tasks = runner.tasks((TaskDef[])ArrayOps$.MODULE$.withFilter$extension(Predef$.MODULE$.refArrayOps((Object[])testClasses.iterator().toArray(ClassTag$.MODULE$.apply(Tuple2.class))), (Function1<Tuple2, Object> & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean(TestRunnerUtils$.$anonfun$getTestTasks$1(check$ifrefutable$1))).withFilter((Function1<Tuple2, Object> & Serializable)x$8 -> BoxesRunTime.boxToBoolean(TestRunnerUtils$.$anonfun$getTestTasks$2(classFilter, x$8))).map((Function1<Tuple2, TaskDef> & Serializable)x$9 -> {
            Tuple2 tuple2 = x$9;
            if (tuple2 != null) {
                Class cls = (Class)tuple2._1();
                Fingerprint fingerprint = (Fingerprint)tuple2._2();
                return new TaskDef(StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(cls.getName()), "$"), fingerprint, false, (Selector[])((Object[])new Selector[]{new SuiteSelector()}));
            }
            throw new MatchError(tuple2);
        }, ClassTag$.MODULE$.apply(TaskDef.class)));
        Task[][] groupedTasks = (Task[][])ArrayOps$.MODULE$.sortBy$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.groupBy$extension(Predef$.MODULE$.refArrayOps(tasks), (Function1<Task, Option> & Serializable)t -> TestRunnerUtils$.nameOpt$1(t)).values().toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Task.class)))), (Function1<Task[], Option> & Serializable)x$11 -> ArrayOps$.MODULE$.headOption$extension(Predef$.MODULE$.refArrayOps((Object[])x$11)).map((Function1<Task, Option> & Serializable)t -> TestRunnerUtils$.nameOpt$1(t)), Ordering$.MODULE$.Option(Ordering$.MODULE$.Option(Ordering$String$.MODULE$)));
        return new Tuple2<Runner, Task[][]>(runner, groupedTasks);
    }

    private boolean executeTasks(Seq<Task> tasks, TestReporter testReporter, ConcurrentLinkedQueue<Event> events, Ctx.Log ctx) {
        AtomicBoolean taskStatus = new AtomicBoolean(true);
        Queue taskQueue = tasks.to(IterableFactory$.MODULE$.toFactory(Queue$.MODULE$));
        while (taskQueue.nonEmpty()) {
            Task[] next = ((Task)taskQueue.dequeue()).execute(new EventHandler(testReporter, events, taskStatus){
                private final TestReporter testReporter$1;
                private final ConcurrentLinkedQueue events$1;
                private final AtomicBoolean taskStatus$1;

                public void handle(Event event) {
                    this.testReporter$1.logStart(event);
                    this.events$1.add(event);
                    Status status = event.status();
                    if (((Object)((Object)Status.Error)).equals((Object)((Object)status))) {
                        this.taskStatus$1.set(false);
                    } else if (((Object)((Object)Status.Failure)).equals((Object)((Object)status))) {
                        this.taskStatus$1.set(false);
                    }
                    this.testReporter$1.logFinish(event);
                }
                {
                    this.testReporter$1 = testReporter$1;
                    this.events$1 = events$1;
                    this.taskStatus$1 = taskStatus$1;
                }
            }, (Logger[])((Object[])new Logger[]{new Logger(ctx){
                private final Ctx.Log ctx$1;

                public void debug(String msg) {
                    this.ctx$1.log().outputStream().println(msg);
                }

                public void error(String msg) {
                    this.ctx$1.log().outputStream().println(msg);
                }

                public boolean ansiCodesSupported() {
                    return true;
                }

                public void warn(String msg) {
                    this.ctx$1.log().outputStream().println(msg);
                }

                public void trace(Throwable t) {
                    t.printStackTrace(this.ctx$1.log().outputStream());
                }

                public void info(String msg) {
                    this.ctx$1.log().outputStream().println(msg);
                }
                {
                    this.ctx$1 = ctx$1;
                }
            }}));
            taskQueue.enqueueAll(Predef$.MODULE$.wrapRefArray((Object[])next));
        }
        return taskStatus.get();
    }

    public Iterator<TestResult> parseRunTaskResults(Iterator<Event> events) {
        return events.map((Function1<Event, TestResult> & Serializable)e -> {
            String string;
            Option ex = e.throwable().isDefined() ? new Some<Throwable>(e.throwable().get()) : None$.MODULE$;
            String string2 = e.fullyQualifiedName();
            Selector selector = e.selector();
            if (selector instanceof NestedSuiteSelector) {
                NestedSuiteSelector nestedSuiteSelector = (NestedSuiteSelector)selector;
                string = nestedSuiteSelector.suiteId();
            } else if (selector instanceof NestedTestSelector) {
                NestedTestSelector nestedTestSelector = (NestedTestSelector)selector;
                string = new StringBuilder(1).append(nestedTestSelector.suiteId()).append(".").append(nestedTestSelector.testName()).toString();
            } else if (selector instanceof SuiteSelector) {
                SuiteSelector suiteSelector = (SuiteSelector)selector;
                string = suiteSelector.toString();
            } else if (selector instanceof TestSelector) {
                TestSelector testSelector = (TestSelector)selector;
                string = testSelector.testName();
            } else if (selector instanceof TestWildcardSelector) {
                TestWildcardSelector testWildcardSelector = (TestWildcardSelector)selector;
                string = testWildcardSelector.testWildcard();
            } else {
                throw new MatchError(selector);
            }
            return new TestResult(string2, string, e.duration(), e.status().toString(), ex.map((Function1<Throwable, String> & Serializable)x$12 -> x$12.getClass().getName()), ex.map((Function1<Throwable, String> & Serializable)x$13 -> x$13.getMessage()), ex.map((Function1<Throwable, IndexedSeq> & Serializable)x$14 -> ArrayOps$.MODULE$.toIndexedSeq$extension(Predef$.MODULE$.refArrayOps(x$14.getStackTrace()))));
        });
    }

    private Tuple2<String, Iterator<TestResult>> handleRunnerDone(Runner runner, ConcurrentLinkedQueue<Event> events) {
        String doneMessage = runner.done();
        if (doneMessage != null && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(doneMessage))) {
            if (doneMessage.endsWith("\n")) {
                Predef$.MODULE$.println(StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(doneMessage), "\n"));
            } else {
                Predef$.MODULE$.println(doneMessage);
            }
        }
        Iterator<TestResult> results = this.parseRunTaskResults(CollectionConverters$.MODULE$.IteratorHasAsScala(events.iterator()).asScala());
        return new Tuple2<String, Iterator<TestResult>>(doneMessage, results);
    }

    public Tuple2<String, Iterator<TestResult>> runTasks(Seq<Seq<Task>> tasksSeq, TestReporter testReporter, Runner runner, Option<Path> resultPathOpt, Ctx.Log ctx) {
        JFunction0$mcV$sp jFunction0$mcV$sp;
        ConcurrentLinkedQueue<Event> events = new ConcurrentLinkedQueue<Event>();
        LongRef successCounter = LongRef.create(0L);
        LongRef failureCounter = LongRef.create(0L);
        Option<Path> option = resultPathOpt;
        if (option instanceof Some) {
            Some some = (Some)option;
            Path resultPath = (Path)some.value();
            jFunction0$mcV$sp = () -> write$over$.MODULE$.apply(resultPath, Source$.MODULE$.WritableSource(default$.MODULE$.write(new Tuple2$mcJJ$sp(successCounter$1.elem, failureCounter$1.elem), default$.MODULE$.write$default$2(), default$.MODULE$.write$default$3(), default$.MODULE$.write$default$4(), default$.MODULE$.Tuple2Writer(default$.MODULE$.LongWriter(), default$.MODULE$.LongWriter())), (Function1<String, Writable.StringWritable> & Serializable)s -> Writable$.MODULE$.StringWritable((String)s)), write$over$.MODULE$.apply$default$3(), write$over$.MODULE$.apply$default$4(), write$over$.MODULE$.apply$default$5(), write$over$.MODULE$.apply$default$6());
        } else if (None$.MODULE$.equals(option)) {
            jFunction0$mcV$sp = () -> ctx.log().outputStream().println(new StringBuilder(23).append("Test result: ").append(successCounter$1.elem + failureCounter$1.elem).append(" completed").append((Object)(failureCounter$1.elem > 0L ? new StringBuilder(12).append(", ").append(failureCounter$1.elem).append(" failures.").toString() : ".")).toString());
        } else {
            throw new MatchError(option);
        }
        JFunction0$mcV$sp resultLog = jFunction0$mcV$sp;
        tasksSeq.foreach((Function1<Seq, Object> & Serializable)tasks -> {
            TestRunnerUtils$.$anonfun$runTasks$4(testReporter, events, ctx, successCounter, failureCounter, resultLog, tasks);
            return BoxedUnit.UNIT;
        });
        return this.handleRunnerDone(runner, events);
    }

    public Tuple2<String, Seq<TestResult>> runTestFramework0(Function1<ClassLoader, Framework> frameworkInstances, AggWrapper.Agg<Path> testClassfilePath, Seq<String> args, Function1<Class<?>, Object> classFilter, ClassLoader cl, TestReporter testReporter, Option<Path> resultPathOpt, Ctx.Log ctx) {
        Framework framework = frameworkInstances.apply(cl);
        Tuple2<Runner, Task[][]> tuple2 = this.getTestTasks(framework, args, classFilter, cl, testClassfilePath);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Runner runner = tuple2._1();
        Task[][] tasksArr = tuple2._2();
        Tuple2<Runner, Task[][]> tuple22 = new Tuple2<Runner, Task[][]>(runner, tasksArr);
        Runner runner2 = tuple22._1();
        Task[][] tasksArr2 = tuple22._2();
        Tuple2<String, Iterator<TestResult>> tuple23 = this.runTasks(ArrayOps$.MODULE$.view$extension(Predef$.MODULE$.refArrayOps((Object[])tasksArr2)).map((Function1<Task[], Seq> & Serializable)x$16 -> ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])x$16))).toSeq(), testReporter, runner2, resultPathOpt, ctx);
        if (tuple23 == null) {
            throw new MatchError(tuple23);
        }
        String doneMessage = tuple23._1();
        Iterator<TestResult> results = tuple23._2();
        Tuple2<String, Iterator<TestResult>> tuple24 = new Tuple2<String, Iterator<TestResult>>(doneMessage, results);
        String doneMessage2 = tuple24._1();
        Iterator<TestResult> results2 = tuple24._2();
        return new Tuple2<String, Seq<TestResult>>(doneMessage2, results2.toSeq());
    }

    public Option<Path> runTestFramework0$default$7() {
        return None$.MODULE$;
    }

    public Tuple2<String, Iterator<TestResult>> runTasksFromQueue(Option<String> startingTestClass, AggWrapper.Agg<Tuple2<Class<?>, Fingerprint>> testClasses, TestReporter testReporter, Runner runner, Path claimFolder, Path testClassQueueFolder, Path resultPath, Ctx.Log ctx) {
        ConcurrentLinkedQueue<Event> events = new ConcurrentLinkedQueue<Event>();
        Map globSelectorCache = ((IterableOnceOps)testClasses.view().map((Function1<Tuple2, Tuple2> & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Class cls = (Class)tuple2._1();
                Fingerprint fingerprint = (Fingerprint)tuple2._2();
                return Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(cls.getName()), "$")), new Tuple2<Class, Fingerprint>(cls, fingerprint));
            }
            throw new MatchError(tuple2);
        })).toMap($less$colon$less$.MODULE$.refl());
        LongRef successCounter = LongRef.create(0L);
        LongRef failureCounter = LongRef.create(0L);
        startingTestClass.foreach((Function1<String, Object> & Serializable)testClass -> {
            TestRunnerUtils$.$anonfun$runTasksFromQueue$4(this, claimFolder, globSelectorCache, runner, testReporter, events, ctx, successCounter, failureCounter, resultPath, testClass);
            return BoxedUnit.UNIT;
        });
        list$.MODULE$.apply(testClassQueueFolder).foreach((Function1<Path, Object> & Serializable)file -> {
            TestRunnerUtils$.$anonfun$runTasksFromQueue$6(this, claimFolder, globSelectorCache, runner, testReporter, events, ctx, successCounter, failureCounter, resultPath, file);
            return BoxedUnit.UNIT;
        });
        return this.handleRunnerDone(runner, events);
    }

    public Option<String> claimFile(Path file, Path claimFolder) {
        return Option$.MODULE$.when(exists$.MODULE$.apply(file) && Try$.MODULE$.apply(() -> {
            Path x$1 = file;
            Path x$2 = claimFolder.$div(new PathChunk.StringPathChunk(file.last()));
            boolean x$3 = true;
            boolean x$4 = move$.MODULE$.apply$default$3();
            boolean x$5 = move$.MODULE$.apply$default$5();
            move$.MODULE$.apply(x$1, x$2, x$4, true, x$5);
        }).isSuccess(), (Function0<String> & Serializable)() -> {
            Path claimLog = claimFolder.$div(PathChunk$.MODULE$.RelPathChunk(os.package$.MODULE$.up())).$div(new PathChunk.StringPathChunk(new StringBuilder(4).append(claimFolder.last()).append(".log").toString()));
            write$append$.MODULE$.apply(claimLog, Source$.MODULE$.WritableSource(new StringBuilder(1).append(file.last()).append("\n").toString(), (Function1<String, Writable.StringWritable> & Serializable)s -> Writable$.MODULE$.StringWritable((String)s)), write$append$.MODULE$.apply$default$3(), write$append$.MODULE$.apply$default$4());
            return file.last();
        });
    }

    public Tuple2<String, Seq<TestResult>> queueTestFramework0(Function1<ClassLoader, Framework> frameworkInstances, AggWrapper.Agg<Path> testClassfilePath, Seq<String> args, Option<String> startingTestClass, Path testClassQueueFolder, Path claimFolder, ClassLoader cl, TestReporter testReporter, Path resultPath, Ctx.Log ctx) {
        Framework framework = frameworkInstances.apply(cl);
        Runner runner = framework.runner((String[])args.toArray(ClassTag$.MODULE$.apply(String.class)), (String[])Array$.MODULE$.apply(Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class)), cl);
        AggWrapper.Agg<Tuple2<Class<?>, Fingerprint>> testClasses = this.discoverTests(cl, framework, testClassfilePath);
        Tuple2<String, Iterator<TestResult>> tuple2 = this.runTasksFromQueue(startingTestClass, testClasses, testReporter, runner, claimFolder, testClassQueueFolder, resultPath, ctx);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String doneMessage = tuple2._1();
        Iterator<TestResult> results = tuple2._2();
        Tuple2<String, Iterator<TestResult>> tuple22 = new Tuple2<String, Iterator<TestResult>>(doneMessage, results);
        String doneMessage2 = tuple22._1();
        Iterator<TestResult> results2 = tuple22._2();
        return new Tuple2<String, Seq<TestResult>>(doneMessage2, results2.toSeq());
    }

    public String[] getTestTasks0(Function1<ClassLoader, Framework> frameworkInstances, AggWrapper.Agg<Path> testClassfilePath, Seq<String> args, Function1<Class<?>, Object> classFilter, ClassLoader cl) {
        Framework framework = frameworkInstances.apply(cl);
        Tuple2<Runner, Task[][]> tuple2 = this.getTestTasks(framework, args, classFilter, cl, testClassfilePath);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Runner runner = tuple2._1();
        Task[][] tasksArr = tuple2._2();
        Tuple2<Runner, Task[][]> tuple22 = new Tuple2<Runner, Task[][]>(runner, tasksArr);
        Runner runner2 = tuple22._1();
        Task[][] tasksArr2 = tuple22._2();
        return (String[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.flatten$extension(Predef$.MODULE$.refArrayOps((Object[])tasksArr2), (Function1<Task[], ArraySeq.ofRef> & Serializable)xs -> Predef$.MODULE$.wrapRefArray((Object[])xs), ClassTag$.MODULE$.apply(Task.class))), (Function1<Task, String> & Serializable)x$20 -> x$20.taskDef().fullyQualifiedName(), ClassTag$.MODULE$.apply(String.class));
    }

    public Function1<String, Object> globFilter(Seq<String> selectors) {
        Seq filters = (Seq)selectors.map((Function1<String, Function1> & Serializable)str -> {
            Object object;
            Object object2;
            String string = str;
            String string2 = "*";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                return (Function1<String, Object> & Serializable)x$21 -> BoxesRunTime.boxToBoolean(TestRunnerUtils$.$anonfun$globFilter$2(x$21));
            }
            if (str.indexOf(42) == -1) {
                return (Function1<String, Object> & Serializable)s -> BoxesRunTime.boxToBoolean(TestRunnerUtils$.$anonfun$globFilter$3(str, s));
            }
            String[] parts = str.split("\\*", -1);
            String[] stringArray = parts;
            if (stringArray != null && !Array$UnapplySeqWrapper$.MODULE$.isEmpty$extension(object2 = Array$.MODULE$.unapplySeq(stringArray)) && new Array.UnapplySeqWrapper(Array$UnapplySeqWrapper$.MODULE$.get$extension(object2)) != null && Array$UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array$UnapplySeqWrapper$.MODULE$.get$extension(object2), 2) == 0) {
                String string3 = (String)Array$UnapplySeqWrapper$.MODULE$.apply$extension(Array$UnapplySeqWrapper$.MODULE$.get$extension(object2), 0);
                String suffix = (String)Array$UnapplySeqWrapper$.MODULE$.apply$extension(Array$UnapplySeqWrapper$.MODULE$.get$extension(object2), 1);
                if ("".equals(string3)) {
                    return (Function1<String, Object> & Serializable)s -> BoxesRunTime.boxToBoolean(s.endsWith(suffix));
                }
            }
            if (stringArray != null && !Array$UnapplySeqWrapper$.MODULE$.isEmpty$extension(object = Array$.MODULE$.unapplySeq(stringArray)) && new Array.UnapplySeqWrapper(Array$UnapplySeqWrapper$.MODULE$.get$extension(object)) != null && Array$UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array$UnapplySeqWrapper$.MODULE$.get$extension(object), 2) == 0) {
                String prefix = (String)Array$UnapplySeqWrapper$.MODULE$.apply$extension(Array$UnapplySeqWrapper$.MODULE$.get$extension(object), 0);
                String string4 = (String)Array$UnapplySeqWrapper$.MODULE$.apply$extension(Array$UnapplySeqWrapper$.MODULE$.get$extension(object), 1);
                if ("".equals(string4)) {
                    return (Function1<String, Object> & Serializable)s -> BoxesRunTime.boxToBoolean(s.startsWith(prefix));
                }
            }
            Pattern pattern = Pattern.compile(Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps(parts), (Function1<String, String> & Serializable)x$1 -> Pattern.quote(x$1), ClassTag$.MODULE$.apply(String.class))).mkString(".*"));
            return (Function1<String, Object> & Serializable)s -> BoxesRunTime.boxToBoolean(TestRunnerUtils$.$anonfun$globFilter$7(pattern, s));
        });
        if (filters.isEmpty()) {
            return (Function1<String, Object> & Serializable)x$22 -> BoxesRunTime.boxToBoolean(TestRunnerUtils$.$anonfun$globFilter$8(x$22));
        }
        return (Function1<String, Object> & Serializable)className -> BoxesRunTime.boxToBoolean(TestRunnerUtils$.$anonfun$globFilter$9(filters, className));
    }

    public static final /* synthetic */ boolean $anonfun$listClassFiles$1(Path x$1) {
        String string = x$1.ext();
        String string2 = "class";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$listClassFiles$5(ZipEntry x$3) {
        return x$3 != null;
    }

    public static final /* synthetic */ boolean $anonfun$discoverTests$4(Constructor c) {
        return Modifier.isPublic(c.getModifiers());
    }

    public static final /* synthetic */ boolean $anonfun$discoverTests$5(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Class c = (Class)tuple2._1();
            return !c.isMemberClass() && !c.isAnonymousClass();
        }
        throw new MatchError(tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$matchFingerprints$3(Class annotationCls$1, Method m) {
        return m.isAnnotationPresent(annotationCls$1) && Modifier.isPublic(m.getModifiers());
    }

    public static final /* synthetic */ boolean $anonfun$matchFingerprints$1(boolean isModule$1, ClassLoader cl$2, Class cls$1, Fingerprint x0$1) {
        Fingerprint fingerprint = x0$1;
        if (fingerprint instanceof SubclassFingerprint) {
            SubclassFingerprint subclassFingerprint = (SubclassFingerprint)fingerprint;
            return subclassFingerprint.isModule() == isModule$1 && cl$2.loadClass(subclassFingerprint.superclassName()).isAssignableFrom(cls$1);
        }
        if (fingerprint instanceof AnnotatedFingerprint) {
            AnnotatedFingerprint annotatedFingerprint = (AnnotatedFingerprint)fingerprint;
            Class<?> annotationCls = cl$2.loadClass(annotatedFingerprint.annotationName());
            return annotatedFingerprint.isModule() == isModule$1 && (cls$1.isAnnotationPresent(annotationCls) || ArrayOps$.MODULE$.exists$extension(Predef$.MODULE$.refArrayOps(cls$1.getDeclaredMethods()), (Function1<Method, Object> & Serializable)x$7 -> BoxesRunTime.boxToBoolean(x$7.isAnnotationPresent(annotationCls))) || ArrayOps$.MODULE$.exists$extension(Predef$.MODULE$.refArrayOps(cls$1.getMethods()), (Function1<Method, Object> & Serializable)m -> BoxesRunTime.boxToBoolean(TestRunnerUtils$.$anonfun$matchFingerprints$3(annotationCls, m))));
        }
        throw new MatchError(fingerprint);
    }

    public static final /* synthetic */ boolean $anonfun$getTestTasks$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        return tuple2 != null;
    }

    public static final /* synthetic */ boolean $anonfun$getTestTasks$2(Function1 classFilter$1, Tuple2 x$8) {
        Tuple2 tuple2 = x$8;
        if (tuple2 != null) {
            Class cls = (Class)tuple2._1();
            return BoxesRunTime.unboxToBoolean(classFilter$1.apply(cls));
        }
        throw new MatchError(tuple2);
    }

    private static final Option nameOpt$1(Task t) {
        return Option$.MODULE$.apply(t.taskDef()).map((Function1<TaskDef, String> & Serializable)x$10 -> x$10.fullyQualifiedName());
    }

    public static final /* synthetic */ void $anonfun$runTasks$4(TestReporter testReporter$2, ConcurrentLinkedQueue events$2, Ctx.Log ctx$2, LongRef successCounter$1, LongRef failureCounter$1, Function0 resultLog$1, Seq tasks) {
        boolean taskResult = MODULE$.executeTasks(tasks, testReporter$2, events$2, ctx$2);
        if (taskResult) {
            ++successCounter$1.elem;
        } else {
            ++failureCounter$1.elem;
        }
        resultLog$1.apply$mcV$sp();
    }

    private final void runClaimedTestClass$1(String testClassName, Map globSelectorCache$1, Runner runner$1, TestReporter testReporter$3, ConcurrentLinkedQueue events$3, Ctx.Log ctx$3, LongRef successCounter$2, LongRef failureCounter$2, Path resultPath$2) {
        System.err.println(new StringBuilder(19).append("Running Test Class ").append(testClassName).toString());
        Option taskDefs = globSelectorCache$1.get(testClassName).map((Function1<Tuple2, TaskDef> & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Class cls = (Class)tuple2._1();
                Fingerprint fingerprint = (Fingerprint)tuple2._2();
                String clsName = StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(cls.getName()), "$");
                return new TaskDef(clsName, fingerprint, false, (Selector[])((Object[])new Selector[]{new SuiteSelector()}));
            }
            throw new MatchError(tuple2);
        });
        Task[] tasks = runner$1.tasks((TaskDef[])Option$.MODULE$.option2Iterable(taskDefs).toArray(ClassTag$.MODULE$.apply(TaskDef.class)));
        boolean taskResult = this.executeTasks(Predef$.MODULE$.copyArrayToImmutableIndexedSeq(tasks), testReporter$3, events$3, ctx$3);
        if (taskResult) {
            ++successCounter$2.elem;
        } else {
            ++failureCounter$2.elem;
        }
        write$over$.MODULE$.apply(resultPath$2, Source$.MODULE$.WritableSource(default$.MODULE$.write(new Tuple2$mcJJ$sp(successCounter$2.elem, failureCounter$2.elem), default$.MODULE$.write$default$2(), default$.MODULE$.write$default$3(), default$.MODULE$.write$default$4(), default$.MODULE$.Tuple2Writer(default$.MODULE$.LongWriter(), default$.MODULE$.LongWriter())), (Function1<String, Writable.StringWritable> & Serializable)s -> Writable$.MODULE$.StringWritable((String)s)), write$over$.MODULE$.apply$default$3(), write$over$.MODULE$.apply$default$4(), write$over$.MODULE$.apply$default$5(), write$over$.MODULE$.apply$default$6());
    }

    public static final /* synthetic */ void $anonfun$runTasksFromQueue$4(TestRunnerUtils$ $this, Path claimFolder$1, Map globSelectorCache$1, Runner runner$1, TestReporter testReporter$3, ConcurrentLinkedQueue events$3, Ctx.Log ctx$3, LongRef successCounter$2, LongRef failureCounter$2, Path resultPath$2, String testClass) {
        write$append$.MODULE$.apply(claimFolder$1.$div(PathChunk$.MODULE$.RelPathChunk(os.package$.MODULE$.up())).$div(new PathChunk.StringPathChunk(new StringBuilder(4).append(claimFolder$1.last()).append(".log").toString())), Source$.MODULE$.WritableSource(new StringBuilder(1).append(testClass).append("\n").toString(), (Function1<String, Writable.StringWritable> & Serializable)s -> Writable$.MODULE$.StringWritable((String)s)), write$append$.MODULE$.apply$default$3(), write$append$.MODULE$.apply$default$4());
        $this.runClaimedTestClass$1(testClass, globSelectorCache$1, runner$1, testReporter$3, events$3, ctx$3, successCounter$2, failureCounter$2, resultPath$2);
    }

    public static final /* synthetic */ void $anonfun$runTasksFromQueue$6(TestRunnerUtils$ $this, Path claimFolder$1, Map globSelectorCache$1, Runner runner$1, TestReporter testReporter$3, ConcurrentLinkedQueue events$3, Ctx.Log ctx$3, LongRef successCounter$2, LongRef failureCounter$2, Path resultPath$2, Path file) {
        MODULE$.claimFile(file, claimFolder$1).foreach((Function1<String, Object> & Serializable)claimedTestClass -> {
            $this.runClaimedTestClass$1(claimedTestClass, globSelectorCache$1, runner$1, testReporter$3, events$3, ctx$3, successCounter$2, failureCounter$2, resultPath$2);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$globFilter$2(String x$21) {
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$globFilter$3(String str$1, String s) {
        String string = s;
        String string2 = str$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$globFilter$7(Pattern pattern$1, String s) {
        return pattern$1.matcher(s).matches();
    }

    public static final /* synthetic */ boolean $anonfun$globFilter$8(String x$22) {
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$globFilter$10(String name$1, Function1 f) {
        return BoxesRunTime.unboxToBoolean(f.apply(name$1));
    }

    public static final /* synthetic */ boolean $anonfun$globFilter$9(Seq filters$1, String className) {
        String name = StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(className), "$");
        return filters$1.exists((Function1<Function1, Object> & Serializable)f -> BoxesRunTime.boxToBoolean(TestRunnerUtils$.$anonfun$globFilter$10(name, f)));
    }

    private TestRunnerUtils$() {
    }
}

