/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.graphviz.parse;

import java.util.Objects;

final class Token {
    static final int EOF = 0;
    static final int SEMICOLON = 1;
    static final int COMMA = 2;
    static final int BRACE_OPEN = 3;
    static final int BRACE_CLOSE = 4;
    static final int EQUAL = 5;
    static final int BRACKET_OPEN = 6;
    static final int BRACKET_CLOSE = 7;
    static final int COLON = 8;
    static final int STRICT = 9;
    static final int GRAPH = 10;
    static final int DIGRAPH = 11;
    static final int NODE = 12;
    static final int EDGE = 13;
    static final int SUBGRAPH = 14;
    static final int ID = 16;
    static final int MINUS_MINUS = 18;
    static final int ARROW = 19;
    static final int SUB_SIMPLE = 1;
    static final int SUB_NUMERAL = 2;
    static final int SUB_QUOTED = 3;
    static final int SUB_HTML = 4;
    final int type;
    final int subtype;
    final String value;

    Token(int type, String value) {
        this(type, -1, value);
    }

    Token(int type, char value) {
        this(type, -1, Character.toString(value));
    }

    Token(int type, int subtype, String value) {
        this.type = type;
        this.subtype = subtype;
        this.value = value;
    }

    static String desc(int type) {
        switch (type) {
            case 16: {
                return "identifier";
            }
            case 5: {
                return "=";
            }
            case 0: {
                return "end of file";
            }
            case 6: {
                return "[";
            }
            case 7: {
                return "]";
            }
            case 3: {
                return "{";
            }
            case 4: {
                return "}";
            }
        }
        return "";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Token token = (Token)o;
        return this.type == token.type && this.subtype == token.subtype && Objects.equals(this.value, token.value);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.subtype, this.value);
    }

    public String toString() {
        return this.type + (this.subtype >= 0 ? "(" + this.subtype + ")" : "") + "`" + this.value + "`";
    }
}

