/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.gamemode.abilitycategory;

import java.util.Collection;
import java.util.StringTokenizer;
import pcgen.cdom.reference.CDOMSingleRef;
import pcgen.cdom.reference.ReferenceUtilities;
import pcgen.core.Ability;
import pcgen.core.AbilityCategory;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractTokenWithSeparator;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ParseResult;

public class AbilityListToken
extends AbstractTokenWithSeparator<AbilityCategory>
implements CDOMPrimaryToken<AbilityCategory> {
    private static final Class<Ability> ABILITY_CLASS = Ability.class;

    @Override
    public String getTokenName() {
        return "ABILITYLIST";
    }

    @Override
    protected ParseResult parseTokenWithSeparator(LoadContext context, AbilityCategory ac, String value) {
        StringTokenizer st = new StringTokenizer(value, "|");
        while (st.hasMoreTokens()) {
            ac.addAbilityKey(context.getReferenceContext().getManufacturer(ABILITY_CLASS, ac).getReference(st.nextToken()));
        }
        return ParseResult.SUCCESS;
    }

    @Override
    protected char separator() {
        return '|';
    }

    @Override
    public String[] unparse(LoadContext context, AbilityCategory ac) {
        Collection<CDOMSingleRef<Ability>> abilities = ac.getAbilityRefs();
        if (abilities.isEmpty()) {
            return null;
        }
        return new String[]{ReferenceUtilities.joinLstFormat(abilities, "|")};
    }

    @Override
    public Class<AbilityCategory> getTokenClass() {
        return AbilityCategory.class;
    }
}

