/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.ability;

import java.math.BigDecimal;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.core.Ability;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractNonEmptyToken;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ParseResult;

public class CostToken
extends AbstractNonEmptyToken<Ability>
implements CDOMPrimaryToken<Ability> {
    @Override
    public String getTokenName() {
        return "COST";
    }

    @Override
    protected ParseResult parseNonEmptyToken(LoadContext context, Ability ability, String value) {
        try {
            context.getObjectContext().put((CDOMObject)ability, ObjectKey.SELECTION_COST, new BigDecimal(value));
            return ParseResult.SUCCESS;
        }
        catch (NumberFormatException e) {
            return new ParseResult.Fail(this.getTokenName() + " expected a number: " + value, context);
        }
    }

    @Override
    public String[] unparse(LoadContext context, Ability ability) {
        BigDecimal bd = context.getObjectContext().getObject(ability, ObjectKey.SELECTION_COST);
        if (bd == null) {
            return null;
        }
        return new String[]{bd.toString()};
    }

    @Override
    public Class<Ability> getTokenClass() {
        return Ability.class;
    }
}

