/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.tabs.bio;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import pcgen.facade.core.CharacterFacade;
import pcgen.facade.core.DescriptionFacade;
import pcgen.facade.core.NoteFacade;
import pcgen.gui2.tabs.CharacterInfoTab;
import pcgen.gui2.tabs.TabTitle;
import pcgen.gui2.tabs.models.TextFieldListener;
import pcgen.system.LanguageBundle;

public class NoteInfoPane
extends JPanel
implements CharacterInfoTab {
    private final TabTitle title;
    private final JTextField nameField;
    private final JTextArea noteField;
    private final JButton removeButton;
    private String name;
    private final NoteFacade note;

    public NoteInfoPane(NoteFacade note) {
        this.note = note;
        this.nameField = new JTextField(15);
        this.name = note.getName();
        this.noteField = new JTextArea(8, 20);
        this.title = new TabTitle(this.name, null);
        this.removeButton = new JButton(LanguageBundle.getString("in_descDelNote"));
        this.nameField.setEditable(!note.isRequired());
        this.removeButton.setEnabled(!note.isRequired());
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        Box hbox = Box.createHorizontalBox();
        hbox.add(Box.createRigidArea(new Dimension(5, 0)));
        hbox.add(new JLabel(LanguageBundle.getString("in_descNoteName")));
        hbox.add(Box.createRigidArea(new Dimension(5, 0)));
        hbox.add(this.nameField);
        this.nameField.setText(this.name);
        hbox.add(Box.createRigidArea(new Dimension(5, 0)));
        hbox.add(this.removeButton);
        hbox.add(Box.createHorizontalGlue());
        this.noteField.setLineWrap(true);
        this.noteField.setWrapStyleWord(true);
        this.add((Component)hbox, "North");
        JScrollPane pane = new JScrollPane(this.noteField, 20, 30);
        this.add((Component)pane, "Center");
    }

    @Override
    public CharacterInfoTab.ModelMap createModels(CharacterFacade character) {
        CharacterInfoTab.ModelMap models = new CharacterInfoTab.ModelMap();
        models.put(NoteHandler.class, new NoteHandler(character));
        return models;
    }

    @Override
    public void restoreModels(CharacterInfoTab.ModelMap models) {
    }

    @Override
    public void storeModels(CharacterInfoTab.ModelMap models) {
    }

    @Override
    public TabTitle getTabTitle() {
        return this.title;
    }

    public NoteFacade getNote() {
        return this.note;
    }

    private class NoteHandler
    implements ActionListener {
        private final DescriptionFacade descFacade;

        public NoteHandler(CharacterFacade character) {
            this.descFacade = character.getDescriptionFacade();
            NoteInfoPane.this.noteField.setText(NoteInfoPane.this.note.getValue());
            NoteInfoPane.this.nameField.getDocument().addDocumentListener(new TextFieldListener(NoteInfoPane.this.nameField){

                @Override
                protected void textChanged(String text) {
                    NoteHandler.this.descFacade.renameNote(NoteInfoPane.this.note, text);
                    NoteInfoPane.this.name = text;
                }
            });
            NoteInfoPane.this.noteField.getDocument().addDocumentListener(new TextFieldListener(NoteInfoPane.this.noteField){

                @Override
                protected void textChanged(String text) {
                    NoteHandler.this.descFacade.setNote(NoteInfoPane.this.note, text);
                }
            });
            NoteInfoPane.this.removeButton.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.descFacade.deleteNote(NoteInfoPane.this.note);
        }
    }
}

