/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.tabs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import pcgen.facade.core.CharacterFacade;
import pcgen.facade.core.InfoFactory;
import pcgen.facade.core.TemplateFacade;
import pcgen.facade.util.DefaultListFacade;
import pcgen.facade.util.ListFacade;
import pcgen.facade.util.event.ListEvent;
import pcgen.facade.util.event.ListListener;
import pcgen.gui2.filter.Filter;
import pcgen.gui2.filter.FilterBar;
import pcgen.gui2.filter.FilterButton;
import pcgen.gui2.filter.FilteredListFacade;
import pcgen.gui2.filter.FilteredTreeViewTable;
import pcgen.gui2.filter.SearchFilterPanel;
import pcgen.gui2.tabs.CharacterInfoTab;
import pcgen.gui2.tabs.TabTitle;
import pcgen.gui2.tabs.models.CharacterTreeCellRenderer;
import pcgen.gui2.tabs.models.ConcurrentDataView;
import pcgen.gui2.tabs.models.QualifiedTreeCellRenderer;
import pcgen.gui2.tools.FlippingSplitPane;
import pcgen.gui2.tools.Icons;
import pcgen.gui2.tools.InfoPane;
import pcgen.gui2.util.SortMode;
import pcgen.gui2.util.SortingPriority;
import pcgen.gui2.util.treeview.DataView;
import pcgen.gui2.util.treeview.DataViewColumn;
import pcgen.gui2.util.treeview.DefaultDataViewColumn;
import pcgen.gui2.util.treeview.TreeView;
import pcgen.gui2.util.treeview.TreeViewModel;
import pcgen.gui2.util.treeview.TreeViewPath;
import pcgen.system.LanguageBundle;
import pcgen.util.enumeration.Tab;

public class TemplateInfoTab
extends FlippingSplitPane
implements CharacterInfoTab {
    private final TabTitle tabTitle = new TabTitle(Tab.TEMPLATES);
    private final FilteredTreeViewTable<CharacterFacade, TemplateFacade> availableTable = new FilteredTreeViewTable();
    private final FilteredTreeViewTable<CharacterFacade, TemplateFacade> selectedTable = new FilteredTreeViewTable();
    private final JButton addButton = new JButton();
    private final JButton removeButton = new JButton();
    private final InfoPane infoPane = new InfoPane("in_irTemplateInfo");
    private final FilterButton<CharacterFacade, TemplateFacade> qFilterButton = new FilterButton("TemplateQualified");
    private final QualifiedTreeCellRenderer qualifiedRenderer = new QualifiedTreeCellRenderer();

    public TemplateInfoTab() {
        super("Template");
        this.initComponents();
    }

    private void initComponents() {
        FlippingSplitPane topPane = new FlippingSplitPane("TemplateTop");
        this.setTopComponent(topPane);
        this.setOrientation(0);
        JPanel availPanel = new JPanel(new BorderLayout());
        FilterBar<Object, Object> bar = new FilterBar<Object, Object>();
        bar.addDisplayableFilter(new SearchFilterPanel());
        this.qFilterButton.setText(LanguageBundle.getString("in_igQualFilter"));
        bar.addDisplayableFilter(this.qFilterButton);
        availPanel.add(bar, "North");
        this.availableTable.setDisplayableFilter(bar);
        this.availableTable.setTreeCellRenderer(this.qualifiedRenderer);
        this.availableTable.setSortingPriority(Collections.singletonList(new SortingPriority(0, SortMode.ASCENDING)));
        this.availableTable.sortModel();
        availPanel.add((Component)new JScrollPane(this.availableTable), "Center");
        Box box = Box.createHorizontalBox();
        box.add(Box.createHorizontalGlue());
        this.addButton.setHorizontalTextPosition(10);
        box.add(this.addButton);
        box.add(Box.createHorizontalStrut(5));
        box.setBorder(new EmptyBorder(0, 0, 5, 0));
        availPanel.add((Component)box, "South");
        topPane.setLeftComponent(availPanel);
        JPanel selPanel = new JPanel(new BorderLayout());
        FilterBar<Object, Object> filterBar = new FilterBar<Object, Object>();
        filterBar.addDisplayableFilter(new SearchFilterPanel());
        this.selectedTable.setDisplayableFilter(filterBar);
        this.selectedTable.setTreeCellRenderer(this.qualifiedRenderer);
        this.selectedTable.setSortingPriority(Collections.singletonList(new SortingPriority(0, SortMode.ASCENDING)));
        this.selectedTable.sortModel();
        selPanel.add((Component)new JScrollPane(this.selectedTable), "Center");
        box = Box.createHorizontalBox();
        box.add(Box.createHorizontalStrut(5));
        box.add(this.removeButton);
        box.add(Box.createHorizontalGlue());
        box.setBorder(new EmptyBorder(0, 0, 5, 0));
        selPanel.add((Component)box, "South");
        topPane.setRightComponent(selPanel);
        this.setBottomComponent(this.infoPane);
        this.setResizeWeight(0.75);
    }

    @Override
    public CharacterInfoTab.ModelMap createModels(CharacterFacade character) {
        CharacterInfoTab.ModelMap models = new CharacterInfoTab.ModelMap();
        models.put(TreeViewModelHandler.class, new TreeViewModelHandler(character));
        models.put(InfoHandler.class, new InfoHandler(character));
        models.put(AddAction.class, new AddAction(character));
        models.put(RemoveAction.class, new RemoveAction(character));
        models.put(CharacterTreeCellRenderer.Handler.class, this.qualifiedRenderer.createHandler(character));
        models.put(QualifiedFilterHandler.class, new QualifiedFilterHandler(character));
        return models;
    }

    @Override
    public void restoreModels(CharacterInfoTab.ModelMap models) {
        models.get(QualifiedFilterHandler.class).install();
        models.get(CharacterTreeCellRenderer.Handler.class).install();
        models.get(TreeViewModelHandler.class).install();
        models.get(InfoHandler.class).install();
        models.get(AddAction.class).install();
        models.get(RemoveAction.class).install();
    }

    @Override
    public void storeModels(CharacterInfoTab.ModelMap models) {
        models.get(TreeViewModelHandler.class).uninstall();
        models.get(InfoHandler.class).uninstall();
        models.get(AddAction.class).uninstall();
        models.get(RemoveAction.class).uninstall();
        models.get(CharacterTreeCellRenderer.Handler.class).uninstall();
    }

    @Override
    public TabTitle getTabTitle() {
        return this.tabTitle;
    }

    private static enum TemplateTreeView implements TreeView<TemplateFacade>
    {
        NAME("in_nameLabel"),
        TYPE_NAME("in_typeName"),
        SOURCE_NAME("in_sourceName");

        private String name;

        private TemplateTreeView(String name) {
            this.name = LanguageBundle.getString(name);
        }

        @Override
        public String getViewName() {
            return this.name;
        }

        @Override
        public List<TreeViewPath<TemplateFacade>> getPaths(TemplateFacade pobj) {
            switch (this) {
                case NAME: {
                    return Collections.singletonList(new TreeViewPath<TemplateFacade>(pobj));
                }
                case TYPE_NAME: {
                    return Collections.singletonList(new TreeViewPath<TemplateFacade>(pobj, (Object)pobj.getType()));
                }
                case SOURCE_NAME: {
                    return Collections.singletonList(new TreeViewPath<TemplateFacade>(pobj, (Object)pobj.getSourceForNodeDisplay()));
                }
            }
            throw new InternalError();
        }
    }

    private static class TemplateTreeViewModel
    implements TreeViewModel<TemplateFacade>,
    Filter<CharacterFacade, TemplateFacade>,
    ListListener<TemplateFacade> {
        private static final DefaultListFacade<? extends TreeView<TemplateFacade>> treeViews = new DefaultListFacade<TemplateTreeView>(Arrays.asList(TemplateTreeView.values()));
        private final CharacterFacade character;
        private final boolean isAvailModel;
        private final TemplateDataView dataView;
        private FilteredListFacade<CharacterFacade, TemplateFacade> templates;

        public TemplateTreeViewModel(CharacterFacade character, boolean isAvailModel, TemplateDataView dataView) {
            this.character = character;
            this.isAvailModel = isAvailModel;
            this.dataView = dataView;
            if (isAvailModel) {
                this.templates = new FilteredListFacade();
                this.templates.setContext(character);
                this.templates.setFilter(this);
                this.templates.setDelegate(character.getDataSet().getTemplates());
                character.getTemplates().addListListener(this);
            } else {
                this.templates = null;
            }
        }

        @Override
        public ListFacade<? extends TreeView<TemplateFacade>> getTreeViews() {
            return treeViews;
        }

        @Override
        public int getDefaultTreeViewIndex() {
            return 0;
        }

        @Override
        public DataView<TemplateFacade> getDataView() {
            return this.dataView;
        }

        @Override
        public ListFacade<TemplateFacade> getDataModel() {
            if (this.isAvailModel) {
                return this.templates;
            }
            return this.character.getTemplates();
        }

        @Override
        public void elementAdded(ListEvent<TemplateFacade> e) {
            this.templates.refilter();
        }

        @Override
        public void elementRemoved(ListEvent<TemplateFacade> e) {
            this.templates.refilter();
        }

        @Override
        public void elementsChanged(ListEvent<TemplateFacade> e) {
            this.templates.refilter();
        }

        @Override
        public void elementModified(ListEvent<TemplateFacade> e) {
            this.templates.refilter();
        }

        @Override
        public boolean accept(CharacterFacade context, TemplateFacade element) {
            return !context.getTemplates().containsElement(element);
        }
    }

    private class TemplateDataView
    extends ConcurrentDataView<TemplateFacade> {
        private final List<DefaultDataViewColumn> columns;
        private final InfoFactory infoFactory;
        private final boolean isAvailModel;

        public TemplateDataView(CharacterFacade character, boolean isAvailModel) {
            this.infoFactory = character.getInfoFactory();
            this.isAvailModel = isAvailModel;
            this.columns = isAvailModel ? Arrays.asList(new DefaultDataViewColumn("in_lvlAdj", String.class, true), new DefaultDataViewColumn("in_modifier", String.class, true), new DefaultDataViewColumn("in_preReqs", String.class, true), new DefaultDataViewColumn("in_descrip", String.class, false), new DefaultDataViewColumn("in_source", String.class, false)) : Arrays.asList(new DefaultDataViewColumn("in_lvlAdj", String.class, false), new DefaultDataViewColumn("in_modifier", String.class, false), new DefaultDataViewColumn("in_preReqs", String.class, false), new DefaultDataViewColumn("in_descrip", String.class, false), new DefaultDataViewColumn("in_source", String.class, false));
        }

        @Override
        public List<? extends DataViewColumn> getDataColumns() {
            return this.columns;
        }

        @Override
        public String getPrefsKey() {
            return this.isAvailModel ? "TemplateTreeAvail" : "TemplateTreeSelected";
        }

        @Override
        protected List<?> getDataList(TemplateFacade obj) {
            return Arrays.asList(this.infoFactory.getLevelAdjustment(obj), this.infoFactory.getModifier(obj), this.infoFactory.getPreReqHTML(obj), this.infoFactory.getDescription(obj), obj.getSource());
        }

        @Override
        protected void refreshTableData() {
            if (this.isAvailModel) {
                TemplateInfoTab.this.availableTable.refreshModelData();
            } else {
                TemplateInfoTab.this.selectedTable.refreshModelData();
            }
        }
    }

    private class TreeViewModelHandler {
        private final TemplateDataView availDataView;
        private final TemplateDataView selDataView;
        private final TemplateTreeViewModel availTreeView;
        private final TemplateTreeViewModel selTreeView;

        public TreeViewModelHandler(CharacterFacade character) {
            this.availDataView = new TemplateDataView(character, true);
            this.selDataView = new TemplateDataView(character, false);
            this.availTreeView = new TemplateTreeViewModel(character, true, this.availDataView);
            this.selTreeView = new TemplateTreeViewModel(character, false, this.selDataView);
        }

        public void install() {
            TemplateInfoTab.this.availableTable.setTreeViewModel(this.availTreeView);
            TemplateInfoTab.this.selectedTable.setTreeViewModel(this.selTreeView);
            this.availDataView.install();
            this.selDataView.install();
        }

        public void uninstall() {
            this.availDataView.uninstall();
            this.selDataView.uninstall();
        }
    }

    private class QualifiedFilterHandler {
        private final Filter<CharacterFacade, TemplateFacade> qFilter = new Filter<CharacterFacade, TemplateFacade>(){

            @Override
            public boolean accept(CharacterFacade context, TemplateFacade element) {
                return QualifiedFilterHandler.this.character.isQualifiedFor(element);
            }
        };
        private final CharacterFacade character;

        public QualifiedFilterHandler(CharacterFacade character) {
            this.character = character;
        }

        public void install() {
            TemplateInfoTab.this.qFilterButton.setFilter(this.qFilter);
        }
    }

    private class RemoveAction
    extends AbstractAction {
        private CharacterFacade character;

        public RemoveAction(CharacterFacade character) {
            super(LanguageBundle.getString("in_irRemoveTemplate"));
            this.character = character;
            this.putValue("SmallIcon", Icons.Back16.getImageIcon());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            List<Object> data = TemplateInfoTab.this.selectedTable.getSelectedData();
            for (Object object : data) {
                if (!(object instanceof TemplateFacade)) continue;
                this.character.removeTemplate((TemplateFacade)object);
                return;
            }
        }

        public void install() {
            TemplateInfoTab.this.selectedTable.addActionListener(this);
            TemplateInfoTab.this.removeButton.setAction(this);
        }

        public void uninstall() {
            TemplateInfoTab.this.selectedTable.removeActionListener(this);
        }
    }

    private class AddAction
    extends AbstractAction {
        private CharacterFacade character;

        public AddAction(CharacterFacade character) {
            super(LanguageBundle.getString("in_irAddTemplate"));
            this.character = character;
            this.putValue("SmallIcon", Icons.Forward16.getImageIcon());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            List<Object> data = TemplateInfoTab.this.availableTable.getSelectedData();
            for (Object object : data) {
                if (!(object instanceof TemplateFacade)) continue;
                this.character.addTemplate((TemplateFacade)object);
                return;
            }
        }

        public void install() {
            TemplateInfoTab.this.availableTable.addActionListener(this);
            TemplateInfoTab.this.addButton.setAction(this);
        }

        public void uninstall() {
            TemplateInfoTab.this.availableTable.removeActionListener(this);
        }
    }

    private class InfoHandler
    implements ListSelectionListener {
        private CharacterFacade character;
        private String text;

        public InfoHandler(CharacterFacade character) {
            this.character = character;
            this.text = "";
        }

        public void install() {
            TemplateInfoTab.this.availableTable.getSelectionModel().addListSelectionListener(this);
            TemplateInfoTab.this.selectedTable.getSelectionModel().addListSelectionListener(this);
            TemplateInfoTab.this.infoPane.setText(this.text);
        }

        public void uninstall() {
            TemplateInfoTab.this.availableTable.getSelectionModel().removeListSelectionListener(this);
            TemplateInfoTab.this.selectedTable.getSelectionModel().removeListSelectionListener(this);
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                Object obj = null;
                if (e.getSource() == TemplateInfoTab.this.availableTable.getSelectionModel()) {
                    int selectedRow = TemplateInfoTab.this.availableTable.getSelectedRow();
                    if (selectedRow != -1) {
                        obj = TemplateInfoTab.this.availableTable.getModel().getValueAt(selectedRow, 0);
                    }
                } else {
                    int selectedRow = TemplateInfoTab.this.selectedTable.getSelectedRow();
                    if (selectedRow != -1) {
                        obj = TemplateInfoTab.this.selectedTable.getModel().getValueAt(selectedRow, 0);
                    }
                }
                if (obj instanceof TemplateFacade) {
                    this.text = this.character.getInfoFactory().getHTMLInfo((TemplateFacade)obj);
                    TemplateInfoTab.this.infoPane.setText(this.text);
                }
            }
        }
    }
}

