/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.character;

import java.util.IdentityHashMap;
import java.util.Map;
import java.util.StringTokenizer;
import pcgen.cdom.enumeration.EquipmentLocation;
import pcgen.core.BonusManager;
import pcgen.core.Equipment;
import pcgen.core.PlayerCharacter;
import pcgen.core.bonus.BonusObj;
import pcgen.core.utils.MessageType;
import pcgen.core.utils.ShowMessageDelegate;
import pcgen.util.Logging;

public final class EquipSet
implements Comparable<EquipSet>,
Cloneable {
    public static String DEFAULT_SET_PATH = "0.1";
    private Equipment eq_item;
    private Float qty = new Float(1.0f);
    private Map<BonusObj, BonusManager.TempBonusInfo> tempBonusBySource = new IdentityHashMap<BonusObj, BonusManager.TempBonusInfo>();
    private String id_path = "";
    private String name = "";
    private String note = "";
    private String value = "";
    private boolean useTempBonuses = true;

    public static int getIdFromPath(String path) {
        int id = 0;
        try {
            StringTokenizer aTok = new StringTokenizer(path, ".", false);
            while (aTok.hasMoreTokens()) {
                id = Integer.parseInt(aTok.nextToken());
            }
        }
        catch (NullPointerException e) {
            Logging.errorPrint("Error in EquipSet.getId " + path, e);
        }
        return id;
    }

    public static String getParentPath(String path) {
        int idx = path.lastIndexOf(".");
        if (idx < 0) {
            return "";
        }
        return path.substring(0, idx);
    }

    public static int getPathDepth(String path) {
        try {
            StringTokenizer aTok = new StringTokenizer(path, ".", false);
            return aTok.countTokens();
        }
        catch (NullPointerException e) {
            Logging.errorPrint("Error in EquipSet.getPathDepth", e);
            return 0;
        }
    }

    public EquipSet(String id, String aName) {
        this.id_path = id;
        this.name = aName;
    }

    public EquipSet(String id, String aName, String aValue, Equipment item) {
        this.id_path = id;
        this.name = aName;
        this.value = aValue;
        this.eq_item = item;
    }

    public int getId() {
        return EquipSet.getIdFromPath(this.id_path);
    }

    public void setIdPath(String x) {
        this.id_path = x;
    }

    public String getIdPath() {
        return this.id_path;
    }

    public void setItem(Equipment item) {
        this.eq_item = item;
    }

    public Equipment getItem() {
        return this.eq_item;
    }

    public void setName(String x) {
        this.name = x;
    }

    public String getName() {
        return this.name;
    }

    public void setNote(String aString) {
        this.note = aString;
    }

    public String getNote() {
        return this.note;
    }

    public String getParentIdPath() {
        StringBuilder buf = new StringBuilder(50);
        try {
            StringTokenizer aTok = new StringTokenizer(this.id_path, ".", true);
            for (int i = aTok.countTokens() - 2; i > 0; --i) {
                buf.append(aTok.nextToken());
            }
        }
        catch (NullPointerException e) {
            Logging.errorPrint("Error in EquipSet.getParentIdPath", e);
        }
        return buf.toString();
    }

    public void setQty(Float x) {
        this.qty = x;
    }

    public Float getQty() {
        return this.qty;
    }

    public String getRootIdPath() {
        String result;
        StringBuilder buf = new StringBuilder(50);
        StringTokenizer aTok = new StringTokenizer(this.id_path, ".", false);
        if (aTok.countTokens() < 2) {
            result = "";
        } else {
            buf.append(aTok.nextToken());
            buf.append('.');
            buf.append(aTok.nextToken());
            result = buf.toString();
        }
        return result;
    }

    public void setTempBonusList(Map<BonusObj, BonusManager.TempBonusInfo> aList) {
        this.tempBonusBySource = aList;
    }

    public Map<BonusObj, BonusManager.TempBonusInfo> getTempBonusMap() {
        return this.tempBonusBySource;
    }

    public void setUseTempMods(boolean aBool) {
        this.useTempBonuses = aBool;
    }

    public boolean getUseTempMods() {
        return this.useTempBonuses;
    }

    public void setValue(String x) {
        this.value = x;
    }

    public String getValue() {
        return this.value;
    }

    public void clearTempBonusList() {
        this.tempBonusBySource.clear();
    }

    public Object clone() {
        EquipSet eqSet = null;
        try {
            eqSet = (EquipSet)super.clone();
            if (this.eq_item != null) {
                eqSet.eq_item = this.eq_item.clone();
            }
            if (this.qty != null) {
                eqSet.qty = new Float(this.qty.floatValue());
            }
        }
        catch (CloneNotSupportedException exc) {
            ShowMessageDelegate.showMessageDialog(exc.getMessage(), "PCGen", MessageType.ERROR);
        }
        return eqSet;
    }

    @Override
    public int compareTo(EquipSet obj) {
        return this.id_path.compareToIgnoreCase(obj.id_path);
    }

    public String toString() {
        return this.name;
    }

    public boolean useTempBonusList() {
        return !this.tempBonusBySource.isEmpty();
    }

    public void equipItem(PlayerCharacter aPC) {
        StringTokenizer aTok = new StringTokenizer(this.getIdPath(), ".");
        if (aTok.countTokens() > 3) {
            StringBuilder rootPath = new StringBuilder(40);
            for (int i = 0; i < 3; ++i) {
                if (i > 0) {
                    rootPath.append(".");
                }
                rootPath.append(aTok.nextToken());
            }
            EquipSet rootSet = aPC.getEquipSetByIdPath(rootPath.toString());
            if (rootSet != null && rootSet.name.startsWith("Carried")) {
                this.eq_item.addEquipmentToLocation(this.qty, EquipmentLocation.CARRIED_NEITHER, false, aPC);
            } else if (rootSet != null && rootSet.name.startsWith("Not Carried")) {
                this.eq_item.addEquipmentToLocation(this.qty, EquipmentLocation.NOT_CARRIED, false, aPC);
            } else if (rootSet != null && rootSet.name.startsWith("Equipped")) {
                this.eq_item.addEquipmentToLocation(this.qty, EquipmentLocation.EQUIPPED_NEITHER, false, aPC);
            } else {
                this.eq_item.addEquipmentToLocation(this.qty, EquipmentLocation.CONTAINED, false, aPC);
            }
        } else if (this.name.startsWith("Carried")) {
            this.eq_item.addEquipmentToLocation(this.qty, EquipmentLocation.CARRIED_NEITHER, false, aPC);
        } else if (this.name.startsWith("Not Carried")) {
            this.eq_item.addEquipmentToLocation(this.qty, EquipmentLocation.NOT_CARRIED, false, aPC);
        } else if (this.eq_item.isWeapon()) {
            if (this.name.equals("Primary Hand") || this.name.equals("Natural-Primary")) {
                this.eq_item.addWeaponToLocation(this.qty, EquipmentLocation.EQUIPPED_PRIMARY, aPC);
            } else if (this.name.startsWith("Secondary Hand") || this.name.equals("Natural-Secondary")) {
                this.eq_item.addWeaponToLocation(this.qty, EquipmentLocation.EQUIPPED_SECONDARY, aPC);
            } else if (this.name.equals("Both Hands")) {
                this.eq_item.addWeaponToLocation(this.qty, EquipmentLocation.EQUIPPED_BOTH, aPC);
            } else if (this.name.equals("Double Weapon")) {
                this.eq_item.addWeaponToLocation(this.qty, EquipmentLocation.EQUIPPED_TWO_HANDS, aPC);
            } else if (this.name.equals("Unarmed")) {
                this.eq_item.addWeaponToLocation(this.qty, EquipmentLocation.EQUIPPED_NEITHER, aPC);
            } else if (this.name.equals("Two Weapons")) {
                Float quantity = Float.valueOf(this.qty.doubleValue() < 2.0 ? 2.0f : this.qty.floatValue());
                this.setQty(quantity);
                this.eq_item.addWeaponToLocation(quantity, EquipmentLocation.EQUIPPED_TWO_HANDS, aPC);
            } else if (this.name.equals("Shield")) {
                this.eq_item.addWeaponToLocation(this.qty, EquipmentLocation.EQUIPPED_NEITHER, aPC);
            }
        } else {
            this.eq_item.addEquipmentToLocation(this.qty, EquipmentLocation.EQUIPPED_NEITHER, true, aPC);
        }
    }

    public void addNoteToItem() {
        String aNote = this.getNote();
        if (aNote != null && aNote.length() > 0) {
            this.getItem().setNote(aNote);
        }
    }

    public boolean isPartOf(String rootId) {
        String abCalcId = rootId + ".";
        String abParentId = this.getParentIdPath() + ".";
        return abParentId.startsWith(abCalcId);
    }
}

