/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core;

import java.util.ArrayList;
import java.util.List;
import pcgen.base.lang.StringUtil;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.Categorized;
import pcgen.cdom.base.Category;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.enumeration.Type;
import pcgen.core.Description;
import pcgen.core.Globals;
import pcgen.core.PObject;
import pcgen.core.utils.MessageType;
import pcgen.core.utils.ShowMessageDelegate;
import pcgen.facade.core.AbilityFacade;
import pcgen.persistence.lst.output.prereq.PrerequisiteWriter;

public final class Ability
extends PObject
implements Categorized<Ability>,
AbilityFacade {
    public String getCategory() {
        return this.get(ObjectKey.ABILITY_CAT).getKeyName();
    }

    @Override
    public Ability clone() {
        try {
            return (Ability)super.clone();
        }
        catch (CloneNotSupportedException e) {
            ShowMessageDelegate.showMessageDialog(e.getMessage(), "PCGen", MessageType.ERROR);
            return null;
        }
    }

    @Override
    public String getPCCText() {
        StringBuilder txt = new StringBuilder(200);
        txt.append(this.getDisplayName());
        txt.append("\tCATEGORY:").append(this.getCategory());
        txt.append("\t");
        txt.append((CharSequence)StringUtil.joinToStringBuilder(Globals.getContext().unparse(this), (String)"\t"));
        txt.append("\t");
        txt.append(PrerequisiteWriter.prereqsToString(this));
        return txt.toString();
    }

    @Override
    public int compareTo(Object obj) {
        if (obj != null) {
            try {
                int diff;
                Ability ab = (Ability)obj;
                Category<Ability> cat = this.getCDOMCategory();
                Category<Ability> othercat = ab.getCDOMCategory();
                if (cat == null && othercat != null) {
                    return -1;
                }
                if (cat != null && othercat == null) {
                    return 1;
                }
                if (cat != null && (diff = cat.getKeyName().compareTo(othercat.getKeyName())) != 0) {
                    return diff;
                }
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
            return this.getKeyName().compareToIgnoreCase(((CDOMObject)obj).getKeyName());
        }
        return 1;
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof Ability && this.compareTo(other) == 0;
    }

    public int hashCode() {
        return this.getKeyName().hashCode();
    }

    @Override
    public Category<Ability> getCDOMCategory() {
        return this.get(ObjectKey.ABILITY_CAT);
    }

    @Override
    public void setCDOMCategory(Category<Ability> cat) {
        this.put(ObjectKey.ABILITY_CAT, cat);
    }

    @Override
    public ListKey<Description> getDescriptionKey() {
        return ListKey.DESCRIPTION;
    }

    @Override
    public List<String> getTypes() {
        List<Type> trueTypeList = this.getTrueTypeList(true);
        ArrayList<String> typeNames = new ArrayList<String>();
        for (Type type : trueTypeList) {
            typeNames.add(type.toString());
        }
        return typeNames;
    }

    @Override
    public boolean isMult() {
        return this.getSafe(ObjectKey.MULTIPLE_ALLOWED);
    }

    @Override
    public boolean isStackable() {
        return this.getSafe(ObjectKey.STACKS);
    }

    @Override
    public double getCost() {
        return this.getSafe(ObjectKey.SELECTION_COST).doubleValue();
    }
}

