/*
 * Decompiled with CFR 0.152.
 */
package gmgen.plugin;

import gmgen.plugin.Combatant;
import gmgen.plugin.Dice;
import gmgen.plugin.InitHolder;
import gmgen.plugin.InitHolderComperator;
import gmgen.plugin.State;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import pcgen.core.SettingsHandler;

public class InitHolderList
extends ArrayList<InitHolder> {
    public int getMaxInit() {
        int maxInit = 20;
        for (InitHolder c : this) {
            int cInit = c.getInitiative().getCurrentInitiative();
            if (cInit <= maxInit) continue;
            maxInit = cInit;
        }
        return maxInit;
    }

    public Vector<Object> getRowVector(int i, List<String> columnOrder) {
        return ((InitHolder)this.get(i)).getRowVector(columnOrder);
    }

    public String getUniqueName(String name) {
        int i = 1;
        String workingName = name;
        while (!this.isUniqueName(workingName)) {
            workingName = workingName.replaceAll(" \\(\\d.*\\)", "") + " (" + i + ")";
            ++i;
        }
        return workingName;
    }

    public boolean isUniqueName(String name) {
        for (InitHolder c : this) {
            if (!c.getName().equals(name)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean add(InitHolder user) {
        boolean result = super.add(user);
        if (result) {
            this.sort();
        }
        return result;
    }

    public void calculateNumberField() {
        int j = 1;
        for (InitHolder c : this) {
            if (!(c instanceof Combatant)) continue;
            Combatant cbt = (Combatant)c;
            cbt.setNumber(j);
            ++j;
        }
    }

    public void check() {
        Dice d20 = new Dice(1, 20);
        boolean pcroll = SettingsHandler.getGMGenOption("Initiative.rollPCInitiatives", true);
        for (InitHolder c : this) {
            Combatant com;
            int roll = d20.roll();
            boolean doroll = true;
            if (!pcroll && c instanceof Combatant && (com = (Combatant)c).getCombatantType().equals("PC")) {
                doroll = false;
            }
            if (doroll) {
                c.getInitiative().checkExtRoll(roll);
                continue;
            }
            c.getInitiative().resetCurrentInitiative();
        }
        this.sort();
        this.calculateNumberField();
    }

    public boolean initValid(int init) {
        for (InitHolder c : this) {
            int cInit;
            if (c.getStatus() == State.Dead || (cInit = c.getInitiative().getCurrentInitiative()) != init) continue;
            return true;
        }
        return false;
    }

    public void sort() {
        Collections.sort(this, new InitHolderComperator());
    }
}

