/*
 * Decompiled with CFR 0.152.
 */
package plugin.pretokens.parser;

import pcgen.core.prereq.Prerequisite;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.prereq.AbstractPrerequisiteListParser;
import pcgen.persistence.lst.prereq.PrerequisiteParserInterface;

public class PreWeaponProfParser
extends AbstractPrerequisiteListParser
implements PrerequisiteParserInterface {
    public String[] kindsHandled() {
        return new String[]{"WEAPONPROF"};
    }

    public Prerequisite parse(String kind, String formula, boolean invertResult, boolean overrideQualify) throws PersistenceLayerException {
        Prerequisite prereq = super.parse(kind, formula, invertResult, overrideQualify);
        this.doTypeInvertFixUp(prereq);
        return prereq;
    }

    private void doTypeInvertFixUp(Prerequisite prereq) {
        if ("weaponprof".equalsIgnoreCase(prereq.getKind())) {
            if (prereq.getKey().startsWith("TYPE")) {
                prereq.setCountMultiples(true);
            } else if (prereq.getKey().startsWith("[")) {
                int length = prereq.getKey().length() - 1;
                int rBracket = prereq.getKey().lastIndexOf(93);
                int endIndex = Math.max(length, rBracket);
                String key = prereq.getKey().substring(1, endIndex);
                prereq.setKey(key);
                prereq.setOperator(prereq.getOperator().invert());
            }
        }
        for (Prerequisite subReq : prereq.getPrerequisites()) {
            this.doTypeInvertFixUp(subReq);
        }
    }

    protected boolean allowsNegate() {
        return true;
    }
}

