/*
 * Decompiled with CFR 0.152.
 */
package plugin.dicebag.gui;

import java.awt.Color;
import java.awt.Component;
import java.io.File;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JDesktopPane;
import javax.swing.JOptionPane;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import pcgen.core.SettingsHandler;
import plugin.dicebag.gui.DiceBagMessage;
import plugin.dicebag.gui.DiceBagModel;
import plugin.dicebag.gui.DiceBagPluginController;
import plugin.dicebag.gui.DiceBagPluginModel;
import plugin.dicebag.gui.DiceBagView;

public class DiceBagPluginView
implements Observer {
    private DiceBagPluginModel m_model;
    private InternalFrameAdapter listener = new ChildListener();
    private JDesktopPane theDesktop = null;
    private int newX = 0;
    private int newY = 0;

    public DiceBagPluginView(DiceBagPluginModel o) {
        o.addObserver(this);
        this.m_model = o;
        this.initComponents();
    }

    public Component getMainComponent() {
        return this.theDesktop;
    }

    public void closeAll() {
        Component[] frames = this.theDesktop.getComponents();
        StringBuilder files = new StringBuilder();
        for (int i = 0; i < frames.length; ++i) {
            if (!(frames[i] instanceof DiceBagView)) continue;
            DiceBagModel bag = ((DiceBagView)frames[i]).getBag();
            this.askSaveBag(bag, 0);
            if (bag.isChanged() || bag.isBagEmpty()) continue;
            files.append(bag.getFilePath() + "|");
        }
        SettingsHandler.setGMGenOption((String)"DiceBagcloseFiles", (String)files.toString());
    }

    public void internalFrameActivated(InternalFrameEvent e) {
        if (e.getInternalFrame() != null && e.getInternalFrame() instanceof DiceBagView) {
            this.m_model.setActiveBag(((DiceBagView)e.getInternalFrame()).getBag());
        }
    }

    public void internalFrameClosed(InternalFrameEvent e) {
        if (e.getInternalFrame() != null && e.getInternalFrame() instanceof DiceBagView) {
            this.m_model.closeDiceBag(((DiceBagView)e.getInternalFrame()).getBag());
        }
    }

    public void internalFrameClosing(InternalFrameEvent e) {
        if (e.getInternalFrame() != null && e.getInternalFrame() instanceof DiceBagView) {
            int answer = this.askSaveBag(((DiceBagView)e.getInternalFrame()).getBag(), 1);
            if (answer == 2) {
                e.getInternalFrame().setDefaultCloseOperation(0);
            } else if (answer == 1 && answer == 0) {
                e.getInternalFrame().setDefaultCloseOperation(1);
            }
        }
    }

    @Override
    public void update(Observable o, Object arg) {
        if (o != null && o instanceof DiceBagPluginModel && arg != null && arg instanceof DiceBagMessage) {
            DiceBagMessage msg = (DiceBagMessage)arg;
            switch (msg.getType()) {
                case 8: {
                    this.allDiceBagsRemoved();
                    break;
                }
                case 2: {
                    this.diceBagAdded(msg.getDiceBag());
                    break;
                }
                case 4: {
                    this.diceBagRemoved(msg.getDiceBag());
                    break;
                }
                case 64: {
                    this.diceBagSaved(msg.getDiceBag());
                    break;
                }
                case 1: {
                    this.modelInitialized();
                    break;
                }
            }
        }
    }

    private void allDiceBagsRemoved() {
        Component[] frames = this.theDesktop.getComponents();
        for (int i = 0; i < frames.length; ++i) {
            if (!(frames[i] instanceof DiceBagView)) continue;
            ((DiceBagView)frames[i]).hide();
        }
    }

    private int askSaveBag(DiceBagModel bag, int option) {
        int returnValue = 2;
        if (bag.isChanged()) {
            returnValue = JOptionPane.showConfirmDialog(this.getMainComponent(), "Do you want to save your changes to dicebag " + bag.getName() + "?", "Save?", option);
            if (returnValue == 0) {
                if (bag.getFilePath() != null && bag.getFilePath().length() > 0) {
                    this.m_model.saveDiceBag(bag);
                } else {
                    File saveFile = DiceBagPluginController.chooseSaveFile(bag);
                    if (saveFile != null) {
                        this.m_model.saveDiceBag(bag, saveFile);
                    } else {
                        returnValue = 2;
                    }
                }
            }
        } else {
            returnValue = 1;
        }
        return returnValue;
    }

    private void diceBagAdded(DiceBagModel model) {
        DiceBagView view = new DiceBagView(model);
        view.addInternalFrameListener(this.listener);
        this.theDesktop.add(view);
        view.setLocation(this.newX, this.newY);
        this.newX += 20;
        this.newY += 20;
        if (!this.theDesktop.getBounds().contains(this.newX + 40, this.newY + 40)) {
            this.newX = 0;
            this.newY = 0;
        }
        view.setVisible(true);
    }

    private void diceBagRemoved(DiceBagModel model) {
        Component[] frames = this.theDesktop.getComponents();
        for (int i = 0; i < frames.length; ++i) {
            if (!(frames[i] instanceof DiceBagView) || ((DiceBagView)frames[i]).getBag() != model) continue;
            ((DiceBagView)frames[i]).hide();
        }
    }

    private void diceBagSaved(DiceBagModel model) {
    }

    private void initComponents() {
        this.theDesktop = new JDesktopPane();
        this.theDesktop.setBackground(Color.LIGHT_GRAY);
    }

    private void modelInitialized() {
    }

    private class ChildListener
    extends InternalFrameAdapter {
        private ChildListener() {
        }

        @Override
        public void internalFrameActivated(InternalFrameEvent e) {
            DiceBagPluginView.this.internalFrameActivated(e);
        }

        @Override
        public void internalFrameClosed(InternalFrameEvent e) {
            DiceBagPluginView.this.internalFrameClosed(e);
        }

        @Override
        public void internalFrameClosing(InternalFrameEvent e) {
            DiceBagPluginView.this.internalFrameClosing(e);
        }
    }
}

