/////////////////////////////////////////////////////////////////////////////
//
// Format: XA2
//
// Used by: Extreme-G 3, possibly other PS2
//
/////////////////////////////////////////////////////////////////////////////

#include "headers.h"

#include "fmt.h"
#include "rip.h"

/////////////////////////////////////////////////////////////////////////////

int fmt_xa2_detect(FILE *inf, const char *ext) {
  int score = 50;

  // base the entire test on the file extension for now
  if(!strcasecmp(ext, "xa2")) return 90;

  return score;
}

/////////////////////////////////////////////////////////////////////////////

int fmt_xa2_rip(
  FILE *inf,
  struct OPTIONS *opts
) {
  int errors = 0;
  uint8 hdr[0x800];
  struct OPTIONS myopts;
  uint32 streams;
  uint32 interleave;
  uint32 sn;
  long startpos;
  const char *orig_outname;

  if(opts) { memcpy(&myopts, opts, sizeof(myopts)); }
  else { memset(&myopts, 0, sizeof(myopts)); }

  orig_outname = myopts.outname;
  if(!orig_outname) orig_outname = "out";

  // get the header
  memset(hdr, 0, sizeof(hdr));
  fread(hdr, 1, 0x800, inf);
  startpos = ftell(inf);

  streams    = get32lsb(hdr);
  interleave = get32lsb(hdr + 4);
  if(streams < 1) {
    printf("invalid stream count present: %d\n", streams);
    return 1;
  }
  if(
    (!interleave) ||
    (interleave & (interleave - 1))
  ) {
    printf("invalid interleave value present: 0x%X\n", interleave);
    return 1;
  }

  if(!myopts.use_channels) {
    myopts.use_channels = 1;
    myopts.channels = (streams >= 2) ? 2 : 1;
  }
  if(!myopts.use_honor_endflag) {
    myopts.use_honor_endflag = 1;
    myopts.honor_endflag = 1;
  }
  if(!myopts.use_samplerate) {
    myopts.use_samplerate = 1;
    myopts.samplerate = 44100;
  }
  if(!myopts.use_interleave) {
    myopts.use_interleave = 1;
    myopts.interleave = interleave;
  }

  for(sn = 0; sn < streams; sn += myopts.channels) {
    char *myoutname = malloc(strlen(orig_outname) + 20);
    if(!myoutname) {
      printf("unable to allocate string\n");
      errors++;
      break;
    }
    sprintf(myoutname, "%s%d", orig_outname, sn);

    myopts.outname = myoutname;

    // if there's only one stream left, rip it as a mono
    if(sn == (streams - 1)) myopts.channels = 1;

    // seek to the appropriate spot
    fseek(inf, startpos + sn * myopts.interleave, SEEK_SET);

    // set the appropriate skip value to skip over the other streams
    myopts.use_skip = 1;
    myopts.skip = (streams - myopts.channels) * myopts.interleave;

    errors += rip(inf, &myopts, NULL);

    free(myoutname);
  }

  return errors;
}

/////////////////////////////////////////////////////////////////////////////
