/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.dialogs.core.pane.form;

import com.jgoodies.common.base.Preconditions;
import com.jgoodies.common.jsdl.action.AbstractMnemonicAction;
import com.jgoodies.components.util.TextComponentUtils;
import com.jgoodies.dialogs.core.CommandValue;
import com.jgoodies.dialogs.core.MessageType;
import com.jgoodies.dialogs.core.pane.AbstractStyledPane;
import com.jgoodies.dialogs.core.pane.AbstractStyledPaneVisualConfiguration;
import com.jgoodies.dialogs.core.pane.form.AbstractFormPaneModel;
import com.jgoodies.dialogs.core.pane.form.FormPaneModel;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.util.EventObject;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class FormPane
extends AbstractStyledPane<AbstractStyledPaneVisualConfiguration> {
    private static final String UI_CLASS_ID = "JSDL.FormPaneUI";

    public FormPane() {
        this((JComponent)new JLabel("A FormPane"), new DefaultFormPaneModel());
    }

    public FormPane(JComponent content, FormPaneModel model) {
        this(content, FormPane.createFormPaneActions(model));
        this.setCloseRequestHandler(model);
    }

    protected FormPane(JComponent content, Object[] commitObjects) {
        super(MessageType.PLAIN, content, Preconditions.checkNotNullOrEmpty(commitObjects, "The %s must not be null or empty.", "commitObjects"));
        this.setCancelCommand(commitObjects[1]);
        this.updateUI();
    }

    protected static Object[] createFormPaneActions(FormPaneModel model) {
        Object[] objectArray;
        if (model == null) {
            return new CommandValue[]{CommandValue.OK, CommandValue.CANCEL};
        }
        FormPaneAction acceptAction = new FormPaneAction(CommandValue.OK, model);
        FormPaneAction cancelAction = new FormPaneAction(CommandValue.CANCEL, model);
        if (model.isApplyVisible()) {
            Action[] actionArray = new Action[3];
            actionArray[0] = acceptAction;
            actionArray[1] = cancelAction;
            objectArray = actionArray;
            actionArray[2] = new FormPaneAction(CommandValue.APPLY, model);
        } else {
            Object[] objectArray2 = new Action[2];
            objectArray2[0] = acceptAction;
            objectArray = objectArray2;
            objectArray2[1] = cancelAction;
        }
        return objectArray;
    }

    @Override
    protected String layoutGroup() {
        return "FormPane";
    }

    @Override
    public String getUIClassID() {
        return UI_CLASS_ID;
    }

    protected static final class DefaultFormPaneModel
    extends AbstractFormPaneModel {
        protected DefaultFormPaneModel() {
            super(CommandValue.OK);
        }

        @Override
        public void onAcceptPerformed(ActionEvent e) {
        }

        @Override
        public void onApplyPerformed(ActionEvent e) {
        }

        @Override
        public void onPaneClosing(EventObject e, Runnable postOperation) {
            postOperation.run();
        }
    }

    static final class FormPaneAction
    extends AbstractMnemonicAction {
        private final CommandValue commandValue;
        private final FormPaneModel model;

        FormPaneAction(CommandValue commitValue, FormPaneModel model) {
            super(commitValue == CommandValue.OK ? model.getAcceptText() : commitValue.getMarkedText());
            this.commandValue = commitValue;
            this.model = model;
            if (commitValue == CommandValue.OK) {
                model.addPropertyChangeListener(this::onPropertyChange);
            } else if (commitValue == CommandValue.APPLY) {
                this.updateApplyEnablement();
                model.addPropertyChangeListener(this::onPropertyChange);
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TextComponentUtils.commitImmediately();
            if (this.commandValue == CommandValue.OK) {
                this.model.onAcceptPerformed(e);
            } else if (this.commandValue == CommandValue.CANCEL) {
                this.model.onCancelPerformed(e);
            } else if (this.commandValue == CommandValue.APPLY) {
                this.model.onApplyPerformed(e);
            } else {
                throw new IllegalStateException("unknown case");
            }
        }

        private void updateAcceptTextAndMnemonic() {
            this.setName(this.model.getAcceptText());
        }

        private void updateApplyEnablement() {
            this.setEnabled(this.model.isApplyEnabled());
        }

        private void onPropertyChange(PropertyChangeEvent evt) {
            String propertyName = evt.getPropertyName();
            if (this.commandValue == CommandValue.OK && (propertyName == null || propertyName.equals("acceptText"))) {
                this.updateAcceptTextAndMnemonic();
            }
            if (this.commandValue == CommandValue.APPLY && (propertyName == null || propertyName.equals("applyEnabled"))) {
                this.updateApplyEnablement();
            }
        }
    }
}

