/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.SQLException;
import java.sql.SQLInput;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Map;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.dbaccess.DBError;
import oracle.sql.ARRAY;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.CHAR;
import oracle.sql.CLOB;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.NUMBER;
import oracle.sql.RAW;
import oracle.sql.REF;
import oracle.sql.ROWID;
import oracle.sql.STRUCT;

public class OracleJdbc2SQLInput
implements SQLInput {
    private int index;
    private Datum[] attributes;
    private Map map;
    private OracleConnection conn;

    public OracleJdbc2SQLInput(Datum[] datumArray, Map map, OracleConnection oracleConnection) {
        this.attributes = datumArray;
        this.map = map;
        this.conn = oracleConnection;
        this.index = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readString() throws SQLException {
        String string = null;
        try {
            if (this.attributes[this.index] != null) {
                string = this.attributes[this.index].stringValue();
            }
            Object var3_2 = null;
            ++this.index;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            ++this.index;
            throw throwable;
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean readBoolean() throws SQLException {
        boolean bl = false;
        try {
            if (this.attributes[this.index] != null) {
                bl = this.attributes[this.index].booleanValue();
            }
            Object var3_2 = null;
            ++this.index;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            ++this.index;
            throw throwable;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte readByte() throws SQLException {
        byte by = 0;
        try {
            if (this.attributes[this.index] != null) {
                by = this.attributes[this.index].byteValue();
            }
            Object var3_2 = null;
            ++this.index;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            ++this.index;
            throw throwable;
        }
        return by;
    }

    public short readShort() throws SQLException {
        long l = this.readLong();
        if (l > 65537L || l < -65538L) {
            DBError.check_error(26, "readShort");
        }
        short s = (short)l;
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int readInt() throws SQLException {
        int n = 0;
        try {
            if (this.attributes[this.index] != null) {
                n = this.attributes[this.index].intValue();
            }
            Object var3_2 = null;
            ++this.index;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            ++this.index;
            throw throwable;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long readLong() throws SQLException {
        long l = 0L;
        try {
            if (this.attributes[this.index] != null) {
                l = this.attributes[this.index].longValue();
            }
            Object var4_2 = null;
            ++this.index;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            ++this.index;
            throw throwable;
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float readFloat() throws SQLException {
        float f = 0.0f;
        try {
            if (this.attributes[this.index] != null) {
                f = this.attributes[this.index].floatValue();
            }
            Object var3_2 = null;
            ++this.index;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            ++this.index;
            throw throwable;
        }
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double readDouble() throws SQLException {
        double d = 0.0;
        try {
            if (this.attributes[this.index] != null) {
                d = this.attributes[this.index].doubleValue();
            }
            Object var4_2 = null;
            ++this.index;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            ++this.index;
            throw throwable;
        }
        return d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BigDecimal readBigDecimal() throws SQLException {
        BigDecimal bigDecimal = null;
        try {
            if (this.attributes[this.index] != null) {
                bigDecimal = this.attributes[this.index].bigDecimalValue();
            }
            Object var3_2 = null;
            ++this.index;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            ++this.index;
            throw throwable;
        }
        return bigDecimal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] readBytes() throws SQLException {
        byte[] byArray = null;
        try {
            if (this.attributes[this.index] != null) {
                if (this.attributes[this.index] instanceof RAW) {
                    byArray = ((RAW)this.attributes[this.index]).shareBytes();
                } else {
                    DBError.check_error(4, null);
                }
            }
            Object var3_2 = null;
            ++this.index;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            ++this.index;
            throw throwable;
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date readDate() throws SQLException {
        Date date = null;
        try {
            if (this.attributes[this.index] != null) {
                date = this.attributes[this.index].dateValue();
            }
            Object var3_2 = null;
            ++this.index;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            ++this.index;
            throw throwable;
        }
        return date;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Time readTime() throws SQLException {
        Time time = null;
        try {
            if (this.attributes[this.index] != null) {
                time = this.attributes[this.index].timeValue();
            }
            Object var3_2 = null;
            ++this.index;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            ++this.index;
            throw throwable;
        }
        return time;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Timestamp readTimestamp() throws SQLException {
        Timestamp timestamp = null;
        try {
            if (this.attributes[this.index] != null) {
                timestamp = this.attributes[this.index].timestampValue();
            }
            Object var3_2 = null;
            ++this.index;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            ++this.index;
            throw throwable;
        }
        return timestamp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Reader readCharacterStream() throws SQLException {
        Reader reader = null;
        try {
            Datum datum = this.attributes[this.index];
            if (datum != null) {
                reader = datum.characterStreamValue();
            }
            Object var4_3 = null;
            ++this.index;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            ++this.index;
            throw throwable;
        }
        return reader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream readAsciiStream() throws SQLException {
        InputStream inputStream = null;
        try {
            Datum datum = this.attributes[this.index];
            if (datum != null) {
                inputStream = datum.asciiStreamValue();
            }
            Object var4_3 = null;
            ++this.index;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            ++this.index;
            throw throwable;
        }
        return inputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream readBinaryStream() throws SQLException {
        InputStream inputStream = null;
        try {
            Datum datum = this.attributes[this.index];
            if (datum != null) {
                inputStream = datum.binaryStreamValue();
            }
            Object var4_3 = null;
            ++this.index;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            ++this.index;
            throw throwable;
        }
        return inputStream;
    }

    public Object readObject() throws SQLException {
        Datum datum = (Datum)this.readOracleObject();
        if (datum != null) {
            if (datum instanceof STRUCT) {
                return ((STRUCT)datum).toJdbc(this.map);
            }
            datum.toJdbc();
        }
        return null;
    }

    public Ref readRef() throws SQLException {
        return this.readREF();
    }

    public Blob readBlob() throws SQLException {
        return this.readBLOB();
    }

    public Clob readClob() throws SQLException {
        return this.readCLOB();
    }

    public Array readArray() throws SQLException {
        return this.readARRAY();
    }

    public Struct readStruct() throws SQLException {
        return this.readSTRUCT();
    }

    public boolean wasNull() throws SQLException {
        if (this.index == 0) {
            DBError.throwSqlException(24);
        }
        boolean bl = this.attributes[this.index - 1] == null;
        return bl;
    }

    public Object readOracleObject() throws SQLException {
        Datum datum = this.attributes[this.index++];
        return datum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NUMBER readNUMBER() throws SQLException {
        NUMBER nUMBER = null;
        try {
            if (this.attributes[this.index] != null) {
                if (this.attributes[this.index] instanceof NUMBER) {
                    nUMBER = (NUMBER)this.attributes[this.index];
                } else {
                    DBError.check_error(4, null);
                }
            }
            Object var3_2 = null;
            ++this.index;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            ++this.index;
            throw throwable;
        }
        return nUMBER;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CHAR readCHAR() throws SQLException {
        CHAR cHAR = null;
        try {
            if (this.attributes[this.index] != null) {
                if (this.attributes[this.index] instanceof CHAR) {
                    cHAR = (CHAR)this.attributes[this.index];
                } else {
                    DBError.check_error(4, null);
                }
            }
            Object var3_2 = null;
            ++this.index;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            ++this.index;
            throw throwable;
        }
        return cHAR;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DATE readDATE() throws SQLException {
        DATE dATE = null;
        try {
            if (this.attributes[this.index] != null) {
                if (this.attributes[this.index] instanceof DATE) {
                    dATE = (DATE)this.attributes[this.index];
                } else {
                    DBError.check_error(4, null);
                }
            }
            Object var3_2 = null;
            ++this.index;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            ++this.index;
            throw throwable;
        }
        return dATE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BFILE readBFILE() throws SQLException {
        BFILE bFILE = null;
        try {
            if (this.attributes[this.index] != null) {
                if (this.attributes[this.index] instanceof BFILE) {
                    bFILE = (BFILE)this.attributes[this.index];
                } else {
                    DBError.check_error(4, null);
                }
            }
            Object var3_2 = null;
            ++this.index;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            ++this.index;
            throw throwable;
        }
        return bFILE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BLOB readBLOB() throws SQLException {
        BLOB bLOB = null;
        try {
            if (this.attributes[this.index] != null) {
                if (this.attributes[this.index] instanceof BLOB) {
                    bLOB = (BLOB)this.attributes[this.index];
                } else {
                    DBError.check_error(4, null);
                }
            }
            Object var3_2 = null;
            ++this.index;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            ++this.index;
            throw throwable;
        }
        return bLOB;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CLOB readCLOB() throws SQLException {
        CLOB cLOB = null;
        try {
            if (this.attributes[this.index] != null) {
                if (this.attributes[this.index] instanceof CLOB) {
                    cLOB = (CLOB)this.attributes[this.index];
                } else {
                    DBError.check_error(4, null);
                }
            }
            Object var3_2 = null;
            ++this.index;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            ++this.index;
            throw throwable;
        }
        return cLOB;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RAW readRAW() throws SQLException {
        RAW rAW = null;
        try {
            if (this.attributes[this.index] != null) {
                if (this.attributes[this.index] instanceof RAW) {
                    rAW = (RAW)this.attributes[this.index];
                } else {
                    DBError.check_error(4, null);
                }
            }
            Object var3_2 = null;
            ++this.index;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            ++this.index;
            throw throwable;
        }
        return rAW;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public REF readREF() throws SQLException {
        REF rEF = null;
        try {
            if (this.attributes[this.index] != null) {
                if (this.attributes[this.index] instanceof REF) {
                    rEF = (REF)this.attributes[this.index];
                } else {
                    DBError.check_error(4, null);
                }
            }
            Object var3_2 = null;
            ++this.index;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            ++this.index;
            throw throwable;
        }
        return rEF;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ROWID readROWID() throws SQLException {
        ROWID rOWID = null;
        try {
            if (this.attributes[this.index] != null) {
                if (this.attributes[this.index] instanceof ROWID) {
                    rOWID = (ROWID)this.attributes[this.index];
                } else {
                    DBError.check_error(4, null);
                }
            }
            Object var3_2 = null;
            ++this.index;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            ++this.index;
            throw throwable;
        }
        return rOWID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ARRAY readARRAY() throws SQLException {
        ARRAY aRRAY = null;
        try {
            if (this.attributes[this.index] != null) {
                if (this.attributes[this.index] instanceof ARRAY) {
                    aRRAY = (ARRAY)this.attributes[this.index];
                } else {
                    DBError.check_error(4, null);
                }
            }
            Object var3_2 = null;
            ++this.index;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            ++this.index;
            throw throwable;
        }
        return aRRAY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public STRUCT readSTRUCT() throws SQLException {
        STRUCT sTRUCT = null;
        try {
            if (this.attributes[this.index] != null) {
                if (this.attributes[this.index] instanceof STRUCT) {
                    sTRUCT = (STRUCT)this.attributes[this.index];
                } else {
                    DBError.check_error(4, null);
                }
            }
            Object var3_2 = null;
            ++this.index;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            ++this.index;
            throw throwable;
        }
        return sTRUCT;
    }

    public URL readURL() throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
        return null;
    }
}

