/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import net.sourceforge.pmd.PropertyDescriptor;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.RuleViolation;
import net.sourceforge.pmd.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.ast.ASTCompilationUnit;
import net.sourceforge.pmd.ast.ASTImportDeclaration;
import net.sourceforge.pmd.ast.JavaParserVisitorAdapter;
import net.sourceforge.pmd.ast.Node;
import net.sourceforge.pmd.ast.SimpleNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRule
extends JavaParserVisitorAdapter
implements Rule {
    private String name = this.getClass().getName();
    private Properties properties = new Properties();
    private String message;
    private String description;
    private List<String> examples = new ArrayList<String>();
    private String ruleSetName;
    private boolean include;
    private boolean usesDFA;
    private boolean usesTypeResolution;
    private int priority = 5;
    private String externalInfoUrl;
    private List<String> ruleChainVisits = new ArrayList<String>();
    private static final boolean inOldPropertyMode = true;

    protected static Map<String, PropertyDescriptor> asFixedMap(PropertyDescriptor[] descriptors) {
        HashMap<String, PropertyDescriptor> descsById = new HashMap<String, PropertyDescriptor>(descriptors.length);
        for (PropertyDescriptor descriptor : descriptors) {
            descsById.put(descriptor.name(), descriptor);
        }
        return Collections.unmodifiableMap(descsById);
    }

    protected static Map<String, PropertyDescriptor> asFixedMap(PropertyDescriptor descriptor) {
        return AbstractRule.asFixedMap(new PropertyDescriptor[]{descriptor});
    }

    @Override
    public String getRuleSetName() {
        return this.ruleSetName;
    }

    @Override
    public void setRuleSetName(String ruleSetName) {
        this.ruleSetName = ruleSetName;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public List<String> getExamples() {
        return this.examples;
    }

    @Override
    public String getExample() {
        if (this.examples.isEmpty()) {
            return null;
        }
        return this.examples.get(this.examples.size() - 1);
    }

    @Override
    public void addExample(String example) {
        this.examples.add(example);
    }

    @Override
    public boolean hasProperty(String name) {
        return this.properties.containsKey(name);
    }

    @Override
    public void addProperty(String name, String value) {
        this.properties.setProperty(name, value);
    }

    @Override
    public void addProperties(Properties properties) {
        this.properties.putAll((Map<?, ?>)properties);
    }

    public double[] getDoubleProperties(PropertyDescriptor descriptor) {
        Number[] values = (Number[])this.getProperties(descriptor);
        double[] doubles = new double[values.length];
        for (int i = 0; i < doubles.length; ++i) {
            doubles[i] = values[i].doubleValue();
        }
        return doubles;
    }

    @Override
    public double getDoubleProperty(String name) {
        return Double.parseDouble(this.properties.getProperty(name));
    }

    public double getDoubleProperty(PropertyDescriptor descriptor) {
        return ((Number)this.getProperty(descriptor)).doubleValue();
    }

    public int[] getIntProperties(PropertyDescriptor descriptor) {
        Number[] values = (Number[])this.getProperties(descriptor);
        int[] ints = new int[values.length];
        for (int i = 0; i < ints.length; ++i) {
            ints[i] = values[i].intValue();
        }
        return ints;
    }

    @Override
    public int getIntProperty(String name) {
        return Integer.parseInt(this.properties.getProperty(name));
    }

    public int getIntProperty(PropertyDescriptor descriptor) {
        return ((Number)this.getProperty(descriptor)).intValue();
    }

    public Class[] getTypeProperties(PropertyDescriptor descriptor) {
        return (Class[])this.getProperties(descriptor);
    }

    public Class getTypeProperty(PropertyDescriptor descriptor) {
        return (Class)this.getProperty(descriptor);
    }

    public boolean[] getBooleanProperties(PropertyDescriptor descriptor) {
        Boolean[] values = (Boolean[])this.getProperties(descriptor);
        boolean[] bools = new boolean[values.length];
        for (int i = 0; i < bools.length; ++i) {
            bools[i] = values[i];
        }
        return bools;
    }

    public boolean getBooleanProperty(PropertyDescriptor descriptor) {
        return (Boolean)this.getProperty(descriptor);
    }

    @Override
    public boolean getBooleanProperty(String name) {
        return Boolean.parseBoolean(this.properties.getProperty(name));
    }

    public void setBooleanProperty(String name, boolean flag) {
        this.properties.setProperty(name, Boolean.toString(flag));
    }

    public String[] getStringProperties(PropertyDescriptor descriptor) {
        return (String[])this.getProperties(descriptor);
    }

    @Override
    public String getStringProperty(String name) {
        return this.properties.getProperty(name);
    }

    public String getStringProperty(PropertyDescriptor descriptor) {
        return (String)this.getProperty(descriptor);
    }

    private Object getProperty(PropertyDescriptor descriptor) {
        String rawValue;
        if (descriptor.maxValueCount() > 1) {
            this.propertyGetError(descriptor, true);
        }
        return (rawValue = this.properties.getProperty(descriptor.name())) == null || rawValue.length() == 0 ? descriptor.defaultValue() : descriptor.valueFrom(rawValue);
    }

    public void setProperty(PropertyDescriptor descriptor, Object value) {
        if (descriptor.maxValueCount() > 1) {
            this.propertySetError(descriptor, true);
        }
        this.properties.setProperty(descriptor.name(), descriptor.asDelimitedString(value));
    }

    private Object[] getProperties(PropertyDescriptor descriptor) {
        String rawValue;
        if (descriptor.maxValueCount() == 1) {
            this.propertyGetError(descriptor, false);
        }
        return (rawValue = this.properties.getProperty(descriptor.name())) == null || rawValue.length() == 0 ? (Object[])descriptor.defaultValue() : (Object[])descriptor.valueFrom(rawValue);
    }

    public void setProperties(PropertyDescriptor descriptor, Object[] values) {
        if (descriptor.maxValueCount() == 1) {
            this.propertySetError(descriptor, false);
        }
        this.properties.setProperty(descriptor.name(), descriptor.asDelimitedString(values));
    }

    private void propertyGetError(PropertyDescriptor descriptor, boolean requestedSingleValue) {
        if (requestedSingleValue) {
            throw new RuntimeException("Cannot retrieve a single value from a multi-value property field");
        }
        throw new RuntimeException("Cannot retrieve multiple values from a single-value property field");
    }

    private void propertySetError(PropertyDescriptor descriptor, boolean setSingleValue) {
        if (setSingleValue) {
            throw new RuntimeException("Cannot set a single value within a multi-value property field");
        }
        throw new RuntimeException("Cannot set multiple values within a single-value property field");
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public void setMessage(String message) {
        this.message = message;
    }

    @Override
    public String getExternalInfoUrl() {
        return this.externalInfoUrl;
    }

    @Override
    public void setExternalInfoUrl(String url) {
        this.externalInfoUrl = url;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        Rule rule = null;
        boolean equality = this.getClass().getName().equals(o.getClass().getName());
        if (equality) {
            rule = (Rule)o;
            equality = this.getName().equals(rule.getName()) && this.getPriority() == rule.getPriority() && this.getProperties().equals(rule.getProperties());
        }
        return equality;
    }

    public int hashCode() {
        String s = this.getClass().getName() + this.getName() + this.getPriority() + this.getProperties().toString();
        return s.hashCode();
    }

    @Override
    public void apply(List acus, RuleContext ctx) {
        this.visitAll(acus, ctx);
    }

    @Override
    public Properties getProperties() {
        return this.properties;
    }

    @Override
    public boolean include() {
        return this.include;
    }

    @Override
    public void setInclude(boolean include) {
        this.include = include;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public String getPriorityName() {
        return PRIORITIES[this.getPriority() - 1];
    }

    @Override
    public void setPriority(int priority) {
        this.priority = priority;
    }

    @Override
    public void setUsesDFA() {
        this.usesDFA = true;
    }

    @Override
    public boolean usesDFA() {
        return this.usesDFA;
    }

    @Override
    public void setUsesTypeResolution() {
        this.usesTypeResolution = true;
    }

    @Override
    public boolean usesTypeResolution() {
        return this.usesTypeResolution;
    }

    protected void visitAll(List acus, RuleContext ctx) {
        for (ASTCompilationUnit node : acus) {
            this.visit(node, (Object)ctx);
        }
    }

    protected final void addViolation(Object data, SimpleNode node) {
        RuleContext ctx = (RuleContext)data;
        ctx.getReport().addRuleViolation(new RuleViolation(this, ctx, node));
    }

    protected final void addViolationWithMessage(Object data, SimpleNode node, String msg) {
        RuleContext ctx = (RuleContext)data;
        ctx.getReport().addRuleViolation(new RuleViolation(this, ctx, node, msg));
    }

    protected final void addViolation(Object data, SimpleNode node, String embed) {
        RuleContext ctx = (RuleContext)data;
        ctx.getReport().addRuleViolation(new RuleViolation(this, ctx, node, MessageFormat.format(this.getMessage(), embed)));
    }

    protected final void addViolation(Object data, Node node, Object[] args) {
        RuleContext ctx = (RuleContext)data;
        ctx.getReport().addRuleViolation(new RuleViolation(this, ctx, (SimpleNode)node, MessageFormat.format(this.getMessage(), args)));
    }

    protected final String getDeclaringType(SimpleNode node) {
        ASTClassOrInterfaceDeclaration c = node.getFirstParentOfType(ASTClassOrInterfaceDeclaration.class);
        if (c != null) {
            return c.getImage();
        }
        return null;
    }

    public static boolean isQualifiedName(SimpleNode node) {
        return node.getImage().indexOf(46) != -1;
    }

    public static boolean importsPackage(ASTCompilationUnit node, String packageName) {
        List<ASTImportDeclaration> nodes = node.findChildrenOfType(ASTImportDeclaration.class);
        for (ASTImportDeclaration n : nodes) {
            if (!n.getPackageName().startsWith(packageName)) continue;
            return true;
        }
        return false;
    }

    protected Map<String, PropertyDescriptor> propertiesByName() {
        return Collections.emptyMap();
    }

    @Override
    public PropertyDescriptor propertyDescriptorFor(String propertyName) {
        PropertyDescriptor desc = this.propertiesByName().get(propertyName);
        if (desc == null) {
            throw new IllegalArgumentException("unknown property: " + propertyName);
        }
        return desc;
    }

    @Override
    public boolean usesRuleChain() {
        return !this.getRuleChainVisits().isEmpty();
    }

    @Override
    public List<String> getRuleChainVisits() {
        return this.ruleChainVisits;
    }

    @Override
    public void addRuleChainVisit(String astNodeName) {
        if (!this.ruleChainVisits.contains(astNodeName)) {
            this.ruleChainVisits.add(astNodeName);
        }
    }
}

