/*
 * Decompiled with CFR 0.152.
 */
package megamek.common;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import megamek.common.AmmoType;
import megamek.common.BombType;
import megamek.common.Engine;
import megamek.common.Entity;
import megamek.common.EquipmentMessages;
import megamek.common.EquipmentMode;
import megamek.common.MiscType;
import megamek.common.Mounted;
import megamek.common.TechConstants;
import megamek.common.WeaponType;
import megamek.debug.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EquipmentType {
    public static final float TONNAGE_VARIABLE = Float.MIN_VALUE;
    public static final int CRITICALS_VARIABLE = Integer.MIN_VALUE;
    public static final int BV_VARIABLE = Integer.MIN_VALUE;
    public static final int COST_VARIABLE = Integer.MIN_VALUE;
    public static final int T_ARMOR_UNKNOWN = -1;
    public static final int T_ARMOR_STANDARD = 0;
    public static final int T_ARMOR_FERRO_FIBROUS = 1;
    public static final int T_ARMOR_REACTIVE = 2;
    public static final int T_ARMOR_REFLECTIVE = 3;
    public static final int T_ARMOR_HARDENED = 4;
    public static final int T_ARMOR_LIGHT_FERRO = 5;
    public static final int T_ARMOR_HEAVY_FERRO = 6;
    public static final int T_ARMOR_PATCHWORK = 7;
    public static final int T_ARMOR_STEALTH = 8;
    public static final int T_ARMOR_FERRO_FIBROUS_PROTO = 9;
    public static final int T_ARMOR_COMMERCIAL = 10;
    public static final int T_ARMOR_FERRO_CARBIDE = 11;
    public static final int T_ARMOR_LAMELLOR_FERRO_CARBIDE = 12;
    public static final int T_ARMOR_FERRO_IMP = 13;
    public static final int T_ARMOR_INDUSTRIAL = 14;
    public static final int T_ARMOR_HEAVY_INDUSTRIAL = 15;
    public static final int T_STRUCTURE_UNKNOWN = -1;
    public static final int T_STRUCTURE_STANDARD = 0;
    public static final int T_STRUCTURE_ENDO_STEEL = 1;
    public static final int T_STRUCTURE_ENDO_PROTOTYPE = 2;
    public static final int T_STRUCTURE_REINFORCED = 3;
    public static final int T_STRUCTURE_COMPOSITE = 4;
    public static final int T_STRUCTURE_INDUSTRIAL = 5;
    public static final String[] armorNames = new String[]{"Standard", "Ferro-Fibrous", "Reactive", "Reflective", "Hardened", "Light Ferro-Fibrous", "Heavy Ferro-Fibrous", "Patchwork", "Stealth", "Ferro-Fibrous Prototype", "Commercial", "Ferro-Carbide", "Lamellor Ferro-Carbide", "Improved Ferro-Aluminum", "Industrial", "Heavy Industrial"};
    public static final String[] structureNames = new String[]{"Standard", "Endo Steel", "Endo Steel Prototype", "Reinforced", "Composite", "Industrial"};
    public static final int[] structureLevels = new int[]{1, 2, 3, 3, 3};
    public static final double[] structureCosts = new double[]{400.0, 1600.0, 1600.0, 6400.0, 3200.0, 300.0};
    public static final double[] armorCosts = new double[]{10000.0, 20000.0, 30000.0, 30000.0, 15000.0, 15000.0, 25000.0, 50000.0, 50000.0, 20000.0, 3000.0, 75000.0, 100000.0, 50000.0, 5000.0, 10000.0};
    public static final double[] armorPointMultipliers = new double[]{1.0, 1.12, 1.0, 1.0, 1.0, 1.06, 1.24, 1.0, 1.0, 1.12, 1.5, 1.0, 1.0, 1.0, 0.67, 1.0};
    public static final double POINT_MULTIPLIER_UNKNOWN = 1.0;
    public static final double POINT_MULTIPLIER_CLAN_FF = 1.2;
    protected String name = null;
    protected String internalName = null;
    private Vector<String> namesVector = new Vector();
    protected float tonnage = 0.0f;
    protected int criticals = 0;
    protected boolean explosive = false;
    protected boolean hittable = true;
    protected boolean spreadable = false;
    protected int toHitModifier = 0;
    protected int techLevel = -1;
    protected long flags = 0L;
    protected long subType = 0L;
    protected double bv = 0.0;
    protected double cost = 0.0;
    protected Vector<EquipmentMode> modes = null;
    protected boolean instantModeSwitch = true;
    public Vector<String> endTurnModes = new Vector();
    protected static Vector<EquipmentType> allTypes;
    protected static Hashtable<String, EquipmentType> lookupHash;

    public void setFlags(long l) {
        this.flags = l;
    }

    public void setSubType(int n) {
        this.subType = n;
    }

    public void addSubType(int n) {
        this.subType |= (long)n;
    }

    public boolean hasSubType(long l) {
        return (this.subType & l) != 0L;
    }

    public String getName() {
        return this.name;
    }

    public String getDesc() {
        String string = EquipmentMessages.getString("EquipmentType." + this.name);
        if (string != null) {
            return string;
        }
        return this.name;
    }

    public String getInternalName() {
        return this.internalName;
    }

    public int getTechLevel() {
        return this.techLevel;
    }

    public float getTonnage(Entity entity) {
        return this.tonnage;
    }

    public void setTonnage(float f) {
        this.tonnage = f;
    }

    public int getCriticals(Entity entity) {
        return this.criticals;
    }

    public boolean isExplosive() {
        return this.explosive;
    }

    public boolean isHittable() {
        return this.hittable;
    }

    public boolean isSpreadable() {
        return this.spreadable;
    }

    public int getToHitModifier() {
        return this.toHitModifier;
    }

    public long getFlags() {
        return this.flags;
    }

    public boolean hasFlag(long l) {
        return (this.flags & l) != 0L;
    }

    public double getBV(Entity entity) {
        return this.bv;
    }

    public boolean hasModes() {
        return this.modes != null;
    }

    public int getModesCount() {
        if (this.modes != null) {
            return this.modes.size();
        }
        return 0;
    }

    public Enumeration<EquipmentMode> getModes() {
        if (this.modes != null) {
            return this.modes.elements();
        }
        return new Enumeration<EquipmentMode>(){

            @Override
            public boolean hasMoreElements() {
                return false;
            }

            @Override
            public EquipmentMode nextElement() {
                return null;
            }
        };
    }

    protected void setModes(String[] stringArray) {
        Assert.assertTrue(stringArray != null && stringArray.length >= 0, "List of modes must not be null or empty");
        if (stringArray != null) {
            Vector<EquipmentMode> vector = new Vector<EquipmentMode>(stringArray.length);
            for (String string : stringArray) {
                vector.addElement(EquipmentMode.getMode(string));
            }
            this.modes = vector;
        } else {
            this.modes = new Vector(0);
        }
    }

    public void addEndTurnMode(String string) {
        this.endTurnModes.add(string);
    }

    public boolean isNextTurnModeSwitch(String string) {
        for (String string2 : this.endTurnModes) {
            if (!string2.equals(string)) continue;
            return true;
        }
        return false;
    }

    public EquipmentMode getMode(int n) {
        Assert.assertTrue(this.modes != null && n >= 0 && n < this.modes.size());
        return this.modes.elementAt(n);
    }

    public void setInstantModeSwitch(boolean bl) {
        this.instantModeSwitch = bl;
    }

    public boolean hasInstantModeSwitch() {
        return this.instantModeSwitch;
    }

    public void setInternalName(String string) {
        this.internalName = string;
        this.addLookupName(string);
    }

    public void addLookupName(String string) {
        lookupHash.put(string.toLowerCase(), this);
        this.namesVector.addElement(string);
    }

    public static EquipmentType get(String string) {
        if (null == lookupHash) {
            EquipmentType.initializeTypes();
        }
        return lookupHash.get(string.toLowerCase().trim());
    }

    public Enumeration<String> getNames() {
        return this.namesVector.elements();
    }

    public static void initializeTypes() {
        if (null == allTypes) {
            allTypes = new Vector();
            lookupHash = new Hashtable();
            WeaponType.initializeTypes();
            AmmoType.initializeTypes();
            MiscType.initializeTypes();
            BombType.initializeTypes();
        }
    }

    public static Enumeration<EquipmentType> getAllTypes() {
        if (null == allTypes) {
            EquipmentType.initializeTypes();
        }
        return allTypes.elements();
    }

    protected static void addType(EquipmentType equipmentType) {
        if (null == allTypes) {
            EquipmentType.initializeTypes();
        }
        allTypes.addElement(equipmentType);
    }

    public static int getArmorType(String string) {
        EquipmentType equipmentType = EquipmentType.get(string);
        if (equipmentType != null) {
            for (int i = 0; i < armorNames.length; ++i) {
                if (!armorNames[i].equals(equipmentType.getInternalName())) continue;
                return i;
            }
        }
        return -1;
    }

    public static String getArmorTypeName(int n) {
        if (n < 0 || n >= armorNames.length) {
            return "UNKNOWN";
        }
        return armorNames[n];
    }

    public static int getStructureType(String string) {
        EquipmentType equipmentType = EquipmentType.get(string);
        if (equipmentType != null) {
            for (int i = 0; i < structureNames.length; ++i) {
                if (!structureNames[i].equals(equipmentType.getInternalName())) continue;
                return i;
            }
        }
        return -1;
    }

    public static String getStructureTypeName(int n) {
        if (n < 0 || n >= structureNames.length) {
            return "UNKNOWN";
        }
        return structureNames[n];
    }

    public double getCost(Entity entity, boolean bl) {
        return this.cost;
    }

    public static double getArmorCost(int n) {
        if (n < 0 || n >= armorCosts.length) {
            return -1.0;
        }
        return armorCosts[n];
    }

    public static double getStructureCost(int n) {
        if (n < 0 || n >= structureCosts.length) {
            return -1.0;
        }
        return structureCosts[n];
    }

    public static double getArmorPointMultiplier(int n) {
        return EquipmentType.getArmorPointMultiplier(n, 1);
    }

    public static double getArmorPointMultiplier(int n, int n2) {
        return EquipmentType.getArmorPointMultiplier(n, n2 == 2 || n2 == 6 || n2 == 8 || n2 == 10);
    }

    public static double getArmorPointMultiplier(int n, boolean bl) {
        if (n < 0 || n >= armorPointMultipliers.length) {
            return 1.0;
        }
        if (n == 1 && bl) {
            return 1.2;
        }
        return armorPointMultipliers[n];
    }

    public int resolveVariableCost(Entity entity, boolean bl) {
        int n = 0;
        if (this instanceof MiscType) {
            if (this.hasFlag(16L)) {
                if (this.hasSubType(1L)) {
                    Engine engine = entity.getEngine();
                    n = engine == null ? 0 : engine.getRating() * 10000;
                } else {
                    int n2 = 0;
                    if (this.getInternalName().equals("ISMASC")) {
                        n2 = Math.round(entity.getWeight() / 20.0f);
                    } else if (this.getInternalName().equals("CLMASC")) {
                        n2 = Math.round(entity.getWeight() / 25.0f);
                    }
                    n = entity.getEngine().getRating() * n2 * 1000;
                }
            } else if (this.hasFlag(1024L)) {
                int n3 = 0;
                float f = 0.0f;
                for (Mounted mounted : entity.getWeaponList()) {
                    WeaponType weaponType = (WeaponType)mounted.getType();
                    if (!weaponType.hasFlag(1L)) continue;
                    f += weaponType.getTonnage(entity);
                }
                if (this.getInternalName().equals("ISTargeting Computer")) {
                    n3 = (int)Math.ceil(f / 4.0f);
                } else if (this.getInternalName().equals("CLTargeting Computer")) {
                    n3 = (int)Math.ceil(f / 5.0f);
                }
                n = n3 * 10000;
            } else if (this.hasFlag(0x2000000L) && (this.hasSubType(4L) || this.hasSubType(16L))) {
                int n4 = (int)Math.ceil((double)entity.getWeight() / 15.0);
                n = n4 * 5000;
            } else if (this.hasFlag(0x2000000L) && this.hasSubType(8L)) {
                int n5 = (int)Math.ceil((double)entity.getWeight() / 15.0);
                n = n5 * 10000;
            } else if (this.hasFlag(0x2000000L) && this.hasSubType(0x800000L)) {
                int n6 = (int)Math.ceil(0.5 + Math.ceil((double)entity.getWeight() / 20.0));
                n = (1 + n6) * 10000;
            } else if (this.hasFlag(0x200000000000000L)) {
                n = (int)Math.ceil((float)(500 * entity.getEngine().getRating()) * entity.getWeight() / 75.0f);
            } else if (this.hasFlag(0x400000000000L)) {
                n = (int)Math.ceil(this.getTonnage(entity) * 300.0f);
            }
        } else if (n == 0) {
            System.out.println("I don't know how much " + this.name + " costs.");
        }
        if (bl) {
            n += 150000 * this.getCriticals(entity);
        }
        return n;
    }

    public boolean equals(EquipmentType equipmentType) {
        return equipmentType != null && this.internalName.equals(equipmentType.internalName);
    }

    public static void writeEquipmentDatabase(File file) {
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
            bufferedWriter.write("Megamek Equipment Database");
            bufferedWriter.newLine();
            bufferedWriter.write("This file can be regenerated with java -jar MegaMek.jar -eqdb ");
            bufferedWriter.write(file.toString());
            bufferedWriter.newLine();
            bufferedWriter.write("Type,Tech Base,Rules,Name,Aliases");
            bufferedWriter.newLine();
            Enumeration<EquipmentType> enumeration = EquipmentType.getAllTypes();
            while (enumeration.hasMoreElements()) {
                EquipmentType equipmentType = enumeration.nextElement();
                if (equipmentType instanceof AmmoType) {
                    bufferedWriter.write("A,");
                } else if (equipmentType instanceof WeaponType) {
                    bufferedWriter.write("W,");
                } else {
                    bufferedWriter.write("M,");
                }
                bufferedWriter.write(TechConstants.getTechName(equipmentType.getTechLevel()));
                bufferedWriter.write(",");
                bufferedWriter.write(TechConstants.getLevelName(equipmentType.getTechLevel()));
                bufferedWriter.write(",");
                Enumeration<String> enumeration2 = equipmentType.getNames();
                while (enumeration2.hasMoreElements()) {
                    String string = enumeration2.nextElement();
                    bufferedWriter.write(string + ",");
                }
                bufferedWriter.newLine();
            }
            bufferedWriter.flush();
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static void writeEquipmentExtendedDatabase(File file) {
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
            bufferedWriter.write("Megamek Equipment Extended Database");
            bufferedWriter.newLine();
            bufferedWriter.write("This file can be regenerated with java -jar MegaMek.jar -eqedb ");
            bufferedWriter.write(file.toString());
            bufferedWriter.newLine();
            bufferedWriter.write("Type,Tech Base,Rules,Name,Tonnage,Crits,Cost,BV");
            bufferedWriter.newLine();
            Enumeration<EquipmentType> enumeration = EquipmentType.getAllTypes();
            while (enumeration.hasMoreElements()) {
                EquipmentType equipmentType = enumeration.nextElement();
                if (equipmentType instanceof AmmoType) {
                    bufferedWriter.write("A,");
                } else if (equipmentType instanceof WeaponType) {
                    bufferedWriter.write("W,");
                } else {
                    bufferedWriter.write("M,");
                }
                bufferedWriter.write(TechConstants.getTechName(equipmentType.getTechLevel()));
                bufferedWriter.write(",");
                bufferedWriter.write(TechConstants.getLevelName(equipmentType.getTechLevel()));
                bufferedWriter.write(",");
                bufferedWriter.write(equipmentType.getName());
                bufferedWriter.write(",");
                if (equipmentType.tonnage == Float.MIN_VALUE) {
                    bufferedWriter.write("Variable");
                } else {
                    bufferedWriter.write(Float.toString(equipmentType.tonnage));
                }
                bufferedWriter.write(",");
                if (equipmentType.criticals == Integer.MIN_VALUE) {
                    bufferedWriter.write("Variable");
                } else {
                    bufferedWriter.write(Integer.toString(equipmentType.criticals));
                }
                bufferedWriter.write(",");
                if (equipmentType.cost == -2.147483648E9) {
                    bufferedWriter.write("Variable");
                } else {
                    bufferedWriter.write(Double.toString(equipmentType.getCost(null, false)));
                }
                bufferedWriter.write(",");
                if (equipmentType.bv == -2.147483648E9) {
                    bufferedWriter.write("Variable");
                } else {
                    bufferedWriter.write(Double.toString(equipmentType.bv));
                }
                bufferedWriter.newLine();
            }
            bufferedWriter.flush();
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

